/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.ScopedName;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.NullErrorReporter;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.NominalTypeBuilder;
import com.google.javascript.rhino.StaticSymbolTable;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NominalTypeBuilderOti;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeMapReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class TypedScopeCreator
implements ScopeCreator,
StaticSymbolTable<TypedVar, TypedVar> {
    static final String DELEGATE_PROXY_SUFFIX = ObjectType.createDelegateSuffix("Proxy");
    static final DiagnosticType MALFORMED_TYPEDEF = DiagnosticType.warning("JSC_MALFORMED_TYPEDEF", "Typedef for {0} does not have any type information");
    static final DiagnosticType ENUM_INITIALIZER = DiagnosticType.warning("JSC_ENUM_INITIALIZER_NOT_ENUM", "enum initializer must be an object literal or an enum");
    static final DiagnosticType CTOR_INITIALIZER = DiagnosticType.warning("JSC_CTOR_INITIALIZER_NOT_CTOR", "Constructor {0} must be initialized at declaration");
    static final DiagnosticType IFACE_INITIALIZER = DiagnosticType.warning("JSC_IFACE_INITIALIZER_NOT_IFACE", "Interface {0} must be initialized at declaration");
    static final DiagnosticType CONSTRUCTOR_EXPECTED = DiagnosticType.warning("JSC_REFLECT_CONSTRUCTOR_EXPECTED", "Constructor expected as first argument");
    static final DiagnosticType UNKNOWN_LENDS = DiagnosticType.warning("JSC_UNKNOWN_LENDS", "Variable {0} not declared before @lends annotation.");
    static final DiagnosticType LENDS_ON_NON_OBJECT = DiagnosticType.warning("JSC_LENDS_ON_NON_OBJECT", "May only lend properties to object types. {0} has type {1}.");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(DELEGATE_PROXY_SUFFIX, MALFORMED_TYPEDEF, ENUM_INITIALIZER, CTOR_INITIALIZER, IFACE_INITIALIZER, CONSTRUCTOR_EXPECTED, UNKNOWN_LENDS, LENDS_ON_NON_OBJECT);
    private final AbstractCompiler compiler;
    private final ErrorReporter typeParsingErrorReporter;
    private final TypeValidator validator;
    private final CodingConvention codingConvention;
    private final JSTypeRegistry typeRegistry;
    private final List<FunctionType> delegateProxyCtors = new ArrayList<FunctionType>();
    private final Map<String, String> delegateCallingConventions = new HashMap<String, String>();
    private final Map<Node, TypedScope> memoized = new LinkedHashMap<Node, TypedScope>();
    private final boolean runsAfterNTI;
    private final Set<Node> functionsWithNonEmptyReturns = new HashSet<Node>();
    private final Set<ScopedName> escapedVarNames = new HashSet<ScopedName>();
    private final Multiset<ScopedName> assignedVarNames = HashMultiset.create();
    private final ObjectType unknownType;

    TypedScopeCreator(AbstractCompiler compiler) {
        this(compiler, compiler.getCodingConvention());
    }

    TypedScopeCreator(AbstractCompiler compiler, CodingConvention codingConvention) {
        this.compiler = compiler;
        this.runsAfterNTI = compiler.getOptions().getNewTypeInference();
        this.validator = compiler.getTypeValidator();
        this.codingConvention = codingConvention;
        this.typeRegistry = compiler.getTypeRegistry();
        this.typeParsingErrorReporter = this.runsAfterNTI ? NullErrorReporter.forOldRhino() : this.typeRegistry.getErrorReporter();
        this.unknownType = this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    private void report(JSError error) {
        if (!this.runsAfterNTI || this.compiler.getOptions().reportOTIErrorsUnderNTI) {
            this.compiler.report(error);
        }
    }

    @Override
    public ImmutableList<TypedVar> getReferences(TypedVar var) {
        return ImmutableList.of((Object)var);
    }

    public TypedScope getScope(TypedVar var) {
        return (TypedScope)var.scope;
    }

    @Override
    public Iterable<TypedVar> getAllSymbols() {
        ArrayList<TypedVar> vars = new ArrayList<TypedVar>();
        for (TypedScope s : this.memoized.values()) {
            Iterables.addAll(vars, (Iterable)s.getAllSymbols());
        }
        return vars;
    }

    Collection<TypedScope> getAllMemoizedScopes() {
        return Lists.reverse((List)ImmutableList.copyOf(this.memoized.values()));
    }

    void removeScopesForScript(String scriptName) {
        this.memoized.keySet().removeIf(n -> scriptName.equals(NodeUtil.getSourceName(n)));
    }

    TypedScope createScope(Node n) {
        TypedScope s = this.memoized.get(n);
        return s != null ? s : this.createScope(n, (AbstractScope)this.createScope(NodeUtil.getEnclosingNode(n.getParent(), (com.google.common.base.Predicate<Node>)((com.google.common.base.Predicate)NodeUtil::isValidCfgRoot))));
    }

    public TypedScope createScope(Node root, AbstractScope<?, ?> parent) {
        Preconditions.checkArgument((parent == null || parent instanceof TypedScope ? 1 : 0) != 0);
        TypedScope typedParent = (TypedScope)parent;
        TypedScope scope = this.memoized.get(root);
        if (scope != null) {
            Preconditions.checkState((typedParent == scope.getParent() ? 1 : 0) != 0);
        } else {
            scope = this.createScopeInternal(root, typedParent);
            this.memoized.put(root, scope);
        }
        return scope;
    }

    private TypedScope createScopeInternal(Node root, TypedScope typedParent) {
        TypedScope newScope = null;
        AbstractScopeBuilder scopeBuilder = null;
        if (typedParent == null) {
            ObjectType globalThis = this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
            root.setJSType(globalThis);
            root.getFirstChild().setJSType(globalThis);
            root.getLastChild().setJSType(globalThis);
            new FirstOrderFunctionAnalyzer().process(root.getFirstChild(), root.getLastChild());
            newScope = this.createInitialScope(root);
            scopeBuilder = new GlobalScopeBuilder(newScope);
        } else {
            newScope = new TypedScope(typedParent, root);
            scopeBuilder = new LocalScopeBuilder(newScope);
        }
        scopeBuilder.build();
        scopeBuilder.resolveStubDeclarations();
        if (typedParent == null) {
            ArrayList<NominalTypeBuilder> delegateProxies = new ArrayList<NominalTypeBuilder>();
            for (FunctionType delegateProxyCtor : this.delegateProxyCtors) {
                delegateProxies.add(new NominalTypeBuilderOti(delegateProxyCtor, delegateProxyCtor.getInstanceType()));
            }
            this.codingConvention.defineDelegateProxyPrototypeProperties(this.typeRegistry, delegateProxies, this.delegateCallingConventions);
        }
        newScope.setTypeResolver(scopeBuilder);
        return newScope;
    }

    void patchGlobalScope(TypedScope globalScope, Node scriptRoot) {
        Preconditions.checkState((boolean)scriptRoot.isScript());
        Preconditions.checkNotNull((Object)globalScope);
        Preconditions.checkState((boolean)globalScope.isGlobal());
        String scriptName = NodeUtil.getSourceName(scriptRoot);
        Preconditions.checkNotNull((Object)scriptName);
        Predicate<ScopedName> inScript = var -> scriptName.equals(NodeUtil.getSourceName(var.getScopeRoot()));
        this.escapedVarNames.removeIf(inScript);
        this.assignedVarNames.elementSet().removeIf(inScript);
        this.functionsWithNonEmptyReturns.removeIf(n -> scriptName.equals(NodeUtil.getSourceName(n)));
        new FirstOrderFunctionAnalyzer().process(null, scriptRoot);
        ArrayList<TypedVar> varsToRemove = new ArrayList<TypedVar>();
        for (TypedVar oldVar : globalScope.getVarIterable()) {
            if (!scriptName.equals(oldVar.getInputName())) continue;
            varsToRemove.add(oldVar);
        }
        for (TypedVar var2 : varsToRemove) {
            String typeName = var2.getName();
            globalScope.undeclare(var2);
            globalScope.getTypeOfThis().toObjectType().removeProperty(typeName);
            if (this.typeRegistry.getType(typeName) == null) continue;
            this.typeRegistry.removeType(typeName);
        }
        GlobalScopeBuilder scopeBuilder = new GlobalScopeBuilder(globalScope);
        NodeTraversal.traverseTyped(this.compiler, scriptRoot, scopeBuilder);
    }

    @VisibleForTesting
    TypedScope createInitialScope(Node root) {
        NodeTraversal.traverseTyped(this.compiler, root, new DiscoverEnumsAndTypedefs(this.typeRegistry));
        TypedScope s = TypedScope.createGlobalScope(root);
        this.declareNativeFunctionType(s, JSTypeNative.ARRAY_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.BOOLEAN_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.DATE_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.EVAL_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.FUNCTION_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.GENERATOR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.ITERABLE_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.ITERATOR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.NUMBER_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.RANGE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.REFERENCE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.REGEXP_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.STRING_OBJECT_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.SYNTAX_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.TYPE_ERROR_FUNCTION_TYPE);
        this.declareNativeFunctionType(s, JSTypeNative.URI_ERROR_FUNCTION_TYPE);
        this.declareNativeValueType(s, "undefined", JSTypeNative.VOID_TYPE);
        return s;
    }

    private void declareNativeFunctionType(TypedScope scope, JSTypeNative tId) {
        FunctionType t = this.typeRegistry.getNativeFunctionType(tId);
        TypedScopeCreator.declareNativeType(scope, t.getInstanceType().getReferenceName(), t);
        TypedScopeCreator.declareNativeType(scope, t.getPrototype().getReferenceName(), t.getPrototype());
    }

    private void declareNativeValueType(TypedScope scope, String name, JSTypeNative tId) {
        TypedScopeCreator.declareNativeType(scope, name, this.typeRegistry.getNativeType(tId));
    }

    private static void declareNativeType(TypedScope scope, String name, JSType t) {
        scope.declare(name, null, t, null, false);
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        return this.typeRegistry.getNativeType(nativeType);
    }

    @Override
    public boolean hasBlockScope() {
        return false;
    }

    private class FirstOrderFunctionAnalyzer
    extends NodeTraversal.AbstractScopedCallback {
        private FirstOrderFunctionAnalyzer() {
        }

        void process(Node externs, Node root) {
            if (externs == null) {
                NodeTraversal.traverseEs6(TypedScopeCreator.this.compiler, root, this);
            } else {
                NodeTraversal.traverseRootsEs6(TypedScopeCreator.this.compiler, this, externs, root);
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (t.inGlobalScope()) {
                return;
            }
            Node containerScopeRoot = t.getClosestContainerScopeRoot();
            if (n.isReturn() && n.getFirstChild() != null) {
                TypedScopeCreator.this.functionsWithNonEmptyReturns.add(containerScopeRoot);
            }
            if (n.isName() && NodeUtil.isLValue(n) && !NodeUtil.isBleedingFunctionName(n)) {
                Scope ownerScope;
                String name = n.getString();
                Scope scope = t.getScope();
                Var var = (Var)scope.getVar(name);
                if (var != null && (ownerScope = (Scope)((Scope)var.getScope()).getClosestContainerScope()).isLocal()) {
                    Node ownerScopeRoot = ownerScope.getRootNode();
                    TypedScopeCreator.this.assignedVarNames.add((Object)ScopedName.of(name, ownerScopeRoot));
                    if (containerScopeRoot != ownerScopeRoot) {
                        TypedScopeCreator.this.escapedVarNames.add(ScopedName.of(name, ownerScopeRoot));
                    }
                }
            } else if (n.isGetProp() && n.isUnscopedQualifiedName() && NodeUtil.isLValue(n)) {
                String name = NodeUtil.getRootOfQualifiedName(n).getString();
                Scope scope = t.getScope();
                Var var = (Var)scope.getVar(name);
                if (var != null) {
                    Scope ownerScope = (Scope)((Scope)var.getScope()).getClosestContainerScope();
                    Node ownerScopeRoot = ownerScope.getRootNode();
                    if (ownerScope.isLocal() && containerScopeRoot != ownerScopeRoot) {
                        TypedScopeCreator.this.escapedVarNames.add(ScopedName.of(n.getQualifiedName(), ownerScopeRoot));
                    }
                }
            }
        }
    }

    private final class LocalScopeBuilder
    extends AbstractScopeBuilder {
        private final ObjectType thisTypeForProperties;

        private LocalScopeBuilder(TypedScope scope) {
            super(scope);
            this.thisTypeForProperties = this.getThisTypeForCollectingProperties();
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n == this.scope.getRootNode()) {
                return;
            }
            if (n.isParamList() && parent == this.scope.getRootNode()) {
                this.handleFunctionInputs(parent);
                return;
            }
            if (this.thisTypeForProperties != null && n.getParent().isExprResult()) {
                if (n.isAssign()) {
                    this.maybeCollectMember(n.getFirstChild(), n, n.getLastChild());
                } else if (n.isGetProp()) {
                    this.maybeCollectMember(n, n, null);
                }
            }
            super.visit(t, n, parent);
        }

        private ObjectType getThisTypeForCollectingProperties() {
            Node rootNode = this.scope.getRootNode();
            if (rootNode.isFromExterns()) {
                return null;
            }
            JSType type = rootNode.getJSType();
            if (type == null || !type.isFunctionType()) {
                return null;
            }
            FunctionType fnType = type.toMaybeFunctionType();
            JSType fnThisType = fnType.getTypeOfThis();
            return fnThisType == null ? null : fnThisType.toObjectType();
        }

        private void maybeCollectMember(Node member, Node nodeWithJsDocInfo, @Nullable Node value) {
            JSDocInfo info = nodeWithJsDocInfo.getJSDocInfo();
            if (info == null || !member.isGetProp() || !member.getFirstChild().isThis()) {
                return;
            }
            JSType jsType = this.getDeclaredType(info, member, value);
            Node name = member.getLastChild();
            if (jsType != null) {
                this.thisTypeForProperties.defineDeclaredProperty(name.getString(), jsType, member);
            }
        }

        private void handleFunctionInputs(Node fnNode) {
            TypedVar fnVar;
            Node fnNameNode = fnNode.getFirstChild();
            String fnName = fnNameNode.getString();
            if (!fnName.isEmpty() && ((fnVar = (TypedVar)this.scope.getVar(fnName)) == null || fnVar.getNameNode() != null && fnVar.getInitialValue() != fnNode)) {
                this.defineSlot(fnNameNode, fnNode, fnNode.getJSType(), false);
            }
            this.declareArguments(fnNode);
        }

        private void declareArguments(Node functionNode) {
            Node jsDocParameters;
            FunctionType functionType;
            Node astParameters = functionNode.getSecondChild();
            Node iifeArgumentNode = null;
            if (NodeUtil.isInvocationTarget(functionNode)) {
                iifeArgumentNode = functionNode.getNext();
            }
            if ((functionType = JSType.toMaybeFunctionType(functionNode.getJSType())) != null && (jsDocParameters = functionType.getParametersNode()) != null) {
                Node jsDocParameter = jsDocParameters.getFirstChild();
                for (Node astParameter : astParameters.children()) {
                    boolean inferred;
                    JSType paramType = jsDocParameter == null ? TypedScopeCreator.this.unknownType : jsDocParameter.getJSType();
                    boolean bl = inferred = paramType == null || paramType.equals(TypedScopeCreator.this.unknownType);
                    if (iifeArgumentNode != null && inferred) {
                        TypedVar argumentVar;
                        String argumentName = iifeArgumentNode.getQualifiedName();
                        TypedVar typedVar = argumentVar = argumentName == null || this.scope.getParent() == null ? null : (TypedVar)this.scope.getParent().getVar(argumentName);
                        if (argumentVar != null && !argumentVar.isTypeInferred()) {
                            paramType = argumentVar.getType();
                        }
                    }
                    if (paramType == null) {
                        paramType = TypedScopeCreator.this.unknownType;
                    }
                    this.defineSlot(astParameter, functionNode, paramType, inferred);
                    if (jsDocParameter != null) {
                        jsDocParameter = jsDocParameter.getNext();
                    }
                    if (iifeArgumentNode == null) continue;
                    iifeArgumentNode = iifeArgumentNode.getNext();
                }
            }
        }
    }

    private final class GlobalScopeBuilder
    extends AbstractScopeBuilder {
        private GlobalScopeBuilder(TypedScope scope) {
            super(scope);
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            super.visit(t, n, parent);
            switch (n.getToken()) {
                case VAR: {
                    if (!n.hasOneChild()) break;
                    this.checkForTypedef(n.getFirstChild(), n.getJSDocInfo());
                    break;
                }
            }
        }

        @Override
        void maybeDeclareQualifiedName(NodeTraversal t, JSDocInfo info, Node n, Node parent, Node rhsValue) {
            this.checkForTypedef(n, info);
            super.maybeDeclareQualifiedName(t, info, n, parent, rhsValue);
        }

        private void checkForTypedef(Node candidate, JSDocInfo info) {
            if (info == null || !info.hasTypedefType()) {
                return;
            }
            String typedef = candidate.getQualifiedName();
            if (typedef == null) {
                return;
            }
            TypedScopeCreator.this.typeRegistry.declareType(typedef, TypedScopeCreator.this.unknownType);
            JSType realType = info.getTypedefType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
            if (realType == null) {
                TypedScopeCreator.this.report(JSError.make(candidate, MALFORMED_TYPEDEF, typedef));
            }
            TypedScopeCreator.this.typeRegistry.overwriteDeclaredType(typedef, realType);
            if (candidate.isGetProp()) {
                this.defineSlot(candidate, candidate.getParent(), TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE), false);
            }
        }
    }

    private static final class StubDeclaration {
        private final Node node;
        private final boolean isExtern;
        private final String ownerName;

        private StubDeclaration(Node node, boolean isExtern, String ownerName) {
            this.node = node;
            this.isExtern = isExtern;
            this.ownerName = ownerName;
        }
    }

    private abstract class AbstractScopeBuilder
    implements NodeTraversal.Callback,
    TypedScope.TypeResolver {
        final TypedScope scope;
        private final List<DeferredSetType> deferredSetTypes = new ArrayList<DeferredSetType>();
        private final List<Node> nonExternFunctions = new ArrayList<Node>();
        private List<Node> lentObjectLiterals = null;
        private final List<StubDeclaration> stubDeclarations = new ArrayList<StubDeclaration>();
        private String sourceName = null;
        private InputId inputId;

        private AbstractScopeBuilder(TypedScope scope) {
            this.scope = scope;
        }

        void build() {
            NodeTraversal.traverseTyped(TypedScopeCreator.this.compiler, this.scope.getRootNode(), this);
        }

        void setDeferredType(Node node, JSType type) {
            node.setJSType(type);
            this.deferredSetTypes.add(new DeferredSetType(node, type));
        }

        @Override
        public void resolveTypes() {
            for (DeferredSetType deferred : this.deferredSetTypes) {
                deferred.resolve(this.scope);
            }
            for (TypedVar var : this.scope.getVarIterable()) {
                var.resolveType(TypedScopeCreator.this.typeParsingErrorReporter);
            }
            TypedScopeCreator.this.typeRegistry.resolveTypesInScope(this.scope);
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            boolean descend;
            this.inputId = t.getInputId();
            if (n.isFunction() || n.isScript()) {
                Preconditions.checkNotNull((Object)this.inputId);
                this.sourceName = NodeUtil.getSourceName(n);
            }
            boolean bl = descend = parent == null || !parent.isFunction() || n == parent.getFirstChild() || parent == this.scope.getRootNode();
            if (descend && NodeUtil.isStatementParent(n)) {
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    if (!NodeUtil.isHoistedFunctionDeclaration(child)) continue;
                    this.defineFunctionLiteral(child);
                }
            }
            return descend;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            this.inputId = t.getInputId();
            this.attachLiteralTypes(n);
            switch (n.getToken()) {
                case CALL: {
                    this.checkForClassDefiningCalls(n);
                    break;
                }
                case FUNCTION: {
                    if (t.getInput() == null || !t.getInput().isExtern()) {
                        this.nonExternFunctions.add(n);
                    }
                    if (NodeUtil.isHoistedFunctionDeclaration(n)) break;
                    this.defineFunctionLiteral(n);
                    break;
                }
                case ASSIGN: {
                    Node firstChild = n.getFirstChild();
                    if (!firstChild.isGetProp() || !firstChild.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(t, n.getJSDocInfo(), firstChild, n, firstChild.getNext());
                    break;
                }
                case CATCH: {
                    this.defineCatch(n);
                    break;
                }
                case VAR: {
                    this.defineVar(n);
                    break;
                }
                case GETPROP: {
                    this.checkForCallingConventionDefinitions(n);
                    if (!parent.isExprResult() || !n.isQualifiedName()) break;
                    this.maybeDeclareQualifiedName(t, n.getJSDocInfo(), n, parent, null);
                    break;
                }
            }
            if (n.getParent() != null && NodeUtil.isStatement(n) && this.lentObjectLiterals != null) {
                for (Node objLit : this.lentObjectLiterals) {
                    this.defineObjectLiteral(objLit);
                }
                this.lentObjectLiterals.clear();
            }
        }

        private void attachLiteralTypes(Node n) {
            switch (n.getToken()) {
                case NULL: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NULL_TYPE));
                    break;
                }
                case VOID: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.VOID_TYPE));
                    break;
                }
                case STRING: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.STRING_TYPE));
                    break;
                }
                case NUMBER: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.NUMBER_TYPE));
                    break;
                }
                case TRUE: 
                case FALSE: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
                    break;
                }
                case REGEXP: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.REGEXP_TYPE));
                    break;
                }
                case OBJECTLIT: {
                    JSDocInfo info = n.getJSDocInfo();
                    if (info != null && info.getLendsName() != null) {
                        if (this.lentObjectLiterals == null) {
                            this.lentObjectLiterals = new ArrayList<Node>();
                        }
                        this.lentObjectLiterals.add(n);
                        break;
                    }
                    this.defineObjectLiteral(n);
                    break;
                }
                case ARRAYLIT: {
                    n.setJSType(TypedScopeCreator.this.getNativeType(JSTypeNative.ARRAY_TYPE));
                    break;
                }
            }
        }

        private void defineObjectLiteral(Node objectLit) {
            JSType type = null;
            JSDocInfo info = objectLit.getJSDocInfo();
            if (info != null && info.getLendsName() != null) {
                String lendsName = info.getLendsName();
                TypedVar lendsVar = (TypedVar)this.scope.getVar(lendsName);
                if (lendsVar == null) {
                    TypedScopeCreator.this.report(JSError.make(objectLit, UNKNOWN_LENDS, lendsName));
                } else {
                    type = lendsVar.getType();
                    if (type == null) {
                        type = TypedScopeCreator.this.unknownType;
                    }
                    if (!type.isSubtypeOf(TypedScopeCreator.this.typeRegistry.getNativeType(JSTypeNative.OBJECT_TYPE))) {
                        TypedScopeCreator.this.report(JSError.make(objectLit, LENDS_ON_NON_OBJECT, lendsName, type.toString()));
                        type = null;
                    } else {
                        objectLit.setJSType(type);
                    }
                }
            }
            info = NodeUtil.getBestJSDocInfo(objectLit);
            Node lValue = NodeUtil.getBestLValue(objectLit);
            String lValueName = NodeUtil.getBestLValueName(lValue);
            boolean createdEnumType = false;
            if (info != null && info.hasEnumParameterType()) {
                type = this.createEnumTypeFromNodes(objectLit, lValueName, info);
                createdEnumType = true;
            }
            if (type == null) {
                type = TypedScopeCreator.this.typeRegistry.createAnonymousObjectType(info);
            }
            this.setDeferredType(objectLit, type);
            this.processObjectLitProperties(objectLit, ObjectType.cast(objectLit.getJSType()), !createdEnumType);
        }

        void processObjectLitProperties(Node objLit, ObjectType objLitType, boolean declareOnOwner) {
            for (Node keyNode = objLit.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
                Node value = keyNode.getFirstChild();
                String memberName = NodeUtil.getObjectLitKeyName(keyNode);
                JSDocInfo info = keyNode.getJSDocInfo();
                JSType valueType = this.getDeclaredType(info, keyNode, value);
                JSType keyType = objLitType.isEnumType() ? objLitType.toMaybeEnumType().getElementsType() : TypeCheck.getObjectLitKeyTypeFromValueType(keyNode, valueType);
                String qualifiedName = NodeUtil.getBestLValueName(keyNode);
                if (qualifiedName != null) {
                    boolean inferred = keyType == null;
                    this.defineSlot(keyNode, objLit, qualifiedName, keyType, inferred);
                } else if (keyType != null) {
                    this.setDeferredType(keyNode, keyType);
                }
                if (keyType == null || objLitType == null || !declareOnOwner) continue;
                objLitType.defineDeclaredProperty(memberName, keyType, keyNode);
            }
        }

        private JSType getDeclaredTypeInAnnotation(Node node, JSDocInfo info) {
            JSType jsType = null;
            if (info != null) {
                if (info.hasType()) {
                    TypedVar ownerVar;
                    ImmutableList<TemplateType> ownerTypeKeys = ImmutableList.of();
                    Node ownerNode = NodeUtil.getBestLValueOwner(node);
                    String ownerName = NodeUtil.getBestLValueName(ownerNode);
                    ObjectType ownerType = null;
                    if (ownerName != null && (ownerVar = (TypedVar)this.scope.getVar(ownerName)) != null && (ownerType = this.getPrototypeOwnerType(ObjectType.cast(ownerVar.getType()))) != null) {
                        ownerTypeKeys = ownerType.getTemplateTypeMap().getTemplateKeys();
                    }
                    if (!ownerTypeKeys.isEmpty()) {
                        TypedScopeCreator.this.typeRegistry.setTemplateTypeNames((List<TemplateType>)ownerTypeKeys);
                    }
                    jsType = info.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                    if (!ownerTypeKeys.isEmpty()) {
                        TypedScopeCreator.this.typeRegistry.clearTemplateTypeNames();
                    }
                } else if (FunctionTypeBuilder.isFunctionTypeDeclaration(info)) {
                    String fnName = node.getQualifiedName();
                    jsType = this.createFunctionTypeFromNodes(null, fnName, info, node);
                }
            }
            return jsType;
        }

        void assertDefinitionNode(Node n, Token type) {
            Preconditions.checkState((this.sourceName != null ? 1 : 0) != 0);
            Preconditions.checkState((n.getToken() == type ? 1 : 0) != 0, (Object)n);
        }

        void defineCatch(Node n) {
            this.assertDefinitionNode(n, Token.CATCH);
            Node catchName = n.getFirstChild();
            this.defineSlot(catchName, n, this.getDeclaredType(catchName.getJSDocInfo(), catchName, null));
        }

        void defineVar(Node n) {
            this.assertDefinitionNode(n, Token.VAR);
            JSDocInfo info = n.getJSDocInfo();
            if (n.hasMoreThanOneChild()) {
                if (info != null) {
                    TypedScopeCreator.this.report(JSError.make(n, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
                }
                for (Node name : n.children()) {
                    this.defineName(name, n, name.getJSDocInfo());
                }
            } else {
                Node name = n.getFirstChild();
                this.defineName(name, n, info != null ? info : name.getJSDocInfo());
            }
        }

        void defineFunctionLiteral(Node n) {
            this.assertDefinitionNode(n, Token.FUNCTION);
            Node lValue = NodeUtil.getBestLValue(n);
            JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
            String functionName = NodeUtil.getBestLValueName(lValue);
            FunctionType functionType = this.createFunctionTypeFromNodes(n, functionName, info, lValue);
            this.setDeferredType(n, functionType);
            if (NodeUtil.isFunctionDeclaration(n)) {
                this.defineSlot(n.getFirstChild(), n, functionType);
            }
        }

        private void defineName(Node name, Node var, JSDocInfo info) {
            Node value = name.getFirstChild();
            JSType type = this.getDeclaredType(info, name, value);
            if (type == null) {
                type = name.isFromExterns() ? TypedScopeCreator.this.unknownType : null;
            }
            this.defineSlot(name, var, type);
        }

        private boolean shouldUseFunctionLiteralType(FunctionType type, JSDocInfo info, Node lValue) {
            if (info != null) {
                return true;
            }
            if (lValue != null && NodeUtil.isObjectLitKey(lValue)) {
                return false;
            }
            return this.scope.isGlobal() || !type.isReturnTypeInferred();
        }

        private FunctionType createFunctionTypeFromNodes(@Nullable Node rValue, @Nullable String name, @Nullable JSDocInfo info, @Nullable Node lvalueNode) {
            FunctionType aliasedType;
            TypedVar var;
            FunctionType functionType = null;
            if (rValue != null && rValue.isQualifiedName() && this.scope.isGlobal() && (var = (TypedVar)this.scope.getVar(rValue.getQualifiedName())) != null && var.getType() != null && var.getType().isFunctionType() && ((aliasedType = var.getType().toMaybeFunctionType()).isConstructor() || aliasedType.isInterface()) && !this.isGoogAbstractMethod(rValue)) {
                functionType = aliasedType;
                if (name != null && this.scope.isGlobal()) {
                    TypedScopeCreator.this.typeRegistry.declareType(name, functionType.getInstanceType());
                }
            }
            if (functionType == null) {
                Node parametersNode;
                Node errorRoot = rValue == null ? lvalueNode : rValue;
                boolean isFnLiteral = rValue != null && rValue.isFunction();
                Node fnRoot = isFnLiteral ? rValue : null;
                Node node = parametersNode = isFnLiteral ? rValue.getSecondChild() : null;
                if (info != null && info.hasType()) {
                    JSType type = info.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                    if ((type = type.restrictByNotNullOrUndefined()).isFunctionType()) {
                        functionType = type.toMaybeFunctionType();
                        functionType.setJSDocInfo(info);
                    }
                }
                if (functionType == null) {
                    FunctionTypeBuilder.AstFunctionContents contents;
                    Node ownerNode = NodeUtil.getBestLValueOwner(lvalueNode);
                    String ownerName = NodeUtil.getBestLValueName(ownerNode);
                    TypedVar ownerVar = null;
                    String propName = null;
                    ObjectType ownerType = null;
                    if (ownerName != null) {
                        ownerVar = (TypedVar)this.scope.getVar(ownerName);
                        if (ownerVar != null) {
                            ownerType = ObjectType.cast(ownerVar.getType());
                        }
                        if (name != null) {
                            propName = name.substring(ownerName.length() + 1);
                        }
                    }
                    ObjectType prototypeOwner = this.getPrototypeOwnerType(ownerType);
                    TemplateTypeMap prototypeOwnerTypeMap = null;
                    if (prototypeOwner != null && prototypeOwner.getTypeOfThis() != null) {
                        prototypeOwnerTypeMap = prototypeOwner.getTypeOfThis().getTemplateTypeMap();
                    }
                    FunctionType overriddenType = null;
                    if (ownerType != null && propName != null) {
                        overriddenType = this.findOverriddenFunction(ownerType, propName, prototypeOwnerTypeMap);
                    }
                    FunctionTypeBuilder.AstFunctionContents astFunctionContents = contents = fnRoot != null ? new FunctionTypeBuilder.AstFunctionContents(fnRoot) : null;
                    if (TypedScopeCreator.this.functionsWithNonEmptyReturns.contains(fnRoot)) {
                        contents.recordNonEmptyReturn();
                    }
                    FunctionTypeBuilder builder = new FunctionTypeBuilder(name, TypedScopeCreator.this.compiler, errorRoot, this.scope).setContents(contents).inferFromOverriddenFunction(overriddenType, parametersNode).inferTemplateTypeName(info, prototypeOwner).inferInheritance(info);
                    if (info == null || !info.hasReturnType()) {
                        if (rValue != null && rValue.isFunction() && rValue.getFirstChild() != null) {
                            JSDocInfo nameDocInfo = rValue.getFirstChild().getJSDocInfo();
                            builder.inferReturnType(nameDocInfo, true);
                        }
                    } else {
                        builder.inferReturnType(info, false);
                    }
                    boolean searchedForThisType = false;
                    if (ownerType != null && ownerType.isFunctionPrototypeType() && ownerType.getOwnerFunction().hasInstanceType()) {
                        builder.inferThisType(info, ownerType.getOwnerFunction().getInstanceType());
                        searchedForThisType = true;
                    } else if (ownerNode != null && ownerNode.isThis()) {
                        builder.inferThisType(info, this.scope.getTypeOfThis());
                        searchedForThisType = true;
                    }
                    if (!searchedForThisType) {
                        builder.inferThisType(info);
                    }
                    functionType = builder.inferParameterTypes(parametersNode, info).buildAndRegister();
                }
            }
            if (info != null && info.isInterface() && info.usesImplicitMatch()) {
                functionType.setImplicitMatch(true);
            }
            return functionType;
        }

        private boolean isGoogAbstractMethod(Node n) {
            return n.matchesQualifiedName("goog.abstractMethod");
        }

        private ObjectType getPrototypeOwnerType(ObjectType ownerType) {
            if (ownerType != null && ownerType.isFunctionPrototypeType()) {
                return ownerType.getOwnerFunction();
            }
            return null;
        }

        private FunctionType findOverriddenFunction(ObjectType ownerType, String propName, TemplateTypeMap typeMap) {
            FunctionType result = null;
            JSType propType = ownerType.getPropertyType(propName);
            if (propType != null && propType.isFunctionType()) {
                result = propType.toMaybeFunctionType();
            } else {
                for (ObjectType iface : ownerType.getCtorImplementedInterfaces()) {
                    propType = iface.getPropertyType(propName);
                    if (propType == null || !propType.isFunctionType()) continue;
                    result = propType.toMaybeFunctionType();
                    break;
                }
            }
            if (result != null && typeMap != null && !typeMap.isEmpty()) {
                result = result.visit(new TemplateTypeMapReplacer(TypedScopeCreator.this.typeRegistry, typeMap)).toMaybeFunctionType();
            }
            return result;
        }

        private EnumType createEnumTypeFromNodes(Node rValue, String name, JSDocInfo info) {
            TypedVar var;
            Preconditions.checkNotNull((Object)info);
            Preconditions.checkState((boolean)info.hasEnumParameterType());
            EnumType enumType = null;
            if (rValue != null && rValue.isQualifiedName() && (var = (TypedVar)this.scope.getVar(rValue.getQualifiedName())) != null && var.getType() instanceof EnumType) {
                enumType = (EnumType)var.getType();
            }
            if (enumType == null) {
                JSType elementsType = info.getEnumParameterType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
                enumType = TypedScopeCreator.this.typeRegistry.createEnumType(name, rValue, elementsType);
                if (rValue != null && rValue.isObjectLit()) {
                    for (Node key = rValue.getFirstChild(); key != null; key = key.getNext()) {
                        String keyName = key.getString();
                        Preconditions.checkNotNull((Object)keyName, (String)"Invalid enum key: %s", (Object)key);
                        enumType.defineElement(keyName, key);
                    }
                }
            }
            if (name != null && this.scope.isGlobal()) {
                TypedScopeCreator.this.typeRegistry.declareType(name, enumType.getElementsType());
            }
            return enumType;
        }

        private void defineSlot(Node name, Node parent, JSType type) {
            this.defineSlot(name, parent, type, type == null);
        }

        void defineSlot(Node n, Node parent, JSType type, boolean inferred) {
            Preconditions.checkArgument((inferred || type != null ? 1 : 0) != 0);
            if (n.isName()) {
                Preconditions.checkArgument((parent.isFunction() || parent.isVar() || parent.isParamList() || parent.isCatch() ? 1 : 0) != 0);
            } else {
                Preconditions.checkArgument((n.isGetProp() && (parent.isAssign() || parent.isExprResult()) ? 1 : 0) != 0);
            }
            this.defineSlot(n, parent, n.getQualifiedName(), type, inferred);
        }

        void defineSlot(Node n, Node parent, String variableName, JSType type, boolean inferred) {
            TypedScope globalScope;
            Preconditions.checkArgument((!variableName.isEmpty() ? 1 : 0) != 0);
            boolean isGlobalVar = n.isName() && this.scope.isGlobal();
            boolean shouldDeclareOnGlobalThis = isGlobalVar && (parent.isVar() || parent.isFunction());
            TypedScope scopeToDeclareIn = this.scope;
            if (n.isGetProp() && !this.scope.isGlobal() && this.isQnameRootedInGlobalScope(n) && !(globalScope = (TypedScope)this.scope.getGlobalScope()).hasOwnSlot(variableName)) {
                scopeToDeclareIn = (TypedScope)this.scope.getGlobalScope();
            }
            TypedVar newVar = null;
            CompilerInput input = TypedScopeCreator.this.compiler.getInput(this.inputId);
            if (scopeToDeclareIn.hasOwnSlot(variableName)) {
                TypedVar oldVar = (TypedVar)scopeToDeclareIn.getVar(variableName);
                newVar = TypedScopeCreator.this.validator.expectUndeclaredVariable(this.sourceName, input, n, parent, oldVar, variableName, type);
            } else {
                if (type != null) {
                    this.setDeferredType(n, type);
                }
                newVar = this.declare(scopeToDeclareIn, variableName, n, type, input, inferred);
                if (type instanceof EnumType) {
                    boolean isValidValue;
                    Node initialValue = newVar.getInitialValue();
                    boolean bl = isValidValue = initialValue != null && (initialValue.isObjectLit() || initialValue.isQualifiedName());
                    if (!isValidValue) {
                        TypedScopeCreator.this.report(JSError.make(n, ENUM_INITIALIZER, new String[0]));
                    }
                }
            }
            FunctionType fnType = JSType.toMaybeFunctionType(type);
            if (fnType != null && !type.isEmptyType() && (fnType.isConstructor() || fnType.isInterface()) && variableName.equals(fnType.getReferenceName())) {
                this.finishConstructorDefinition(n, variableName, fnType, scopeToDeclareIn, input, newVar);
            }
            if (shouldDeclareOnGlobalThis) {
                ObjectType globalThis = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS);
                if (inferred) {
                    globalThis.defineInferredProperty(variableName, type == null ? TypedScopeCreator.this.getNativeType(JSTypeNative.NO_TYPE) : type, n);
                } else {
                    globalThis.defineDeclaredProperty(variableName, type, n);
                }
            }
            if (isGlobalVar && "Window".equals(variableName) && type != null && type.isFunctionType() && type.isConstructor()) {
                FunctionType globalThisCtor = TypedScopeCreator.this.typeRegistry.getNativeObjectType(JSTypeNative.GLOBAL_THIS).getConstructor();
                globalThisCtor.getInstanceType().clearCachedValues();
                globalThisCtor.getPrototype().clearCachedValues();
                globalThisCtor.setPrototypeBasedOn(type.toMaybeFunctionType().getInstanceType());
            }
        }

        private TypedVar declare(TypedScope scope, String name, Node n, JSType type, CompilerInput input, boolean inferred) {
            TypedVar var = scope.declare(name, n, type, input, inferred);
            ScopedName scopedName = ScopedName.of(name, scope.getRootNode());
            if (TypedScopeCreator.this.escapedVarNames.contains(scopedName)) {
                var.markEscaped();
            }
            if (TypedScopeCreator.this.assignedVarNames.count((Object)scopedName) == 1) {
                var.markAssignedExactlyOnce();
            }
            return var;
        }

        private void finishConstructorDefinition(Node n, String variableName, FunctionType fnType, TypedScope scopeToDeclareIn, CompilerInput input, TypedVar newVar) {
            FunctionType superClassCtor = fnType.getSuperClassConstructor();
            Property prototypeSlot = fnType.getSlot("prototype");
            prototypeSlot.setNode(n);
            String prototypeName = variableName + ".prototype";
            TypedVar prototypeVar = (TypedVar)scopeToDeclareIn.getVar(prototypeName);
            if (prototypeVar != null && prototypeVar.scope == scopeToDeclareIn) {
                scopeToDeclareIn.undeclare(prototypeVar);
            }
            scopeToDeclareIn.declare(prototypeName, n, prototypeSlot.getType(), input, superClassCtor == null || superClassCtor.getInstanceType().isEquivalentTo(TypedScopeCreator.this.getNativeType(JSTypeNative.OBJECT_TYPE)));
            if (newVar.getInitialValue() == null && !n.isFromExterns()) {
                TypedScopeCreator.this.report(JSError.make(n, fnType.isConstructor() ? CTOR_INITIALIZER : IFACE_INITIALIZER, variableName));
            }
        }

        private boolean isQnameRootedInGlobalScope(Node n) {
            TypedScope scope = this.getQnameRootScope(n);
            return scope != null && scope.isGlobal();
        }

        private TypedScope getQnameRootScope(Node n) {
            TypedVar var;
            Node root = NodeUtil.getRootOfQualifiedName(n);
            if (root.isName() && (var = (TypedVar)this.scope.getVar(root.getString())) != null) {
                return (TypedScope)var.getScope();
            }
            return null;
        }

        JSType getDeclaredType(JSDocInfo info, Node lValue, @Nullable Node rValue) {
            JSType rValueType;
            if (info != null && info.hasType()) {
                return this.getDeclaredTypeInAnnotation(lValue, info);
            }
            if (rValue != null && rValue.isFunction() && this.shouldUseFunctionLiteralType(JSType.toMaybeFunctionType(rValue.getJSType()), info, lValue)) {
                return rValue.getJSType();
            }
            if (info != null) {
                if (info.hasEnumParameterType()) {
                    if (rValue != null && rValue.isObjectLit()) {
                        return rValue.getJSType();
                    }
                    return this.createEnumTypeFromNodes(rValue, lValue.getQualifiedName(), info);
                }
                if (info.isConstructorOrInterface()) {
                    return this.createFunctionTypeFromNodes(rValue, lValue.getQualifiedName(), info, lValue);
                }
            }
            if (NodeUtil.isConstantDeclaration(TypedScopeCreator.this.compiler.getCodingConvention(), info, lValue) && rValue != null && (rValueType = this.getDeclaredRValueType(lValue, rValue)) != null) {
                if (lValue.isQualifiedName() && rValueType.isFunctionType() && rValueType.toMaybeFunctionType().hasInstanceType()) {
                    FunctionType functionType = rValueType.toMaybeFunctionType();
                    TypedScopeCreator.this.typeRegistry.declareType(lValue.getQualifiedName(), functionType.getInstanceType());
                }
                return rValueType;
            }
            return this.getDeclaredTypeInAnnotation(lValue, info);
        }

        private JSType getDeclaredRValueType(Node lValue, Node rValue) {
            FunctionType fnType;
            JSType targetType;
            JSDocInfo rValueInfo = rValue.getJSDocInfo();
            if (rValue.isCast() && rValueInfo != null && rValueInfo.hasType()) {
                return rValueInfo.getType().evaluate(this.scope, TypedScopeCreator.this.typeRegistry);
            }
            JSType type = rValue.getJSType();
            if (type != null && !type.isUnknownType()) {
                return type;
            }
            if (rValue.isQualifiedName()) {
                return this.lookupQualifiedName(rValue);
            }
            if (NodeUtil.isBooleanResult(rValue)) {
                return TypedScopeCreator.this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
            }
            if (NodeUtil.isNumericResult(rValue)) {
                return TypedScopeCreator.this.getNativeType(JSTypeNative.NUMBER_TYPE);
            }
            if (NodeUtil.isStringResult(rValue)) {
                return TypedScopeCreator.this.getNativeType(JSTypeNative.STRING_TYPE);
            }
            if (rValue.isNew() && rValue.getFirstChild().isQualifiedName() && (targetType = this.lookupQualifiedName(rValue.getFirstChild())) != null && (fnType = targetType.restrictByNotNullOrUndefined().toMaybeFunctionType()) != null && fnType.hasInstanceType()) {
                return fnType.getInstanceType();
            }
            if (rValue.isOr()) {
                boolean namesMatch;
                Node firstClause = rValue.getFirstChild();
                Node secondClause = firstClause.getNext();
                boolean bl = namesMatch = firstClause.isName() && lValue.isName() && firstClause.getString().equals(lValue.getString());
                if (namesMatch && (type = secondClause.getJSType()) != null && !type.isUnknownType()) {
                    return type;
                }
            }
            return null;
        }

        private JSType lookupQualifiedName(Node n) {
            JSType type;
            String name = n.getQualifiedName();
            TypedVar slot = (TypedVar)this.scope.getVar(name);
            if (slot != null && !slot.isTypeInferred()) {
                JSType type2 = slot.getType();
                if (type2 != null && !type2.isUnknownType()) {
                    return type2;
                }
            } else if (n.isGetProp() && (type = this.lookupQualifiedName(n.getFirstChild())) != null && type.isRecordType()) {
                JSType propType = type.findPropertyType(n.getLastChild().getString());
                return propType;
            }
            return null;
        }

        private void checkForCallingConventionDefinitions(Node n) {
            TypedScopeCreator.this.codingConvention.checkForCallingConventionDefinitions(n, TypedScopeCreator.this.delegateCallingConventions);
        }

        private void checkForClassDefiningCalls(Node n) {
            CodingConvention.ObjectLiteralCast objectLiteralCast;
            CodingConvention.DelegateRelationship delegateRelationship;
            FunctionType functionType;
            ObjectType objectType;
            String singletonGetterClassName;
            CodingConvention.SubclassRelationship relationship = TypedScopeCreator.this.codingConvention.getClassesDefinedByCall(n);
            if (relationship != null) {
                ObjectType superClass = TypeValidator.getInstanceOfCtor((TypedVar)this.scope.getVar(relationship.superclassName));
                ObjectType subClass = TypeValidator.getInstanceOfCtor((TypedVar)this.scope.getVar(relationship.subclassName));
                if (superClass != null && subClass != null) {
                    FunctionType superCtor = superClass.getConstructor();
                    FunctionType subCtor = subClass.getConstructor();
                    if (superCtor != null && subCtor != null) {
                        TypedScopeCreator.this.codingConvention.applySubclassRelationship(new NominalTypeBuilderOti(superCtor, superClass), new NominalTypeBuilderOti(subCtor, subClass), relationship.type);
                    }
                }
            }
            if ((singletonGetterClassName = TypedScopeCreator.this.codingConvention.getSingletonGetterClassName(n)) != null && (objectType = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(singletonGetterClassName))) != null && (functionType = objectType.getConstructor()) != null) {
                FunctionType getterType = TypedScopeCreator.this.typeRegistry.createFunctionType((JSType)objectType, new JSType[0]);
                TypedScopeCreator.this.codingConvention.applySingletonGetter(new NominalTypeBuilderOti(functionType, objectType), getterType);
            }
            if ((delegateRelationship = TypedScopeCreator.this.codingConvention.getDelegateRelationship(n)) != null) {
                this.applyDelegateRelationship(delegateRelationship);
            }
            if ((objectLiteralCast = TypedScopeCreator.this.codingConvention.getObjectLiteralCast(n)) != null) {
                if (objectLiteralCast.diagnosticType == null) {
                    ObjectType type = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(objectLiteralCast.typeName));
                    if (type != null && type.getConstructor() != null) {
                        this.setDeferredType(objectLiteralCast.objectNode, type);
                        objectLiteralCast.objectNode.putBooleanProp((byte)57, true);
                    } else {
                        TypedScopeCreator.this.report(JSError.make(n, CONSTRUCTOR_EXPECTED, new String[0]));
                    }
                } else {
                    TypedScopeCreator.this.report(JSError.make(n, objectLiteralCast.diagnosticType, new String[0]));
                }
            }
        }

        private void applyDelegateRelationship(CodingConvention.DelegateRelationship delegateRelationship) {
            ObjectType delegatorObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegator));
            ObjectType delegateBaseObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(delegateRelationship.delegateBase));
            ObjectType delegateSuperObject = ObjectType.cast(TypedScopeCreator.this.typeRegistry.getType(TypedScopeCreator.this.codingConvention.getDelegateSuperclassName()));
            if (delegatorObject != null && delegateBaseObject != null && delegateSuperObject != null) {
                FunctionType delegatorCtor = delegatorObject.getConstructor();
                FunctionType delegateBaseCtor = delegateBaseObject.getConstructor();
                FunctionType delegateSuperCtor = delegateSuperObject.getConstructor();
                if (delegatorCtor != null && delegateBaseCtor != null && delegateSuperCtor != null) {
                    FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(TypedScopeCreator.this.typeRegistry);
                    functionParamBuilder.addRequiredParams(TypedScopeCreator.this.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
                    FunctionType findDelegate = TypedScopeCreator.this.typeRegistry.createFunctionType(TypedScopeCreator.this.typeRegistry.createDefaultObjectUnion(delegateBaseObject), functionParamBuilder.build());
                    FunctionType delegateProxy = TypedScopeCreator.this.typeRegistry.createConstructorType(delegateBaseObject.getReferenceName() + DELEGATE_PROXY_SUFFIX, null, null, null, null, false);
                    delegateProxy.setPrototypeBasedOn(delegateBaseObject);
                    TypedScopeCreator.this.codingConvention.applyDelegateRelationship(new NominalTypeBuilderOti(delegateSuperCtor, delegateSuperObject), new NominalTypeBuilderOti(delegateBaseCtor, delegateBaseObject), new NominalTypeBuilderOti(delegatorCtor, delegatorObject), (ObjectType)delegateProxy.getTypeOfThis(), findDelegate);
                    TypedScopeCreator.this.delegateProxyCtors.add(delegateProxy);
                }
            }
        }

        void maybeDeclareQualifiedName(NodeTraversal t, JSDocInfo info, Node n, Node parent, Node rhsValue) {
            TypedVar qVar;
            Node ownerNode = n.getFirstChild();
            String ownerName = ownerNode.getQualifiedName();
            String qName = n.getQualifiedName();
            String propName = n.getLastChild().getString();
            Preconditions.checkArgument((qName != null && ownerName != null ? 1 : 0) != 0);
            JSType valueType = this.getDeclaredType(info, n, rhsValue);
            if (valueType == null && rhsValue != null) {
                valueType = rhsValue.getJSType();
            }
            if ("prototype".equals(propName) && (qVar = (TypedVar)this.scope.getVar(qName)) != null) {
                ObjectType qVarType = ObjectType.cast(qVar.getType());
                if (qVarType != null && rhsValue != null && rhsValue.isObjectLit()) {
                    TypedScopeCreator.this.typeRegistry.resetImplicitPrototype(rhsValue.getJSType(), qVarType.getImplicitPrototype());
                } else if (!qVar.isTypeInferred()) {
                    return;
                }
                ((TypedScope)qVar.getScope()).undeclare(qVar);
            }
            if (valueType == null) {
                if (parent.isExprResult()) {
                    this.stubDeclarations.add(new StubDeclaration(n, t.getInput() != null && t.getInput().isExtern(), ownerName));
                }
                return;
            }
            boolean inferred = this.isQualifiedNameInferred(qName, n, info, rhsValue, valueType);
            if (!inferred) {
                ObjectType ownerType = this.getObjectSlot(ownerName);
                if (ownerType != null) {
                    boolean isExtern;
                    boolean bl = isExtern = t.getInput() != null && t.getInput().isExtern();
                    if (!(ownerType.hasOwnProperty(propName) && !ownerType.isPropertyTypeInferred(propName) || (!isExtern || ownerType.isNativeObjectType()) && ownerType.isInstanceType())) {
                        ownerType.defineDeclaredProperty(propName, valueType, n);
                    }
                }
                this.defineSlot(n, parent, valueType, inferred);
            }
        }

        private boolean isQualifiedNameInferred(String qName, Node n, JSDocInfo info, Node rhsValue, JSType valueType) {
            if (valueType == null) {
                return true;
            }
            if (qName != null && qName.endsWith(".prototype")) {
                JSType classType;
                String className = qName.substring(0, qName.lastIndexOf(".prototype"));
                TypedVar slot = (TypedVar)this.scope.getSlot(className);
                JSType jSType = classType = slot == null ? null : slot.getType();
                if (classType != null && (classType.isConstructor() || classType.isInterface())) {
                    return false;
                }
            }
            boolean inferred = true;
            if (info != null) {
                boolean bl = inferred = !info.hasType() && !info.hasEnumParameterType() && (!NodeUtil.isConstantDeclaration(TypedScopeCreator.this.compiler.getCodingConvention(), info, n) || valueType == null || valueType.isUnknownType()) && !FunctionTypeBuilder.isFunctionTypeDeclaration(info);
            }
            if (inferred && rhsValue != null && rhsValue.isFunction()) {
                if (info != null) {
                    return false;
                }
                if (!this.scope.hasOwnSlot(qName) && n.isUnscopedQualifiedName()) {
                    Node current = n.getParent();
                    while (!current.isScript() && !current.isFunction()) {
                        if (NodeUtil.isControlStructure(current)) {
                            return true;
                        }
                        current = current.getParent();
                    }
                    if (!TypedScopeCreator.this.escapedVarNames.contains(ScopedName.of(qName, this.scope.getRootNode()))) {
                        return false;
                    }
                }
            }
            return inferred;
        }

        private ObjectType getObjectSlot(String slotName) {
            TypedVar ownerVar = (TypedVar)this.scope.getVar(slotName);
            if (ownerVar != null) {
                JSType ownerVarType = ownerVar.getType();
                return ObjectType.cast(ownerVarType == null ? null : ownerVarType.restrictByNotNullOrUndefined());
            }
            return null;
        }

        private JSType getInheritedInterfacePropertyType(ObjectType obj, String propName) {
            if (obj != null && obj.isPrototypeObject()) {
                FunctionType f = obj.getOwnerFunction();
                for (ObjectType i : f.getImplementedInterfaces()) {
                    if (!i.hasProperty(propName)) continue;
                    return i.getPropertyType(propName);
                }
            }
            return null;
        }

        void resolveStubDeclarations() {
            for (StubDeclaration stub : this.stubDeclarations) {
                Node n = stub.node;
                Node parent = n.getParent();
                String qName = n.getQualifiedName();
                String propName = n.getLastChild().getString();
                String ownerName = stub.ownerName;
                boolean isExtern = stub.isExtern;
                if (this.scope.hasOwnSlot(qName)) continue;
                ObjectType ownerType = this.getObjectSlot(ownerName);
                JSType inheritedType = this.getInheritedInterfacePropertyType(ownerType, propName);
                JSType stubType = inheritedType == null ? TypedScopeCreator.this.unknownType : inheritedType;
                this.defineSlot(n, parent, stubType, true);
                if (ownerType != null && (isExtern || ownerType.isFunctionPrototypeType())) {
                    ownerType.defineInferredProperty(propName, stubType, n);
                    continue;
                }
                TypedScopeCreator.this.typeRegistry.registerPropertyOnType(propName, ownerType == null ? stubType : ownerType);
            }
        }
    }

    private static class DiscoverEnumsAndTypedefs
    extends NodeTraversal.AbstractShallowStatementCallback {
        private final JSTypeRegistry registry;

        DiscoverEnumsAndTypedefs(JSTypeRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void visit(NodeTraversal t, Node node, Node parent) {
            switch (node.getToken()) {
                case VAR: {
                    for (Node child = node.getFirstChild(); child != null; child = child.getNext()) {
                        this.identifyNameNode(child, NodeUtil.getBestJSDocInfo(child));
                    }
                    break;
                }
                case EXPR_RESULT: {
                    Node firstChild = node.getFirstChild();
                    if (firstChild.isAssign()) {
                        this.identifyNameNode(firstChild.getFirstChild(), firstChild.getJSDocInfo());
                        break;
                    }
                    this.identifyNameNode(firstChild, firstChild.getJSDocInfo());
                    break;
                }
            }
        }

        private void identifyNameNode(Node nameNode, JSDocInfo info) {
            if (info != null && nameNode.isQualifiedName()) {
                if (info.hasEnumParameterType()) {
                    this.registry.identifyNonNullableName(nameNode.getQualifiedName());
                } else if (info.hasTypedefType()) {
                    this.registry.identifyNonNullableName(nameNode.getQualifiedName());
                }
            }
        }
    }

    private class DeferredSetType {
        final Node node;
        final JSType type;

        DeferredSetType(Node node, JSType type) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkNotNull((Object)type);
            this.node = node;
            this.type = type;
        }

        void resolve(TypedScope scope) {
            this.node.setJSType(this.type.resolve(TypedScopeCreator.this.typeParsingErrorReporter, scope));
        }
    }
}

