/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ijs;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.FileAwareWarningsGuard;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.Node;

public class CheckTypeSummaryWarningsGuard
extends FileAwareWarningsGuard {
    public CheckTypeSummaryWarningsGuard(AbstractCompiler compiler) {
        super(compiler);
    }

    @Override
    public CheckLevel level(JSError error) {
        if (this.inTypeSummary(error)) {
            return CheckLevel.WARNING;
        }
        return null;
    }

    @Override
    protected int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_BY_WHITELIST.getValue();
    }

    private boolean inTypeSummary(JSError error) {
        Node scriptNode = this.getScriptNodeForError(error);
        return scriptNode != null && NodeUtil.isFromTypeSummary(scriptNode);
    }
}

