/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.type;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.type.ChainableReverseAbstractInterpreter;
import com.google.javascript.jscomp.type.FlowScope;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Map;

public final class ClosureReverseAbstractInterpreter
extends ChainableReverseAbstractInterpreter {
    private final Visitor<JSType> restrictToObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByTrueTypeOfResultVisitor(){

        @Override
        protected JSType caseTopType(JSType topType) {
            return ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return type;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return type;
        }
    };
    private final Visitor<JSType> restrictToNotObjectVisitor = new ChainableReverseAbstractInterpreter.RestrictByFalseTypeOfResultVisitor(){

        @Override
        public JSType caseAllType() {
            return ClosureReverseAbstractInterpreter.this.typeRegistry.createUnionType(ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NUMBER_STRING_BOOLEAN_SYMBOL), ClosureReverseAbstractInterpreter.this.getNativeType(JSTypeNative.NULL_VOID));
        }

        @Override
        public JSType caseObjectType(ObjectType type) {
            return null;
        }

        @Override
        public JSType caseFunctionType(FunctionType type) {
            return null;
        }
    };
    private final Map<String, Function<TypeRestriction, JSType>> restricters = new ImmutableMap.Builder().put((Object)"isDef", p -> {
        if (((TypeRestriction)p).outcome) {
            return this.getRestrictedWithoutUndefined(((TypeRestriction)p).type);
        }
        return ((TypeRestriction)p).type != null ? this.getNativeType(JSTypeNative.VOID_TYPE).getGreatestSubtype(((TypeRestriction)p).type) : null;
    }).put((Object)"isNull", p -> {
        if (((TypeRestriction)p).outcome) {
            return ((TypeRestriction)p).type != null ? this.getNativeType(JSTypeNative.NULL_TYPE).getGreatestSubtype(((TypeRestriction)p).type) : null;
        }
        return this.getRestrictedWithoutNull(((TypeRestriction)p).type);
    }).put((Object)"isDefAndNotNull", p -> {
        if (((TypeRestriction)p).outcome) {
            return this.getRestrictedWithoutUndefined(this.getRestrictedWithoutNull(((TypeRestriction)p).type));
        }
        return ((TypeRestriction)p).type != null ? this.getNativeType(JSTypeNative.NULL_VOID).getGreatestSubtype(((TypeRestriction)p).type) : null;
    }).put((Object)"isString", p -> this.getRestrictedByTypeOfResult(((TypeRestriction)p).type, "string", ((TypeRestriction)p).outcome)).put((Object)"isBoolean", p -> this.getRestrictedByTypeOfResult(((TypeRestriction)p).type, "boolean", ((TypeRestriction)p).outcome)).put((Object)"isNumber", p -> this.getRestrictedByTypeOfResult(((TypeRestriction)p).type, "number", ((TypeRestriction)p).outcome)).put((Object)"isFunction", p -> this.getRestrictedByTypeOfResult(((TypeRestriction)p).type, "function", ((TypeRestriction)p).outcome)).put((Object)"isArray", p -> {
        if (((TypeRestriction)p).type == null) {
            return ((TypeRestriction)p).outcome ? this.getNativeType(JSTypeNative.ARRAY_TYPE) : null;
        }
        Visitor visitor = ((TypeRestriction)p).outcome ? this.restrictToArrayVisitor : this.restrictToNotArrayVisitor;
        return (JSType)((TypeRestriction)p).type.visit(visitor);
    }).put((Object)"isObject", p -> {
        if (((TypeRestriction)p).type == null) {
            return ((TypeRestriction)p).outcome ? this.getNativeType(JSTypeNative.OBJECT_TYPE) : null;
        }
        Visitor<JSType> visitor = ((TypeRestriction)p).outcome ? this.restrictToObjectVisitor : this.restrictToNotObjectVisitor;
        return ((TypeRestriction)p).type.visit(visitor);
    }).build();

    public ClosureReverseAbstractInterpreter(JSTypeRegistry typeRegistry) {
        super(typeRegistry);
    }

    @Override
    public FlowScope getPreciserScopeKnowingConditionOutcome(Node condition, FlowScope blindScope, boolean outcome) {
        if (condition.isCall() && condition.hasTwoChildren()) {
            Node callee = condition.getFirstChild();
            Node param = condition.getLastChild();
            if (callee.isGetProp() && param.isQualifiedName()) {
                Function<TypeRestriction, JSType> restricter;
                JSType paramType = this.getTypeIfRefinable(param, blindScope);
                Node left = callee.getFirstChild();
                Node right = callee.getLastChild();
                if (left.isName() && "goog".equals(left.getString()) && right.isString() && (restricter = this.restricters.get(right.getString())) != null) {
                    return this.restrictParameter(param, paramType, blindScope, restricter, outcome);
                }
            }
        }
        return this.nextPreciserScopeKnowingConditionOutcome(condition, blindScope, outcome);
    }

    private FlowScope restrictParameter(Node parameter, JSType type, FlowScope blindScope, Function<TypeRestriction, JSType> restriction, boolean outcome) {
        if ((type = (JSType)restriction.apply((Object)new TypeRestriction(type, outcome))) != null) {
            FlowScope informed = blindScope.createChildFlowScope();
            this.declareNameInScope(informed, parameter, type);
            return informed;
        }
        return blindScope;
    }

    private static class TypeRestriction {
        private final JSType type;
        private final boolean outcome;

        private TypeRestriction(JSType type, boolean outcome) {
            this.type = type;
            this.outcome = outcome;
        }
    }
}

