/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.authentication.token;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class AuthenticationTokenManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = AuthenticationTokenManager.class.getName();
    public static final String TOKEN_SEPARATOR = "#";
    public static final String USER_TOKEN_TYPE = "User";
    private static final String TOKEN_SQL_GET_FIELDS = "id, token, salt, creation_date, end_date, last_update_date, nb_uses_left, auto_renew_duration, context, type, token_comment";
    private static final String TOKEN_SQL_SET_FIELDS = "login, population_id, token, salt, creation_date, end_date, nb_uses_left, auto_renew_duration, context, type, token_comment";
    private ServiceManager _manager;
    private CurrentUserProvider _currentUserProvider;
    private String _datasourceId;
    private SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
    }

    public void initialize() throws Exception {
        this._datasourceId = Config.getInstance() != null ? (String)Config.getInstance().getValue("runtime.assignments.authenticationtokens") : "";
    }

    private CurrentUserProvider _getCurrentUserProvider() throws RuntimeException {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._manager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._currentUserProvider;
    }

    public List<Token> getTokens(String type) throws RuntimeException {
        return this.getTokens(this._getCurrentUserProvider().getUser(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> getTokens(UserIdentity user, String type) throws RuntimeException {
        if (user == null) {
            throw new RuntimeException("Cannot generate a temporary authentication token for a null user");
        }
        ArrayList<Token> tokens = new ArrayList<Token>();
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._datasourceId);
            this._deleteOldTokens(connection);
            try (PreparedStatement selectStatement = this._getSelectUserTokenStatement(connection, user.getLogin(), user.getPopulationId(), type);
                 ResultSet resultSet = selectStatement.executeQuery();){
                while (resultSet.next()) {
                    Token token = this._getTokenFromResultSet(resultSet, connection);
                    tokens.add(token);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Communication error with the database", (Throwable)e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
        return tokens;
    }

    public String generateToken(long duration, String type, String comment) throws RuntimeException {
        return this.generateToken(this._getCurrentUserProvider().getUser(), duration, type, comment);
    }

    public String generateToken(UserIdentity user, long duration, String type, String comment) throws RuntimeException {
        return this.generateToken(user, duration, false, null, null, type, comment);
    }

    public String generateToken(UserIdentity user, long duration, Integer nbUsesLeft, String type, String comment) throws RuntimeException {
        return this.generateToken(user, duration, false, nbUsesLeft, null, type, comment);
    }

    public String generateToken(UserIdentity user, long duration, boolean autoRenewDuration, Integer nbUsesLeft, String context, String type, String comment) throws RuntimeException {
        if (user == null) {
            throw new RuntimeException("Cannot generate a temporary authentication token for a null user");
        }
        if (duration < 0L) {
            throw new RuntimeException("Cannot generate a token for a negative duration [" + duration + "]");
        }
        String token = RandomStringUtils.randomAlphanumeric((int)(duration == 0L ? 64 : 16));
        String salt = RandomStringUtils.randomAlphanumeric((int)48);
        Timestamp creationDateTime = new Timestamp(new Date().getTime());
        Timestamp endTime = duration > 0L ? new Timestamp(System.currentTimeMillis() + duration * 1000L) : null;
        String hashedTokenAndSalt = DigestUtils.sha512Hex((String)(token + salt));
        this._generateToken(user, duration, autoRenewDuration, nbUsesLeft, context, type, comment, hashedTokenAndSalt, salt, creationDateTime, endTime);
        String fullToken = user.getPopulationId() + TOKEN_SEPARATOR + user.getLogin() + TOKEN_SEPARATOR + token;
        try {
            return Base64.getEncoder().withoutPadding().encodeToString(fullToken.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void _generateToken(UserIdentity user, long duration, boolean autoRenewDuration, Integer nbUsesLeft, String context, String type, String comment, String hashedTokenAndSalt, String salt, Timestamp creationDateTime, Timestamp endTime) throws RuntimeException {
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = ConnectionHelper.getConnection(this._datasourceId);
            String dbType = ConnectionHelper.getDatabaseType(connection);
            if ("oracle".equals(dbType)) {
                statement = connection.prepareStatement("SELECT seq_authenticationtoken.nextval FROM dual");
                rs = statement.executeQuery();
                String id = null;
                if (rs.next()) {
                    id = rs.getString(1);
                }
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(statement);
                statement = connection.prepareStatement("INSERT INTO Authentication_Token (id, login, population_id, token, salt, creation_date, end_date, nb_uses_left, auto_renew_duration, context, type, token_comment) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                int nextParam = 1;
                statement.setString(nextParam++, id);
                statement.setString(nextParam++, user.getLogin());
                statement.setString(nextParam++, user.getPopulationId());
                statement.setString(nextParam++, hashedTokenAndSalt);
                statement.setString(nextParam++, salt);
                statement.setTimestamp(nextParam++, creationDateTime);
                statement.setTimestamp(nextParam++, endTime);
                if (nbUsesLeft == null) {
                    statement.setNull(nextParam++, 4);
                } else {
                    statement.setInt(nextParam++, nbUsesLeft);
                }
                if (!autoRenewDuration) {
                    statement.setNull(nextParam++, -5);
                } else {
                    statement.setLong(nextParam++, duration);
                }
                if (context == null) {
                    statement.setNull(nextParam++, 12);
                } else {
                    statement.setString(nextParam++, context);
                }
                statement.setString(nextParam++, type);
                if (comment == null) {
                    statement.setNull(nextParam++, 2004);
                } else {
                    this._sqlDatabaseTypeExtensionPoint.setBlob(dbType, statement, nextParam++, comment);
                }
            } else {
                statement = connection.prepareStatement("INSERT INTO Authentication_Token (login, population_id, token, salt, creation_date, end_date, nb_uses_left, auto_renew_duration, context, type, token_comment) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                int nextParam = 1;
                statement.setString(nextParam++, user.getLogin());
                statement.setString(nextParam++, user.getPopulationId());
                statement.setString(nextParam++, hashedTokenAndSalt);
                statement.setString(nextParam++, salt);
                statement.setTimestamp(nextParam++, creationDateTime);
                statement.setTimestamp(nextParam++, endTime);
                if (nbUsesLeft == null) {
                    statement.setNull(nextParam++, 4);
                } else {
                    statement.setInt(nextParam++, nbUsesLeft);
                }
                if (!autoRenewDuration) {
                    statement.setNull(nextParam++, -5);
                } else {
                    statement.setLong(nextParam++, duration);
                }
                if (context == null) {
                    statement.setNull(nextParam++, 12);
                } else {
                    statement.setString(nextParam++, context);
                }
                statement.setString(nextParam++, type);
                this._sqlDatabaseTypeExtensionPoint.setBlob(dbType, statement, nextParam++, comment);
            }
            statement.executeUpdate();
        }
        catch (UnsupportedEncodingException | SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserIdentity _validateToken(String encodedToken, String context, boolean forceRemove) {
        String token;
        try {
            token = new String(Base64.getDecoder().decode(encodedToken), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            return null;
        }
        String[] split = StringUtils.split((String)token, (String)TOKEN_SEPARATOR);
        if (split == null || split.length != 3) {
            return null;
        }
        String populationId = split[0];
        String login = split[1];
        String tokenPart = split[2];
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._datasourceId);
            this._deleteOldTokens(connection);
            try (PreparedStatement selectStatement = this._getSelectUserTokenStatement(connection, login, populationId, null);
                 ResultSet resultSet = selectStatement.executeQuery();){
                while (resultSet.next()) {
                    Token tokenToUpdate;
                    if (!resultSet.getString("token").equals(DigestUtils.sha512Hex((String)(tokenPart + resultSet.getString("salt")))) || (tokenToUpdate = this._getTokenFromResultSet(resultSet, connection)).getContext() != null && !tokenToUpdate.getContext().equals(context)) continue;
                    if (forceRemove) {
                        this._deleteUserToken(connection, tokenToUpdate.getId());
                    } else {
                        this._updateUserToken(connection, tokenToUpdate);
                    }
                    UserIdentity userIdentity = new UserIdentity(login, populationId);
                    return userIdentity;
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Communication error with the database", (Throwable)e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
        return null;
    }

    public UserIdentity validateToken(String token) {
        return this.validateToken(token, null);
    }

    public UserIdentity validateToken(String token, String context) {
        return this._validateToken(token, context, false);
    }

    public void deleteTokenByValue(String token, String context) {
        this._validateToken(token, context, true);
    }

    public void deleteTokenById(Integer tokenId) {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(this._datasourceId);
            this._deleteUserToken(connection, tokenId);
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not delete the authentication token with identifier " + tokenId, e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    private void _deleteOldTokens(Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM Authentication_Token WHERE end_date < ? OR nb_uses_left = ?");){
            statement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            statement.setInt(2, 0);
            statement.executeUpdate();
        }
    }

    private PreparedStatement _getSelectUserTokenStatement(Connection connection, String login, String populationId, String type) throws SQLException {
        String sqlRequest = "SELECT id, token, salt, creation_date, end_date, last_update_date, nb_uses_left, auto_renew_duration, context, type, token_comment FROM Authentication_Token WHERE login=? AND population_id=?" + (type != null ? " AND type=?" : "");
        PreparedStatement statement = connection.prepareStatement(sqlRequest);
        int nextParam = 1;
        statement.setString(nextParam++, login);
        statement.setString(nextParam++, populationId);
        if (type != null) {
            statement.setString(nextParam++, type);
        }
        return statement;
    }

    private Token _getTokenFromResultSet(ResultSet resultSet, Connection connection) throws SQLException, IOException {
        String dbType = ConnectionHelper.getDatabaseType(connection);
        String comment = null;
        try (InputStream blob = this._sqlDatabaseTypeExtensionPoint.getBlob(dbType, resultSet, "token_comment");){
            if (blob != null) {
                comment = IOUtils.toString((InputStream)blob, (String)"UTF-8");
            }
        }
        Integer nbUsesLeft = resultSet.getInt("nb_uses_left");
        if (resultSet.wasNull()) {
            nbUsesLeft = null;
        }
        Long autoRenewDuration = resultSet.getLong("auto_renew_duration");
        if (resultSet.wasNull()) {
            autoRenewDuration = null;
        }
        Token token = new Token(resultSet.getInt("id"), resultSet.getString("type"), comment, resultSet.getTimestamp("creation_date"), resultSet.getTimestamp("end_date"), resultSet.getTimestamp("last_update_date"), nbUsesLeft, autoRenewDuration, resultSet.getString("context"));
        return token;
    }

    private void _deleteUserToken(Connection connection, Integer id) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM Authentication_Token WHERE id = ?");){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
    }

    private void _updateUserToken(Connection connection, Token token) throws SQLException {
        Serializable serializable;
        Integer nbUsesLeft = token.getNbUsesLeft();
        if (nbUsesLeft != null && nbUsesLeft > 0) {
            Integer n = nbUsesLeft;
            nbUsesLeft = nbUsesLeft - 1;
            serializable = nbUsesLeft;
        }
        if (nbUsesLeft != null && nbUsesLeft == 0) {
            this._deleteUserToken(connection, token.getId());
        } else {
            if (token.getAutoRenewDuration() != null) {
                Long autoRenewDuration = token.getAutoRenewDuration();
                Timestamp endDate = new Timestamp(new Date().getTime() + autoRenewDuration * 1000L);
                try (PreparedStatement statement = connection.prepareStatement("UPDATE Authentication_Token SET last_update_date = ?, end_date = ?, nb_uses_left = ? WHERE id = ?");){
                    Timestamp lastUpdateDate = new Timestamp(new Date().getTime());
                    statement.setTimestamp(1, lastUpdateDate);
                    statement.setTimestamp(2, endDate);
                    if (nbUsesLeft == null) {
                        statement.setNull(3, 4);
                    } else {
                        statement.setInt(3, nbUsesLeft);
                    }
                    statement.setInt(4, token.getId());
                    statement.executeUpdate();
                }
            }
            PreparedStatement statement = connection.prepareStatement("UPDATE Authentication_Token SET last_update_date = ?, nb_uses_left = ? WHERE id = ?");
            serializable = null;
            try {
                Timestamp lastUpdateDate = new Timestamp(new Date().getTime());
                statement.setTimestamp(1, lastUpdateDate);
                if (nbUsesLeft == null) {
                    statement.setNull(2, 4);
                } else {
                    statement.setInt(2, nbUsesLeft);
                }
                statement.setInt(3, token.getId());
                statement.executeUpdate();
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (serializable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
    }

    @Callable
    public String generateAuthenticationToken(Map<String, Object> parameters) {
        String description = (String)parameters.get("description");
        String generateToken = this.generateToken(0L, USER_TOKEN_TYPE, description);
        return generateToken;
    }

    @Callable
    public void deleteAuthenticationToken(List<Integer> ids) {
        for (Integer tokenId : ids) {
            this.deleteTokenById(tokenId);
        }
    }

    public static class Token {
        protected Integer _id;
        protected String _type;
        protected String _comment;
        protected Date _creationDate;
        protected Date _endDate;
        protected Date _lastUpdateDate;
        protected Integer _nbUsesLeft;
        protected Long _autoRenewDuration;
        protected String _context;

        protected Token(Integer id, String type, String comment, Date creationDate, Date endDate, Date lastUpdateDate, Integer nbUsesLeft, Long autoRenewDuration, String context) {
            this._id = id;
            this._type = type;
            this._comment = comment;
            this._creationDate = creationDate;
            this._endDate = endDate;
            this._lastUpdateDate = lastUpdateDate;
            this._nbUsesLeft = nbUsesLeft;
            this._autoRenewDuration = autoRenewDuration;
            this._context = context;
        }

        public Integer getId() {
            return this._id;
        }

        public String getType() {
            return this._type;
        }

        public String getComment() {
            return this._comment;
        }

        public Date getCreationDate() {
            return this._creationDate;
        }

        public Date getEndDate() {
            return this._endDate;
        }

        public Date getLastUpdateDate() {
            return this._endDate;
        }

        public Long getAutoRenewDuration() {
            return this._autoRenewDuration;
        }

        public String getContext() {
            return this._context;
        }

        public Integer getNbUsesLeft() {
            return this._nbUsesLeft;
        }
    }
}

