/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;

public abstract class AbstractMyBatisDAO
extends AbstractLogEnabled
implements Contextualizable,
Serviceable,
PluginAware,
Configurable,
Component {
    protected ServiceManager _manager;
    private SqlSessionFactory _sessionFactory;
    private SQLDataSourceManager _sqlDataSourceManager;
    private String _contextPath;
    private String _pluginName;
    private String _dataSourceId;
    private String _dataSourceParameter;
    private boolean _dataSourceConfigurationParameter;
    private Set<SqlMap> _sqlMaps;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        Context ctx = (Context)context.get((Object)"environment-context");
        this._contextPath = ctx.getRealPath("/");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    private SQLDataSourceManager getSQLDataSourceManager() {
        if (this._sqlDataSourceManager == null) {
            try {
                this._sqlDataSourceManager = (SQLDataSourceManager)this._manager.lookup(SQLDataSourceManager.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._sqlDataSourceManager;
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] sqlMaps;
        this._configureDatasource(configuration);
        this._sqlMaps = new HashSet<SqlMap>();
        for (Configuration sqlMapConf : sqlMaps = configuration.getChildren("sqlMap")) {
            String resourceSrc = sqlMapConf.getAttribute("resource", null);
            String configSrc = sqlMapConf.getAttribute("config", null);
            if (StringUtils.isBlank((String)resourceSrc) && StringUtils.isBlank((String)configSrc)) {
                throw new ConfigurationException("The sqlmap configuration must have a 'resource' or 'config' attribute.", sqlMapConf);
            }
            if (StringUtils.isNotBlank((String)resourceSrc) && StringUtils.isNotBlank((String)configSrc)) {
                File file;
                File file2 = file = configSrc.startsWith("/") ? new File(this._contextPath, configSrc) : new File(PluginsManager.getInstance().getPluginLocation(this._pluginName), configSrc);
                if (!file.isFile()) {
                    configSrc = null;
                }
            }
            SqlMap sqlMap = new SqlMap();
            if (StringUtils.isNotBlank((String)configSrc)) {
                sqlMap.setSource(configSrc);
                sqlMap.setSourceType("config");
            } else {
                sqlMap.setSource(resourceSrc);
                sqlMap.setSourceType("resource");
            }
            this._sqlMaps.add(sqlMap);
        }
    }

    protected void _configureDatasource(Configuration configuration) throws ConfigurationException {
        Configuration dataSourceConf = configuration.getChild("datasource", false);
        if (dataSourceConf == null) {
            throw new ConfigurationException("The 'datasource' configuration node must be defined.", dataSourceConf);
        }
        String dataSourceConfParam = dataSourceConf.getValue();
        String dataSourceConfType = dataSourceConf.getAttribute("type", "config");
        this._dataSourceConfigurationParameter = StringUtils.equals((String)dataSourceConfType, (String)"config");
        this._dataSourceParameter = dataSourceConfParam;
    }

    protected synchronized void reload() {
        String newDatasourceId = this._getDataSourceId();
        if (StringUtils.equals((String)newDatasourceId, (String)this._dataSourceId)) {
            return;
        }
        this._dataSourceId = newDatasourceId;
        DataSource dataSource = this.getSQLDataSourceManager().getSQLDataSource(this._dataSourceId);
        if (dataSource == null) {
            throw new RuntimeException("Cannot (re)load MyBatis: Invalid datasource id: " + this._dataSourceId);
        }
        SqlSessionFactoryBuilder sessionFactoryBuilder = new SqlSessionFactoryBuilder();
        JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment env = new Environment(this._dataSourceId, (TransactionFactory)transactionFactory, dataSource);
        org.apache.ibatis.session.Configuration config = this._getMyBatisConfiguration(env);
        for (SqlMap sqlMap : this._sqlMaps) {
            String sourceType = sqlMap.getSourceType();
            String source = sqlMap.getSource();
            try {
                if ("config".equals(sourceType)) {
                    File file = null;
                    if (source.startsWith("/")) {
                        file = new File(this._contextPath, source);
                    } else {
                        File pluginDir = PluginsManager.getInstance().getPluginLocation(this._pluginName);
                        file = new File(pluginDir, source);
                    }
                    try {
                        FileInputStream mapperStream = new FileInputStream(file);
                        Throwable throwable = null;
                        try {
                            this._initializeXMLMapper(mapperStream, file.toURI().toASCIIString(), config);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (mapperStream == null) continue;
                            if (throwable != null) {
                                try {
                                    ((InputStream)mapperStream).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((InputStream)mapperStream).close();
                            continue;
                        }
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException("Cannot (re)load MyBatis: Cannot find configuration file: " + file, e);
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                try {
                    InputStream mapperStream = this.getClass().getResourceAsStream(source);
                    Throwable throwable = null;
                    try {
                        this._initializeXMLMapper(mapperStream, source, config);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (mapperStream == null) continue;
                        if (throwable != null) {
                            try {
                                mapperStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        mapperStream.close();
                    }
                }
                catch (IOException mapperStream) {}
            }
            catch (Exception e) {
                this._dataSourceId = null;
                throw e;
            }
        }
        this._sessionFactory = sessionFactoryBuilder.build(config);
    }

    private void _initializeXMLMapper(InputStream mapperStream, String mapperLocation, org.apache.ibatis.session.Configuration config) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Initialized mybatis mapper at location '{}' for datasource id '{}'", (Object)mapperLocation, (Object)this._dataSourceId);
        }
        XMLMapperBuilder mapperParser = new XMLMapperBuilder(mapperStream, config, mapperLocation, config.getSqlFragments());
        mapperParser.parse();
    }

    protected org.apache.ibatis.session.Configuration _getMyBatisConfiguration(Environment env) {
        org.apache.ibatis.session.Configuration config = new org.apache.ibatis.session.Configuration(env);
        config.setCacheEnabled(true);
        config.setLazyLoadingEnabled(true);
        return config;
    }

    protected String _getDataSourceId() {
        String newDatasourceId = this._dataSourceConfigurationParameter ? (String)Config.getInstance().getValue(this._dataSourceParameter) : this._dataSourceParameter;
        if (this.getSQLDataSourceManager().getDefaultDataSourceId().equals(newDatasourceId)) {
            newDatasourceId = this.getSQLDataSourceManager().getDefaultDataSourceDefinition().getId();
        }
        return newDatasourceId;
    }

    protected SqlSession getSession() {
        return this.getSession(false);
    }

    protected SqlSession getSession(boolean autoCommit) {
        this.reload();
        return this._sessionFactory.openSession(autoCommit);
    }

    class SqlMap {
        private String _source;
        private String _sourceType;

        SqlMap() {
        }

        public String getSource() {
            return this._source;
        }

        public void setSource(String source) {
            this._source = source;
        }

        public String getSourceType() {
            return this._sourceType;
        }

        public void setSourceType(String sourceType) {
            this._sourceType = sourceType;
        }
    }
}

