/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.devmode;

import java.util.List;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class DevModeMenuItemClientSideElement
extends StaticClientSideElement
implements Contextualizable {
    private Context _context;
    private String _toggleOn;
    private Boolean _dynamicDecorator;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._toggleOn = configuration.getChild("toggle-on").getValue("");
        this._dynamicDecorator = Boolean.valueOf(configuration.getChild("dynamic-decorator").getValue("false"));
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        List<ClientSideElement.Script> scripts = super.getScripts(ignoreRights, contextParameters);
        if (!scripts.isEmpty()) {
            ClientSideElement.Script script = scripts.get(0);
            Request request = ContextHelper.getRequest((Context)this._context);
            DevMode.DEVMODE devMode = DevMode.getDeveloperMode(request);
            String forceDevMode = request.getParameter("debug.mode");
            String decorator = null;
            if (this._dynamicDecorator.booleanValue()) {
                if (DevMode.DEVMODE.PRODUCTION.equals((Object)devMode)) {
                    decorator = "decorator-ametysicon-sign-raw-cross";
                } else if (DevMode.DEVMODE.DEVELOPMENT.equals((Object)devMode)) {
                    decorator = "decorator-ametysicon-sign-raw-check";
                } else if (DevMode.DEVMODE.SUPER_DEVELOPPMENT.equals((Object)devMode)) {
                    decorator = "decorator-ametysicon-bugs3";
                }
            }
            Map<String, Object> parameters = script.getParameters();
            if (decorator != null) {
                parameters.put("icon-decorator", decorator);
            }
            boolean toggled = forceDevMode != null ? forceDevMode.equals(this._toggleOn) : StringUtils.isEmpty((CharSequence)this._toggleOn);
            parameters.put("toggle-state", toggled);
            parameters.put("disabled", toggled);
        }
        return scripts;
    }
}

