/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.group;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.GroupDirectoryFactory;
import org.ametys.core.group.directory.GroupDirectoryModel;
import org.ametys.runtime.model.ElementDefinition;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class GroupDirectoriesDataSourceConsumer
implements DataSourceConsumer,
Component,
Serviceable {
    private GroupDirectoryDAO _groupDirectoryDAO;
    private GroupDirectoryFactory _groupDirectoryFactory;

    public void service(ServiceManager manager) throws ServiceException {
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._groupDirectoryFactory = (GroupDirectoryFactory)manager.lookup(GroupDirectoryFactory.ROLE);
    }

    @Override
    public boolean isInUse(String id) {
        for (String gdModelId : this._groupDirectoryFactory.getExtensionsIds()) {
            GroupDirectoryModel gdModel = this._groupDirectoryFactory.getExtension(gdModelId);
            ArrayList<String> datasourceParameters = new ArrayList<String>();
            Map<String, ? extends ElementDefinition> parameters = gdModel.getParameters();
            for (String parameterId : parameters.keySet()) {
                if (!"datasource".equals(parameters.get(parameterId).getType().getId())) continue;
                datasourceParameters.add(parameterId);
            }
            for (GroupDirectory groupDirectory : this._groupDirectoryDAO.getGroupDirectories()) {
                if (!groupDirectory.getGroupDirectoryModelId().equals(gdModelId)) continue;
                for (String datasourceParameter : datasourceParameters) {
                    if (!id.equals(groupDirectory.getParameterValues().get(datasourceParameter))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Set<String> getUsedDataSourceIds() {
        HashSet<String> result = new HashSet<String>();
        for (String gdModelId : this._groupDirectoryFactory.getExtensionsIds()) {
            GroupDirectoryModel gdModel = this._groupDirectoryFactory.getExtension(gdModelId);
            ArrayList<String> datasourceParameters = new ArrayList<String>();
            Map<String, ? extends ElementDefinition> parameters = gdModel.getParameters();
            for (String parameterId : parameters.keySet()) {
                if (!"datasource".equals(parameters.get(parameterId).getType().getId())) continue;
                datasourceParameters.add(parameterId);
            }
            for (GroupDirectory groupDirectory : this._groupDirectoryDAO.getGroupDirectories()) {
                if (!groupDirectory.getGroupDirectoryModelId().equals(gdModelId)) continue;
                for (String datasourceParameter : datasourceParameters) {
                    result.add((String)groupDirectory.getParameterValues().get(datasourceParameter));
                }
            }
        }
        return result;
    }
}

