/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.group;

import org.apache.commons.lang3.StringUtils;

public class GroupIdentity {
    private static final String __SEPARATOR = "#";
    private String _id;
    private String _directoryId;

    public GroupIdentity(String id, String directoryId) {
        this._id = id;
        this._directoryId = directoryId;
    }

    public static String groupIdentityToString(GroupIdentity groupIdentity) {
        return groupIdentity.getId() + __SEPARATOR + groupIdentity.getDirectoryId();
    }

    public static GroupIdentity stringToGroupIdentity(String string) {
        String id = StringUtils.substringBeforeLast((String)string, (String)__SEPARATOR);
        String groupDirectoryId = StringUtils.substringAfterLast((String)string, (String)__SEPARATOR);
        return new GroupIdentity(id, groupDirectoryId);
    }

    public String getId() {
        return this._id;
    }

    public String getDirectoryId() {
        return this._directoryId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._directoryId == null ? 0 : this._directoryId.hashCode());
        result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupIdentity other = (GroupIdentity)obj;
        if (this._directoryId == null ? other._directoryId != null : !this._directoryId.equals(other._directoryId)) {
            return false;
        }
        return !(this._id == null ? other._id != null : !this._id.equals(other._id));
    }

    public String toString() {
        return "Group [id=" + this._id + ", directory=" + this._directoryId + "]";
    }
}

