/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.group.directory;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.directory.DefaultGroupDirectoryModel;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.GroupDirectoryModel;
import org.ametys.core.group.directory.GroupDirectoryParameterTypeExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ElementDefinitionParser;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDirectoryFactory
extends AbstractLogEnabled
implements ExtensionPoint<GroupDirectoryModel>,
Initializable,
ThreadSafe,
Component,
Serviceable,
Contextualizable,
Disposable {
    public static final String ROLE = GroupDirectoryFactory.class.getName();
    protected GroupDirectoryParameterTypeExtensionPoint _groupDirectoryParameterTypeExtensionPoint;
    private Map<String, GroupDirectoryModel> _models;
    private ServiceManager _smanager;
    private Context _context;

    public void initialize() throws Exception {
        this._models = new HashMap<String, GroupDirectoryModel>();
    }

    public void dispose() {
        this._models.clear();
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._groupDirectoryParameterTypeExtensionPoint = (GroupDirectoryParameterTypeExtensionPoint)this._smanager.lookup(GroupDirectoryParameterTypeExtensionPoint.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public GroupDirectory createGroupDirectory(String id, I18nizableText label, String modelId, Map<String, Object> paramsValues) {
        if (this._models.containsKey(modelId)) {
            GroupDirectoryModel groupDirectoryModel = this._models.get(modelId);
            GroupDirectory groupDirectory = null;
            Class<GroupDirectory> groupDirectoryClass = groupDirectoryModel.getGroupDirectoryClass();
            try {
                groupDirectory = groupDirectoryClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Cannot instanciate the class " + groupDirectoryClass.getCanonicalName() + ". Check that there is a public constructor with no arguments.");
            }
            Logger logger = LoggerFactory.getLogger(groupDirectoryClass);
            try {
                if (groupDirectory instanceof LogEnabled) {
                    ((LogEnabled)((Object)groupDirectory)).setLogger(logger);
                }
                LifecycleHelper.setupComponent((Object)groupDirectory, (org.apache.avalon.framework.logger.Logger)new SLF4JLoggerAdapter(logger), (Context)this._context, (ServiceManager)this._smanager, (Configuration)groupDirectoryModel.getGroupDirectoryConfiguration());
            }
            catch (Exception e) {
                this.getLogger().warn("An exception occured during the setup of the component " + modelId, (Throwable)e);
            }
            groupDirectory.setId(id);
            groupDirectory.setLabel(label);
            try {
                groupDirectory.init(modelId, paramsValues);
            }
            catch (Exception e) {
                this.getLogger().error("An error occured during the initialization of the GroupDirectory " + id, (Throwable)e);
                return null;
            }
            return groupDirectory;
        }
        return null;
    }

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        block3: {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding group directory model from plugin " + pluginName + "/" + featureName);
            }
            try {
                this.addGroupDirectoryModel(pluginName, configuration);
            }
            catch (ConfigurationException e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("The plugin '" + pluginName + "." + featureName + "' has a group directory model extension but has an incorrect configuration", (Throwable)e);
            }
        }
    }

    protected void addGroupDirectoryModel(String pluginName, Configuration configuration) throws ConfigurationException {
        Configuration[] paramsConfiguration;
        String id = configuration.getAttribute("id");
        I18nizableText label = I18nizableText.parseI18nizableText(configuration.getChild("label"), "plugin." + pluginName);
        I18nizableText description = I18nizableText.parseI18nizableText(configuration.getChild("description"), "plugin." + pluginName);
        String className = null;
        Class<GroupDirectory> groupDirectoryClass = null;
        Configuration classConfig = null;
        try {
            className = configuration.getChild("class").getAttribute("name");
            groupDirectoryClass = Class.forName(className);
            classConfig = configuration.getChild("class");
        }
        catch (ClassNotFoundException | ConfigurationException e) {
            throw new ConfigurationException("Group directory model with id '" + id + "' has an invalid configuration for class name " + (className != null ? className + " <class not found>" : "<missing tag <class>") + "'", e);
        }
        if (!GroupDirectory.class.isAssignableFrom(groupDirectoryClass)) {
            throw new ConfigurationException("Group directory model with id '" + id + "' has an invalid configuration: '" + className + "' is not an instance of GroupDirectory");
        }
        LinkedHashMap<String, ElementDefinition> parameters = new LinkedHashMap<String, ElementDefinition>();
        ThreadSafeComponentManager<Validator> validatorManager = new ThreadSafeComponentManager<Validator>();
        validatorManager.setLogger(this.getLogger());
        validatorManager.contextualize(this._context);
        validatorManager.service(this._smanager);
        ThreadSafeComponentManager<Enumerator> enumeratorManager = new ThreadSafeComponentManager<Enumerator>();
        enumeratorManager.setLogger(this.getLogger());
        enumeratorManager.contextualize(this._context);
        enumeratorManager.service(this._smanager);
        GroupDirectoryModelParameterParser groupDirectoryParser = new GroupDirectoryModelParameterParser(this._groupDirectoryParameterTypeExtensionPoint, enumeratorManager, validatorManager);
        for (Configuration paramConfiguration : paramsConfiguration = configuration.getChild("parameters").getChildren("param")) {
            this.configureParameters(groupDirectoryParser, paramConfiguration, pluginName, parameters);
        }
        try {
            groupDirectoryParser.lookupComponents();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to lookup parameter local components", configuration, (Throwable)e);
        }
        DefaultGroupDirectoryModel groupDirectoryModel = new DefaultGroupDirectoryModel(id, groupDirectoryClass, classConfig, label, description, parameters, pluginName);
        if (this._models.containsKey(id)) {
            GroupDirectoryModel oldUDModel = this._models.get(id);
            throw new IllegalArgumentException("Group directory model with id '" + id + "' is already declared in plugin '" + oldUDModel.getPluginName() + "'. This second declaration is ignored.");
        }
        this._models.put(id, groupDirectoryModel);
    }

    protected void configureParameters(GroupDirectoryModelParameterParser paramParser, Configuration configuration, String pluginName, Map<String, ElementDefinition> parameters) throws ConfigurationException {
        ElementDefinition parameter = paramParser.parse(this._smanager, pluginName, configuration, null, null);
        String id = parameter.getName();
        if (parameters.containsKey(id)) {
            throw new ConfigurationException("The parameter '" + id + "' is already declared. IDs must be unique.", configuration);
        }
        parameters.put(id, parameter);
    }

    @Override
    public void initializeExtensions() throws Exception {
    }

    @Override
    public boolean hasExtension(String id) {
        return this._models.containsKey(id);
    }

    @Override
    public GroupDirectoryModel getExtension(String id) {
        return this._models.get(id);
    }

    @Override
    public Set<String> getExtensionsIds() {
        return this._models.keySet();
    }

    public class GroupDirectoryModelParameterParser
    extends ElementDefinitionParser {
        public GroupDirectoryModelParameterParser(GroupDirectoryParameterTypeExtensionPoint groupDirectoryParameterTypeExtensionPoint, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
            super(groupDirectoryParameterTypeExtensionPoint, enumeratorManager, validatorManager);
        }

        @Override
        protected String _getNameConfigurationAttribute() {
            return "id";
        }
    }
}

