/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.ametys.core.minimize.SourceMapCache;
import org.ametys.core.resources.AbstractResourceHandler;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;

public abstract class AbstractSourceMapResourceHandler
extends AbstractResourceHandler {
    protected SourceMapCache _sourceMapCache;
    protected HashCache _hashCache;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._hashCache = (HashCache)manager.lookup(HashCache.ROLE);
        this._sourceMapCache = (SourceMapCache)manager.lookup(SourceMapCache.ROLE);
    }

    @Override
    public String getMimeType(Source source, Parameters par) {
        return source.getMimeType();
    }

    @Override
    public int getPriority() {
        return -2147483148;
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        Source source = this._getExistingSource(location);
        if (source == null && (source = this._getAlternateSource(location, objectModel)) == null) {
            throw new ResourceNotFoundException("Resource not found for URI : " + location);
        }
        return source;
    }

    protected abstract Source _getAlternateSource(String var1, Map var2) throws ProcessingException, IOException;

    protected Source _getExistingSource(String location) {
        Source source = null;
        try {
            source = this._resolver.resolveURI(location);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return source != null && source.exists() ? source : null;
    }

    @Override
    public void generateResource(Source source, OutputStream out, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        IOUtils.copy((InputStream)source.getInputStream(), (OutputStream)out);
    }
}

