/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.minimize.AbstractSourceMapResourceHandler;
import org.ametys.core.minimize.css.MinimizeCSSManager;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;

public class CSSSourceMapResourceHandler
extends AbstractSourceMapResourceHandler {
    protected MinimizeCSSManager _cssMinimizeManager;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._cssMinimizeManager = (MinimizeCSSManager)manager.lookup(MinimizeCSSManager.ROLE);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)manager.lookup(JSASSResourceURIExtensionPoint.ROLE);
    }

    @Override
    protected Source _getAlternateSource(String location, Map objectModel) throws IOException {
        Source source = null;
        String resolvedLocation = this._jsassResourceURIExtensionPoint.resolve(location);
        source = this._sourceMapCache.get(resolvedLocation != null ? resolvedLocation : location);
        if (source == null) {
            source = this._generateCssSourceMap(objectModel, location);
        }
        return source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Source _generateCssSourceMap(Map objectModel, String location) throws IOException {
        String originalUri = "/" + StringUtils.removeEnd((String)ObjectModelHelper.getRequest((Map)objectModel).getSitemapURI(), (String)".map");
        Source sourceResolved = this._resolver.resolveURI("cocoon:" + originalUri);
        if (sourceResolved == null) return null;
        if (!sourceResolved.exists()) return null;
        try (InputStream inputStream = sourceResolved.getInputStream();){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
            String sourceMapKey = this._jsassResourceURIExtensionPoint.resolve(location);
            this._cssMinimizeManager.minimizeCss(baos.toString(StandardCharsets.UTF_8.toString()), originalUri, sourceMapKey, sourceResolved.getLastModified());
            Source source = this._sourceMapCache.get(sourceMapKey);
            return source;
        }
        catch (ProcessingException e) {
            this.getLogger().error("Unable to compile CSS file", (Throwable)e);
        }
        return null;
    }
}

