/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class JSASSFixHelper {
    private static final Pattern JSASS_INJECTED_PATTERN = Pattern.compile("^([^\"]*\")[^\"]*JSASS_(?:CUSTOM|PRE_IMPORT|POST_IMPORT).scss(\",?)$", 8);

    private JSASSFixHelper() {
    }

    public static String fixJsassSourceMap(String sourceMap, String externalContextPath) {
        String result = sourceMap.replaceAll("\"" + StringUtils.removeStart((String)externalContextPath, (String)"/") + "/", "\"" + externalContextPath + "/");
        Matcher matcher = JSASS_INJECTED_PATTERN.matcher(result);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "$1" + externalContextPath + "/plugins/core/resources/css/jsass_injected_file_placeholder.css$2");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

