/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.minimize.AbstractMinimizeManager;
import org.ametys.core.minimize.css.AmetysCssImporter;
import org.ametys.core.minimize.css.JSASSFixHelper;
import org.ametys.plugins.core.ui.resources.css.CSSFileHelper;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.util.NetUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;

public class MinimizeCSSManager
extends AbstractMinimizeManager
implements Component,
Initializable {
    public static final String ROLE = MinimizeCSSManager.class.getName();
    private static final Pattern IMPORT_PATTERN = Pattern.compile("(?:^|;)\\s*@import\\s+(?:(?:url)?\\(?\\s*[\"']?)([^)\"']*)[\"']?\\)?[ \\t]*([^;\\r\\n]*)?(?:;\\s*\\r?\\n)?", 10);
    private Compiler _jsassCompiler;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;

    public void initialize() throws Exception {
        this._jsassCompiler = new Compiler();
    }

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)smanager.lookup(JSASSResourceURIExtensionPoint.ROLE);
    }

    public String minimizeCss(String code, String location) throws ProcessingException, IOException {
        return this.minimizeCss(code, location, null, null);
    }

    public String minimizeCss(String code, String location, String sourceMapKey, Long lastModified) throws IOException, ProcessingException {
        String fileName = location.substring(location.lastIndexOf("/") + 1);
        boolean withSourceMap = sourceMapKey != null && lastModified != null;
        Output output = this._minimizeCss(location, "", code, withSourceMap);
        String sourceResult = output.getCss();
        if (withSourceMap) {
            String sourceMap = JSASSFixHelper.fixJsassSourceMap(output.getSourceMap(), this._proxiedContextPathProvider.getContextPath());
            this._sourceMapCache.put(sourceMapKey, sourceMap, lastModified);
        }
        sourceResult = sourceResult.trim();
        sourceResult = sourceResult + "\n" + this.formatSourceMappingURL(fileName + ".map");
        return sourceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getUriMinimizedContent(String fileUri, String media, String nestedParentFilesName) {
        Object object;
        Source cssSource = null;
        Source sourceMapSource = null;
        try {
            String originalContent;
            String minimizeFileUri = StringUtils.endsWith((CharSequence)fileUri, (CharSequence)".min.css") ? fileUri : StringUtils.removeEnd((String)fileUri, (String)".css") + ".min.css";
            URI minimizeUri = new URI(minimizeFileUri);
            String uriToResolve = minimizeUri.isAbsolute() ? minimizeFileUri : "cocoon:/" + NetUtils.normalize((String)minimizeFileUri);
            cssSource = this._resolver.resolveURI(uriToResolve);
            InputStream is = cssSource.getInputStream();
            object = null;
            try (BOMInputStream bomIs = new BOMInputStream(is);){
                originalContent = IOUtils.toString((InputStream)bomIs, (String)"UTF-8");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            originalContent = CSSFileHelper.replaceRelativeUri(originalContent, minimizeFileUri, this._jsassResourceURIExtensionPoint, this._proxiedContextPathProvider.getContextPath(), this._proxiedContextPathProvider.getContextPath());
            if (StringUtils.isNotEmpty((CharSequence)media)) {
                originalContent = "@media " + media + " {" + originalContent + "}";
            }
            StringBuffer result = new StringBuffer();
            result.append("/*! File : ");
            result.append(nestedParentFilesName);
            result.append(fileUri);
            result.append(" */\n");
            result.append(originalContent);
            object = result.toString();
        }
        catch (Exception e) {
            String string;
            try {
                this.getLogger().error("Cannot open CSS for aggregation " + fileUri, (Throwable)e);
                string = "/** ERROR " + e.getMessage() + "*/\n";
            }
            catch (Throwable throwable) {
                this._resolver.release(cssSource);
                this._resolver.release(sourceMapSource);
                throw throwable;
            }
            this._resolver.release(cssSource);
            this._resolver.release(sourceMapSource);
            return string;
        }
        this._resolver.release(cssSource);
        this._resolver.release(sourceMapSource);
        return object;
    }

    private Output _minimizeCss(String cssUri, String nestedParentFilesName, String originalContent, boolean generateSourceMap) throws ProcessingException {
        try {
            String content = originalContent;
            Options options = new Options();
            options.setOutputStyle(OutputStyle.COMPRESSED);
            if (generateSourceMap) {
                options.setSourceMapFile(new URI("unused"));
                options.setOmitSourceMapUrl(true);
            }
            AmetysCssImporter cssImporter = new AmetysCssImporter();
            options.getImporters().add(cssImporter);
            URI uri = new URI(cssUri);
            String contextualizedUri = uri.isAbsolute() ? this._jsassResourceURIExtensionPoint.resolve(uri.toString()) : uri.toString();
            content = CSSFileHelper.replaceRelativeUri(content, contextualizedUri, this._jsassResourceURIExtensionPoint, this._proxiedContextPathProvider.getContextPath(), this._proxiedContextPathProvider.getContextPath());
            content = this._resolveImportUrl(content, nestedParentFilesName + cssUri + " > ");
            URI computedMinimizedUri = this._computeMinimizedUri(FilenameUtils.getName((String)cssUri));
            return this._jsassCompiler.compileString(content, new URI(FilenameUtils.getName((String)cssUri)), computedMinimizedUri, options);
        }
        catch (CompilationException | URISyntaxException e) {
            throw new ProcessingException("Unable to Minimize the css file: " + cssUri, e);
        }
    }

    private URI _computeMinimizedUri(String sourceMapUri) throws URISyntaxException {
        return new URI(StringUtils.removeEnd((String)sourceMapUri, (String)".css") + ".min.css");
    }

    private String _resolveImportUrl(String content, String nestedParentFilesName) throws URISyntaxException {
        StringBuffer sb = new StringBuffer();
        Matcher importMatcher = IMPORT_PATTERN.matcher(content);
        while (importMatcher.find()) {
            String cssUrl = importMatcher.group(1);
            String media = importMatcher.group(2);
            if (cssUrl == null || cssUrl.startsWith("http://") || cssUrl.startsWith("https")) continue;
            URI uri = new URI(cssUrl);
            String uriToCompile = uri.isAbsolute() ? cssUrl : StringUtils.removeStart((String)cssUrl, (String)this._proxiedContextPathProvider.getContextPath());
            String importedContent = this.getUriMinimizedContent(uriToCompile, media, nestedParentFilesName);
            importedContent = importedContent + " /*! File end : " + nestedParentFilesName + uriToCompile + " */";
            importMatcher.appendReplacement(sb, Matcher.quoteReplacement(importedContent));
        }
        importMatcher.appendTail(sb);
        return sb.toString();
    }

    @Override
    protected void addSourceMap(SourceMapGeneratorV3 sourceMapGenerator, int lineCount, String fileContent, String fileUri, String sourceMapUri) {
        try {
            String sourceMapContent;
            block31: {
                sourceMapContent = null;
                String sourceMapKey = fileUri.indexOf(47) > -1 ? new URI(StringUtils.substringBeforeLast((String)fileUri, (String)"/") + "/" + sourceMapUri).normalize().toString() : sourceMapUri;
                sourceMapKey = StringUtils.removeStart((String)sourceMapKey, (String)this._proxiedContextPathProvider.getContextPath());
                Source mapSource = this._sourceMapCache.get(sourceMapKey);
                if (mapSource != null) {
                    try (InputStream is = mapSource.getInputStream();){
                        sourceMapContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                }
                String uriToResolve = new URI(sourceMapKey).isAbsolute() ? sourceMapKey : "cocoon:/" + sourceMapKey;
                try {
                    mapSource = this._resolver.resolveURI(uriToResolve);
                    if (!mapSource.exists()) break block31;
                    try (InputStream is = mapSource.getInputStream();){
                        sourceMapContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (sourceMapContent != null) {
                sourceMapContent = super.convertSourceMapURIs(sourceMapContent, fileUri);
                sourceMapContent = JSASSFixHelper.fixJsassSourceMap(sourceMapContent, this._proxiedContextPathProvider.getContextPath());
                sourceMapGenerator.mergeMapSection(lineCount + 1, 0, sourceMapContent);
            } else {
                this.getLogger().warn("Unable to retrieve source map when aggregating hash file, for sourceMappingURL '" + sourceMapUri + "' of file '" + fileUri + "'");
            }
        }
        catch (SourceMapParseException | IOException | IllegalStateException | URISyntaxException e) {
            this.getLogger().error("Unable to merge source map to the CSS minimized source map", e);
        }
    }

    @Override
    protected boolean isSourceMappingURLLine(String line) {
        return line != null && line.startsWith("/*# sourceMappingURL=") && line.endsWith(" */");
    }

    @Override
    protected String getSourceMappingURL(String line) {
        return line.substring("/*# sourceMappingURL=".length(), line.length() - " */".length()).trim();
    }

    @Override
    protected String removeSourceMappingURLLine(String content) {
        return content.substring(0, content.lastIndexOf("/*# sourceMappingURL="));
    }

    @Override
    protected String formatSourceMappingURL(String sourceMapName) {
        return "/*# sourceMappingURL=" + sourceMapName + " */\n";
    }
}

