/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.util.List;
import org.ametys.core.model.type.AbstractElementType;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractLongElementType
extends AbstractElementType<Long> {
    public static final String TYPE_ID = "long";

    @Override
    public Long castValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return Long.valueOf(value);
    }

    @Override
    public Object fromJSONForClient(Object json) {
        if (json == null) {
            return null;
        }
        if (json instanceof Number) {
            return ((Number)json).longValue();
        }
        if (json instanceof List) {
            List jsonList = (List)json;
            Long[] result = new Long[jsonList.size()];
            for (int i = 0; i < jsonList.size(); ++i) {
                Object singleJSON = jsonList.get(i);
                if (!(singleJSON instanceof Number)) {
                    throw new IllegalArgumentException("Try to convert the non Long JSON object '" + json + "' into a Long");
                }
                result[i] = ((Number)singleJSON).longValue();
            }
            return result;
        }
        throw new IllegalArgumentException("Try to convert the non Long JSON object '" + json + "' into a Long");
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

