/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.resources.ResourceHandler;
import org.ametys.core.resources.ResourceHandlerExtensionPoint;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.SAXException;

public class ResourceReader
extends ServiceableReader
implements CacheableProcessingComponent {
    public static final String LAST_MODIFIED = "lastModified";
    private ResourceHandlerExtensionPoint _resourcesHandlerEP;
    private ResourceHandler _resourceHandler;
    private SourceResolver _resolver;
    private Source _source;
    private Map<String, Object> _additionalParameters;

    public void service(ServiceManager sManager) throws ServiceException {
        super.service(sManager);
        this._resourcesHandlerEP = (ResourceHandlerExtensionPoint)sManager.lookup(ResourceHandlerExtensionPoint.ROLE);
        this._resolver = (SourceResolver)sManager.lookup(SourceResolver.ROLE);
    }

    public void setup(org.apache.cocoon.environment.SourceResolver res, Map objModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(res, objModel, src, par);
        this._resourceHandler = this._resourcesHandlerEP.getResourceHandler(this.source);
        if (this._resourceHandler == null) {
            throw new ProcessingException("No resource handler found for current resource '" + this.source + "'");
        }
        this._additionalParameters = new HashMap<String, Object>();
        this._source = this._resourceHandler.setup(this.source, objModel, this.parameters, this._additionalParameters);
        Map params = (Map)this.objectModel.get("parent-context");
        if (params != null) {
            params.put(LAST_MODIFIED, this.getLastModified());
        }
    }

    public void generate() throws IOException, ProcessingException {
        this._resourceHandler.generateResource(this._source, this.out, this.objectModel, this.parameters, this._additionalParameters);
        this.out.flush();
    }

    public Serializable getKey() {
        return this._resourceHandler != null ? this._resourceHandler.getKey(this._source, this.objectModel, this.parameters, this._additionalParameters) : null;
    }

    public SourceValidity getValidity() {
        return this._resourceHandler != null ? this._resourceHandler.getValidity(this._source, this.objectModel, this.parameters, this._additionalParameters) : null;
    }

    public void recycle() {
        super.recycle();
        this._resolver.release(this._source);
        this._resourceHandler = null;
    }

    public String getMimeType() {
        return this._resourceHandler != null ? this._resourceHandler.getMimeType(this._source, this.parameters) : super.getMimeType();
    }

    public long getLastModified() {
        return this._resourceHandler != null ? this._resourceHandler.getLastModified(this._source, this.parameters) : super.getLastModified();
    }
}

