/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;

public interface AccessController {
    public AccessResult getPermission(UserIdentity var1, Set<GroupIdentity> var2, String var3, Object var4);

    public AccessResult getReadAccessPermission(UserIdentity var1, Set<GroupIdentity> var2, Object var3);

    public Map<String, AccessResult> getPermissionByRight(UserIdentity var1, Set<GroupIdentity> var2, Object var3);

    public AccessResult getPermissionForAnonymous(String var1, Object var2);

    public AccessResult getReadAccessPermissionForAnonymous(Object var1);

    public AccessResult getPermissionForAnyConnectedUser(String var1, Object var2);

    public AccessResult getReadAccessPermissionForAnyConnectedUser(Object var1);

    public Map<UserIdentity, AccessResult> getPermissionByUser(String var1, Object var2);

    public Map<UserIdentity, AccessResult> getReadAccessPermissionByUser(Object var1);

    public Map<GroupIdentity, AccessResult> getPermissionByGroup(String var1, Object var2);

    public Map<GroupIdentity, AccessResult> getReadAccessPermissionByGroup(Object var1);

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> var1, UserIdentity var2, Set<GroupIdentity> var3, String var4);

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> var1, UserIdentity var2, Set<GroupIdentity> var3);

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> var1, String var2);

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> var1);

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> var1, String var2);

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> var1);

    public boolean isSupported(Object var1);

    public static enum AccessResult {
        ANONYMOUS_ALLOWED,
        USER_DENIED,
        USER_ALLOWED,
        GROUP_DENIED,
        GROUP_ALLOWED,
        ANY_CONNECTED_DENIED,
        ANY_CONNECTED_ALLOWED,
        ANONYMOUS_DENIED,
        UNKNOWN;


        public RightManager.RightResult toRightResult() {
            switch (this) {
                case USER_DENIED: 
                case GROUP_DENIED: 
                case ANY_CONNECTED_DENIED: 
                case ANONYMOUS_DENIED: {
                    return RightManager.RightResult.RIGHT_DENY;
                }
                case USER_ALLOWED: 
                case GROUP_ALLOWED: 
                case ANY_CONNECTED_ALLOWED: 
                case ANONYMOUS_ALLOWED: {
                    return RightManager.RightResult.RIGHT_ALLOW;
                }
            }
            return RightManager.RightResult.RIGHT_UNKNOWN;
        }

        public static AccessResult merge(Collection<AccessResult> accessResults) {
            return accessResults.stream().filter(r -> r != null).min(Comparator.naturalOrder()).orElse(UNKNOWN);
        }

        public static AccessResult merge(AccessResult ... accessResults) {
            return Arrays.stream(accessResults).filter(r -> r != null).min(Comparator.naturalOrder()).orElse(UNKNOWN);
        }
    }
}

