/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.right;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.Right;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RightsExtensionPoint
extends AbstractLogEnabled
implements ExtensionPoint<Right>,
Initializable,
ThreadSafe,
Component {
    public static final String ROLE = RightsExtensionPoint.class.getName();
    protected Map<String, Right> _rights;

    public void initialize() throws Exception {
        this._rights = new HashMap<String, Right>();
    }

    @Override
    public boolean hasExtension(String id) {
        return this._rights.containsKey(id);
    }

    @Override
    public void addExtension(String id, String pluginName, String pluginId, Configuration configuration) throws ConfigurationException {
        block4: {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding rights from plugin " + pluginName + "/" + pluginId);
            }
            try {
                Configuration[] rightsConfigurations;
                for (Configuration rightConfiguration : rightsConfigurations = configuration.getChildren("right")) {
                    this.addRight(pluginName, rightConfiguration);
                }
            }
            catch (ConfigurationException e) {
                if (!this.getLogger().isWarnEnabled()) break block4;
                this.getLogger().warn("The plugin '" + pluginName + "." + pluginId + "' has a rights extension but has an incorrect configuration", (Throwable)e);
            }
        }
    }

    protected void addRight(String pluginName, Configuration configuration) throws ConfigurationException {
        String id = configuration.getAttribute("id", "");
        if (id.length() == 0) {
            throw new ConfigurationException("Right declaration is incorrect since no 'Id' attribute is specified (or may be empty)", configuration);
        }
        String label = configuration.getChild("label").getValue("");
        if (label.length() == 0) {
            throw new ConfigurationException("Right declaration is incorrect since no 'label' element is specified (or may be empty)", configuration);
        }
        I18nizableText i18nLabel = new I18nizableText("plugin." + pluginName, label);
        String description = configuration.getChild("description").getValue("");
        if (description.length() == 0) {
            throw new ConfigurationException("Right declaration is incorrect since no 'description' element is specified (or may be empty)", configuration);
        }
        I18nizableText i18nDescription = new I18nizableText("plugin." + pluginName, description);
        String category = configuration.getChild("category").getValue("");
        if (category.length() == 0) {
            throw new ConfigurationException("Right declaration is incorrect since no 'category' element is specified (or may be empty)", configuration);
        }
        I18nizableText i18nCategory = new I18nizableText("plugin." + pluginName, category);
        if (this._rights.containsKey(id)) {
            Right right = this._rights.get(id);
            throw new ConfigurationException("Right with id '" + id + "' is already declared : '" + right.getDeclaration() + "'. This second declaration is ignored.", configuration);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Adding right ID : " + id);
        }
        Right right = new Right(id, i18nLabel, i18nDescription, i18nCategory, "Declared by plugin '" + pluginName + "'");
        if (this._rights.containsKey(id)) {
            Right oldright = this._rights.get(id);
            throw new IllegalArgumentException("Right with id '" + id + "' is already declared : '" + oldright.getDeclaration() + "'. This second declaration is ignored.");
        }
        this._rights.put(id, right);
    }

    public void addRight(String id, I18nizableText labelKey, I18nizableText descriptionKey, I18nizableText categoryKey) throws IllegalArgumentException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Adding right from API with ID : " + id);
        }
        if (this._rights.containsKey(id)) {
            Right right = this._rights.get(id);
            throw new IllegalArgumentException("Right with id '" + id + "' is already declared : '" + right.getDeclaration() + "'. This second declaration is ignored.");
        }
        Right right = new Right(id, labelKey, descriptionKey, categoryKey, "Declared by API");
        this._rights.put(id, right);
    }

    @Override
    public Right getExtension(String id) {
        return this._rights.get(id);
    }

    @Override
    public Set<String> getExtensionsIds() {
        return new HashSet<String>(this._rights.keySet());
    }

    @Override
    public void initializeExtensions() throws Exception {
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        for (String id : this._rights.keySet()) {
            Right right = this._rights.get(id);
            right.toSAX(handler);
        }
    }
}

