/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.right.RightAssignmentContext;
import org.ametys.core.right.RightAssignmentContextExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.plugin.ExtensionPoint;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ExecuteClientCallsAction
extends ServiceableAction
implements ThreadSafe {
    private RightManager _rightManager;
    private CurrentUserProvider _currentUserProvider;
    private RightAssignmentContextExtensionPoint _rightCtxEP;

    private RightManager _getRightManager() {
        if (this._rightManager == null) {
            try {
                this._rightManager = (RightManager)this.manager.lookup(RightManager.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._rightManager;
    }

    private CurrentUserProvider _getCurrentUserProvider() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this.manager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._currentUserProvider;
    }

    private RightAssignmentContextExtensionPoint _getRightContextEP() {
        if (this._rightCtxEP == null) {
            try {
                this._rightCtxEP = (RightAssignmentContextExtensionPoint)this.manager.lookup(RightAssignmentContextExtensionPoint.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._rightCtxEP;
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Object[] paramValues;
        Object[] paramClass;
        Object object;
        Map jsParameters = (Map)objectModel.get("parent-context");
        String role = (String)jsParameters.get("role");
        if (role == null) {
            throw new IllegalArgumentException("Component role should be present.");
        }
        if (!this.manager.hasService(role)) {
            throw new IllegalArgumentException("The role '" + role + "' does not correspond to a valid component.");
        }
        Object component = this.manager.lookup(role);
        if (component instanceof ExtensionPoint) {
            ExtensionPoint extPoint = (ExtensionPoint)component;
            String id = (String)jsParameters.get("id");
            if (id == null) {
                object = component;
            } else {
                object = extPoint.getExtension(id);
                if (object == null) {
                    throw new IllegalArgumentException("The id '" + id + "' does not correspond to a valid extension for point " + role);
                }
            }
        } else {
            object = component;
        }
        String methodName = (String)jsParameters.get("methodName");
        List params = (List)jsParameters.get("parameters");
        if (methodName == null) {
            throw new IllegalArgumentException("No method name present, cannot execute server side code.");
        }
        if (params == null) {
            paramClass = new Class[]{};
            paramValues = new Object[]{};
        } else {
            paramValues = params.toArray();
            paramClass = ClassUtils.toClass((Object[])paramValues);
        }
        Class<?> clazz = object.getClass();
        Method method = MethodUtils.getMatchingAccessibleMethod(clazz, (String)methodName, (Class[])paramClass);
        if (method == null) {
            throw new IllegalArgumentException("No method with signature " + methodName + "(" + StringUtils.join((Object[])paramClass, (String)", ").replaceAll("class ", "") + ") present in class " + clazz.getName() + ".");
        }
        Object result = this._executeMethod(method, object, paramValues);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    protected Object _executeMethod(Method method, Object object, Object[] paramValues) throws Exception {
        Object result = null;
        if (!method.isAnnotationPresent(Callable.class)) {
            throw new IllegalArgumentException("Trying to call a non-callable method: " + method.toGenericString() + ".");
        }
        this._checkAccess(method, paramValues);
        result = method.invoke(object, paramValues);
        return result;
    }

    private void _checkAccess(Method method, Object[] paramValues) {
        Callable callable = method.getAnnotation(Callable.class);
        if (StringUtils.isNotEmpty((CharSequence)callable.right())) {
            UserIdentity currentUser = this._getCurrentUserProvider().getUser();
            Object context = this._getRightContext(method, callable, paramValues);
            if (this._getRightManager().hasRight(currentUser, callable.right(), context) != RightManager.RightResult.RIGHT_ALLOW) {
                throw new AccessDeniedException("The user " + currentUser + " tried to access the callable method [" + method.toGenericString() + "] without sufficient rights");
            }
        }
    }

    private Object _getRightContext(Method method, Callable callable, Object[] paramValues) {
        if (StringUtils.isNotEmpty((CharSequence)callable.rightContext())) {
            int index = callable.paramIndex();
            if (index < 0 || index > paramValues.length - 1) {
                throw new IllegalArgumentException("Callable method [" + method.toGenericString() + "] refers to a invalid 'paramIndex' " + index + ".");
            }
            Object jsContext = paramValues[index];
            String rightCtxId = callable.rightContext();
            RightAssignmentContext rightCtx = (RightAssignmentContext)this._getRightContextEP().getExtension(rightCtxId);
            if (rightCtx == null) {
                throw new IllegalArgumentException("Callable method [" + method.toGenericString() + "] refers to a unknown 'rightContext' of id " + rightCtxId + ".");
            }
            Object context = rightCtx.convertJSContext(jsContext);
            if (context == null) {
                throw new IllegalArgumentException("Right object context not found for value " + jsContext + ". Unable to check right for callable method: " + method.toGenericString() + ".");
            }
            return context;
        }
        return callable.context();
    }
}

