/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.ArrayList;
import java.util.List;
import org.ametys.core.ui.ClientSideRelation;
import org.ametys.core.ui.MessageTargetFactoriesManager;
import org.ametys.core.ui.StaticClientSideElement;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class StaticClientSideRelation
extends StaticClientSideElement
implements ClientSideRelation {
    List<String> _sourceRelationType;
    List<String> _targetRelationType;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this._sourceRelationType = new ArrayList<String>();
        this._targetRelationType = new ArrayList<String>();
        ArrayList<String> messageTargetDependencies = new ArrayList<String>();
        if (configuration.getChild("relations", false) != null) {
            for (Configuration relationConfiguration : configuration.getChild("relations").getChildren()) {
                String relationType = relationConfiguration.getName();
                String relation = relationConfiguration.getValue();
                if ("source".equals(relationType)) {
                    this._sourceRelationType.add(relation);
                    messageTargetDependencies.add(relation);
                    continue;
                }
                if ("target".equals(relationType)) {
                    this._targetRelationType.add(relation);
                    messageTargetDependencies.add(relation);
                    continue;
                }
                throw new ConfigurationException("Unsupported relation type for StaticClientSideRelation : " + relationType, configuration);
            }
        }
        super.configure(configuration);
        for (String messageTargetFactory : messageTargetDependencies) {
            this._addMessageTargetDependency(messageTargetFactory);
        }
    }

    private void _addMessageTargetDependency(String messageTargetFactory) {
        if (this._dependencies.containsKey(MessageTargetFactoriesManager.ROLE)) {
            List extensions = (List)this._dependencies.get(MessageTargetFactoriesManager.ROLE);
            extensions.add(messageTargetFactory);
        } else {
            ArrayList<String> extensions = new ArrayList<String>();
            extensions.add(messageTargetFactory);
            this._dependencies.put(MessageTargetFactoriesManager.ROLE, extensions);
        }
    }

    @Override
    public List<String> getSourceRelationType() {
        return this._sourceRelationType;
    }

    @Override
    public List<String> getTargetRelationType() {
        return this._targetRelationType;
    }
}

