/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.ui.util.ConfigurationHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public class StaticFileImportsClientSideElement
extends AbstractLogEnabled
implements ClientSideElement,
Configurable,
PluginAware,
Serviceable {
    protected CurrentUserProvider _currentUserProvider;
    protected RightManager _rightManager;
    protected String _id;
    protected ClientSideElement.Script _script;
    protected Map<String, String> _rights;
    protected String _rightsMode;
    protected Map<String, List<String>> _dependencies;
    protected String _pluginName;
    protected String _featureName;

    public void service(ServiceManager smanager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
        this._pluginName = pluginName;
        this._featureName = featureName;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configuring element '" + this._id + "'");
        }
        this._script = this._configureScript(configuration);
        this._rights = this._configureRights(configuration);
        this._rightsMode = this._configureRightsMode(configuration);
        this._dependencies = this._configureDependencies(configuration);
    }

    protected ClientSideElement.Script _configureScript(Configuration configuration) throws ConfigurationException {
        List<ClientSideElement.ScriptFile> scriptsImports = this._configureImports(configuration.getChild("scripts"));
        List<ClientSideElement.ScriptFile> cssImports = this._configureImports(configuration.getChild("css"));
        return new ClientSideElement.Script(this.getId(), "", scriptsImports, cssImports, new HashMap<String, Object>());
    }

    protected List<ClientSideElement.ScriptFile> _configureImports(Configuration configuration) throws ConfigurationException {
        return ConfigurationHelper.parsePluginResourceList(configuration, this.getPluginName(), this.getLogger());
    }

    protected Map<String, String> _configureRights(Configuration configuration) throws ConfigurationException {
        HashMap<String, String> rights = new HashMap<String, String>();
        Configuration[] rightsConf = configuration.getChild("rights", false) != null ? configuration.getChild("rights").getChildren("right") : configuration.getChildren("right");
        for (Configuration rightConf : rightsConf) {
            String right = rightConf.getValue("");
            if (right.length() != 0) {
                String[] rightIds;
                String prefix = rightConf.getAttribute("context-prefix", null);
                for (String rightId : rightIds = right.split("\\|")) {
                    rights.put(rightId, prefix);
                }
                continue;
            }
            String message = "The optional right element is empty.";
            this.getLogger().error(message);
            throw new ConfigurationException(message, configuration);
        }
        return rights;
    }

    protected String _configureRightsMode(Configuration configuration) throws ConfigurationException {
        return "AND".equals(configuration.getChild("rights").getAttribute("mode", "OR").toUpperCase()) ? "AND" : "OR";
    }

    protected Map<String, List<String>> _configureDependencies(Configuration configuration) throws ConfigurationException {
        HashMap<String, List<String>> dependencies = new HashMap<String, List<String>>();
        if (configuration.getChild("depends", false) != null) {
            for (Configuration dependency : configuration.getChild("depends").getChildren()) {
                List<String> extensions;
                String extensionPointName = dependency.getName();
                String dependencyValue = dependency.getValue();
                if (StringUtils.isEmpty((String)dependencyValue) || StringUtils.isEmpty((String)extensionPointName)) {
                    throw new ConfigurationException("Invalid configuration for dependencies", configuration);
                }
                if (dependencies.containsKey(extensionPointName)) {
                    extensions = (List)dependencies.get(extensionPointName);
                    extensions.add(dependencyValue);
                    continue;
                }
                extensions = new ArrayList();
                extensions.add(dependencyValue);
                dependencies.put(extensionPointName, extensions);
            }
        }
        return dependencies;
    }

    protected boolean hasRight(Map<String, String> rights) {
        if (rights.isEmpty()) {
            return true;
        }
        UserIdentity user = this._currentUserProvider.getUser();
        Set<String> rightsToCheck = rights.keySet();
        for (String rightToCheck : rightsToCheck) {
            if (!StringUtils.isNotEmpty((String)rightToCheck)) continue;
            String rightContext = rights.get(rightToCheck);
            if (this._rightManager.hasRight(user, rightToCheck, rightContext) == RightManager.RightResult.RIGHT_ALLOW) {
                if (!"OR".equals(this._rightsMode)) continue;
                return true;
            }
            if (!"AND".equals(this._rightsMode)) continue;
            return false;
        }
        return "AND".equals(this._rightsMode);
    }

    @Override
    public final List<ClientSideElement.Script> getScripts(Map<String, Object> contextParameters) {
        return this.getScripts(false, contextParameters);
    }

    @Override
    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        if (ignoreRights) {
            ArrayList<ClientSideElement.Script> scripts = new ArrayList<ClientSideElement.Script>();
            scripts.add(this._script);
            return scripts;
        }
        if (this.hasRight(this.getRights(contextParameters))) {
            ArrayList<ClientSideElement.Script> scripts = new ArrayList<ClientSideElement.Script>();
            scripts.add(this._script);
            return scripts;
        }
        return new ArrayList<ClientSideElement.Script>();
    }

    @Override
    public Map<String, String> getRights(Map<String, Object> contextParameters) {
        return this._rights;
    }

    @Override
    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public Map<String, List<String>> getDependencies() {
        return this._dependencies;
    }

    public String toString() {
        return this._id + (this._dependencies != null && this._dependencies.size() > 0 ? " " + this._dependencies : "");
    }
}

