/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.dispatcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.dispatcher.DispatchProcessExtensionPoint;
import org.ametys.core.ui.dispatcher.DispatchRequestProcess;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.util.RequestAttributesHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.util.location.LocatedException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DispatchGenerator
extends ServiceableGenerator {
    protected RequestAttributesHelper _requestAttributesHelper;
    private SourceResolver _resolver;
    private DispatchProcessExtensionPoint _dispatchProcessExtensionPoint;
    private JSONUtils _jsonUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        this._dispatchProcessExtensionPoint = (DispatchProcessExtensionPoint)this.manager.lookup(DispatchProcessExtensionPoint.ROLE);
        this._jsonUtils = (JSONUtils)this.manager.lookup(JSONUtils.ROLE);
        this._requestAttributesHelper = (RequestAttributesHelper)this.manager.lookup(RequestAttributesHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        String parametersAsJSONString = this._getRequestBody();
        Map<String, Object> parametersAsMap = this._jsonUtils.convertJsonToMap(parametersAsJSONString);
        String contextAsJSONString = this._getRequestContext();
        Map<String, Object> contextAsMap = this._jsonUtils.convertJsonToMap(contextAsJSONString);
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"responses");
        this._dispatching(parametersAsMap, contextAsMap);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"responses");
        this.contentHandler.endDocument();
    }

    private String _getRequestBody() {
        return ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("content");
    }

    private String _getRequestContext() {
        return ObjectModelHelper.getRequest((Map)this.objectModel).getParameter("context.parameters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _dispatching(Map<String, Object> parametersAsMap, Map<String, Object> contextAsMap) throws SAXException {
        Map<String, Object> attributes = this._requestAttributesHelper.saveRequestAttributes();
        contextAsMap.putAll(this.transmitAttributes(attributes));
        HashMap<String, Long> times = new HashMap<String, Long>();
        for (String parameterKey : parametersAsMap.keySet()) {
            DispatchRequestProcess processor;
            Source response;
            long t0;
            block32: {
                t0 = System.currentTimeMillis();
                this._requestAttributesHelper.removeRequestAttributes();
                for (String extension : this._dispatchProcessExtensionPoint.getExtensionsIds()) {
                    DispatchRequestProcess processor2 = (DispatchRequestProcess)this._dispatchProcessExtensionPoint.getExtension(extension);
                    processor2.preProcess(ObjectModelHelper.getRequest((Map)this.objectModel));
                }
                this._setContextInRequestAttributes(contextAsMap);
                Map parameterObject = (Map)parametersAsMap.get(parameterKey);
                String pluginOrWorkspace = (String)parameterObject.get("pluginOrWorkspace");
                String relativeUrl = (String)parameterObject.get("url");
                String responseType = (String)parameterObject.get("responseType");
                Map requestParameters = (Map)parameterObject.get("parameters");
                response = null;
                ResponseHandler responseHandler = null;
                try {
                    String url = this._createUrl(pluginOrWorkspace, relativeUrl, requestParameters != null ? requestParameters : new HashMap());
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Dispatching url '" + (String)url + "'");
                    }
                    response = this._resolver.resolveURI(url, null, requestParameters);
                    responseHandler = new ResponseHandler(this.contentHandler, parameterKey, "200");
                    try (InputStream is = response.getInputStream();){
                        if ("xml".equalsIgnoreCase(responseType)) {
                            SAXParser saxParser = null;
                            try {
                                saxParser = (SAXParser)this.manager.lookup(SAXParser.ROLE);
                                saxParser.parse(new InputSource(is), (ContentHandler)((Object)responseHandler));
                                break block32;
                            }
                            catch (ServiceException e) {
                                throw new ProcessingException("Unable to get a SAX parser", (Throwable)e);
                            }
                            finally {
                                this.manager.release((Object)saxParser);
                            }
                        }
                        responseHandler.startDocument();
                        String data = IOUtils.toString((InputStream)is, (String)"UTF-8");
                        if ("xml2text".equalsIgnoreCase(responseType)) {
                            data = data.substring(data.indexOf(">", data.indexOf("?>") + 2) + 1, data.lastIndexOf("<"));
                        }
                        XMLUtils.data((ContentHandler)((Object)responseHandler), (String)data);
                        responseHandler.endDocument();
                    }
                }
                catch (Throwable e) {
                    try {
                        String message = String.format("Can not dispatch request '%s' : '%s' '%s' '%s'", parameterKey, pluginOrWorkspace, relativeUrl, requestParameters);
                        this.getLogger().error(message, (Throwable)new LocatedException(message, e));
                        if (responseHandler != null) {
                            responseHandler.exceptionFinish();
                        }
                        Throwable t = this._unroll(e);
                        String code = "500";
                        if (t instanceof ResourceNotFoundException || t.toString().startsWith("org.apache.cocoon.ResourceNotFoundException:")) {
                            code = "404";
                        }
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addCDATAAttribute("id", parameterKey);
                        attrs.addCDATAAttribute("code", code);
                        String exceptionMessage = t.getMessage();
                        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"response", (Attributes)attrs);
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"message", (String)this._escape(exceptionMessage != null ? exceptionMessage : ""));
                        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"stacktrace", (String)this._escape(ExceptionUtils.getFullStackTrace((Throwable)t)));
                        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"response");
                    }
                    catch (Throwable throwable) {
                        this._resolver.release(response);
                        for (String extension : this._dispatchProcessExtensionPoint.getExtensionsIds()) {
                            DispatchRequestProcess processor3 = (DispatchRequestProcess)this._dispatchProcessExtensionPoint.getExtension(extension);
                            processor3.postProcess(ObjectModelHelper.getRequest((Map)this.objectModel));
                        }
                        throw throwable;
                    }
                    this._resolver.release(response);
                    for (String extension : this._dispatchProcessExtensionPoint.getExtensionsIds()) {
                        processor = (DispatchRequestProcess)this._dispatchProcessExtensionPoint.getExtension(extension);
                        processor.postProcess(ObjectModelHelper.getRequest((Map)this.objectModel));
                    }
                }
            }
            this._resolver.release(response);
            for (String extension : this._dispatchProcessExtensionPoint.getExtensionsIds()) {
                processor = (DispatchRequestProcess)this._dispatchProcessExtensionPoint.getExtension(extension);
                processor.postProcess(ObjectModelHelper.getRequest((Map)this.objectModel));
            }
            long t1 = System.currentTimeMillis();
            long time = t1 - t0;
            times.put(parameterKey, time);
            this.getLogger().debug("Request '" + parameterKey + "' took " + time + "ms");
        }
        this._requestAttributesHelper.restoreRequestAttributes(attributes);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("duration", Long.toString(times.values().stream().mapToLong(Long::longValue).sum()));
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"times", (Attributes)attrs);
        for (String parameterKey : times.keySet()) {
            AttributesImpl internalAttrs = new AttributesImpl();
            internalAttrs.addCDATAAttribute("id", parameterKey);
            internalAttrs.addCDATAAttribute("duration", Long.toString((Long)times.get(parameterKey)));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"time", (Attributes)internalAttrs);
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"times");
    }

    protected Map<String, Object> transmitAttributes(Map<String, Object> attributes) {
        String[] attributesToTransmit;
        HashMap<String, Object> contextAsMap = new HashMap<String, Object>();
        for (String attributeToTransmit : attributesToTransmit = new String[]{"Runtime:RequestAuthenticated", "inWorkspaceURL", "workspaceName", "workspaceTheme", "workspaceThemeURL", "workspaceURI", RightManager.CACHE_REQUEST_ATTRIBUTE_NAME}) {
            contextAsMap.put(attributeToTransmit, attributes.get(attributeToTransmit));
        }
        return contextAsMap;
    }

    private Throwable _unroll(Throwable initial) {
        Throwable t = initial;
        while (t.getCause() != null || t instanceof SAXException && ((SAXException)t).getException() != null) {
            if (t instanceof SAXException) {
                t = ((SAXException)t).getException();
                continue;
            }
            t = t.getCause();
        }
        return t;
    }

    protected void _setContextInRequestAttributes(Map<String, Object> contextAsMap) {
        if (contextAsMap != null) {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            for (String name : contextAsMap.keySet()) {
                request.setAttribute(name, contextAsMap.get(name));
            }
        }
    }

    private String _escape(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;".replaceAll(">", "&gt;"));
    }

    protected String _createUrl(String pluginOrWorkspace, String relativeUrl, Map<String, Object> requestParameters) {
        StringBuilder url;
        block7: {
            String[] queryParameters;
            int queryIndex;
            block6: {
                url = new StringBuilder();
                String urlPrefix = this._getUrlPrefix(pluginOrWorkspace);
                url.append(urlPrefix);
                url.append(this._getRelativePath(relativeUrl));
                queryIndex = relativeUrl.indexOf("?");
                if (queryIndex != -1 || requestParameters.isEmpty()) break block6;
                url.append("?");
                for (String key : requestParameters.keySet()) {
                    Object value = requestParameters.get(key);
                    if (value instanceof List) {
                        List valueAsList = (List)value;
                        for (Object v : valueAsList) {
                            if (v == null) continue;
                            url.append((CharSequence)this._buildQueryParameter(key, v));
                        }
                        continue;
                    }
                    if (value == null) continue;
                    url.append((CharSequence)this._buildQueryParameter(key, value));
                }
                break block7;
            }
            if (queryIndex <= 0) break block7;
            url.append("?");
            String queryUrl = relativeUrl.substring(queryIndex + 1, relativeUrl.length());
            for (String queryParameter : queryParameters = queryUrl.split("&")) {
                if (!StringUtils.isNotBlank((String)queryParameter)) continue;
                String[] part = queryParameter.split("=");
                String key = part[0];
                String v = part.length > 1 ? part[1] : "";
                try {
                    String value = URLDecoder.decode(v, "UTF-8");
                    url.append((CharSequence)this._buildQueryParameter(key, value));
                    if (requestParameters.containsKey(key)) continue;
                    requestParameters.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    this.getLogger().error("Unsupported encoding for request parameter '" + key + "' and value '" + v + "'", (Throwable)e);
                }
            }
        }
        return url.toString();
    }

    private String _getRelativePath(String url) {
        int beginIndex = url.length() != 0 && url.charAt(0) == '/' ? 1 : 0;
        int endIndex = url.indexOf("?");
        return endIndex == -1 ? url.substring(beginIndex) : url.substring(beginIndex, endIndex);
    }

    private StringBuilder _buildQueryParameter(String key, Object value) {
        StringBuilder queryParameter = new StringBuilder();
        queryParameter.append(key);
        queryParameter.append("=");
        queryParameter.append(String.valueOf(value).replaceAll("%", "%25").replaceAll("=", "%3D").replaceAll("&", "%26").replaceAll("\\+", "%2B"));
        queryParameter.append("&");
        return queryParameter;
    }

    protected String _getUrlPrefix(String pluginOrWorkspace) {
        StringBuffer url = new StringBuffer("cocoon://");
        if (pluginOrWorkspace != null && !pluginOrWorkspace.startsWith("_")) {
            url.append("_plugins/");
            url.append(pluginOrWorkspace);
            url.append("/");
        } else if (pluginOrWorkspace != null) {
            url.append(pluginOrWorkspace);
            url.append("/");
        }
        return url.toString();
    }

    public static class ResponseHandler
    extends IgnoreRootHandler {
        private final String _parameterKey;
        private final ContentHandler _handler;
        private final String _code;
        private final List<String> _startedElements;

        public ResponseHandler(ContentHandler handler, String parameterKey, String code) {
            super(handler);
            this._handler = handler;
            this._parameterKey = parameterKey;
            this._code = code;
            this._startedElements = new ArrayList<String>();
        }

        public void exceptionFinish() throws SAXException {
            while (this._startedElements.size() > 0) {
                XMLUtils.endElement((ContentHandler)this._handler, (String)this._startedElements.get(this._startedElements.size() - 1));
                this._startedElements.remove(this._startedElements.size() - 1);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", this._parameterKey);
            attrs.addCDATAAttribute("code", this._code);
            XMLUtils.startElement((ContentHandler)this._handler, (String)"response", (Attributes)attrs);
            this._startedElements.add("response");
        }

        public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
            super.startElement(uri, loc, raw, a);
            this._startedElements.add(loc);
        }

        public void endElement(String uri, String loc, String raw) throws SAXException {
            super.endElement(uri, loc, raw);
            if (!StringUtils.equals((String)this._startedElements.get(this._startedElements.size() - 1), (String)loc)) {
                throw new SAXException("Sax events are not consistents. Cannot close <" + loc + "> while it should be <" + this._startedElements.get(this._startedElements.size() - 1) + ">");
            }
            this._startedElements.remove(this._startedElements.size() - 1);
        }

        @Override
        public void endDocument() throws SAXException {
            XMLUtils.endElement((ContentHandler)this._handler, (String)"response");
            if (this._startedElements.size() != 1) {
                throw new SAXException("Sax events are not consistents. Remaining " + this._startedElements.size() + " events (should be one).");
            }
            this._startedElements.remove(this._startedElements.size() - 1);
            super.endDocument();
        }
    }
}

