/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.util.ArrayList;
import java.util.List;
import org.ametys.core.ui.RibbonConfigurationManager;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.ribbonconfiguration.ControlRef;
import org.ametys.core.ui.ribbonconfiguration.Element;
import org.ametys.core.ui.ribbonconfiguration.Toolbar;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Layout
implements Element {
    protected RibbonConfigurationManager.LAYOUTALIGN _layoutAlign;
    protected RibbonConfigurationManager.CONTROLSIZE _size;
    protected int _cols;
    protected List<Element> _elements = new ArrayList<Element>();
    protected Logger _layoutLogger;

    public Layout(Configuration layoutConfiguration, RibbonManager ribbonManager, Logger logger) throws ConfigurationException {
        this(layoutConfiguration.getAttributeAsInteger("cols", 1), RibbonConfigurationManager.CONTROLSIZE.createsFromString(layoutConfiguration.getAttribute("size", null)), RibbonConfigurationManager.LAYOUTALIGN.createsFromString(layoutConfiguration.getAttribute("align", null)), logger);
        Configuration[] elementsConfigurations;
        for (Configuration elementConfiguration : elementsConfigurations = layoutConfiguration.getChildren()) {
            if ("control".equals(elementConfiguration.getName())) {
                ControlRef control = new ControlRef(elementConfiguration, ribbonManager, this._layoutLogger);
                this._elements.add(control);
                continue;
            }
            if ("toolbar".equals(elementConfiguration.getName())) {
                Toolbar toolbar = new Toolbar(elementConfiguration, ribbonManager, this._layoutLogger);
                this._elements.add(toolbar);
                continue;
            }
            if (!this._layoutLogger.isWarnEnabled()) continue;
            this._layoutLogger.warn("During configuration of the ribbon, the layout use an unknow tag '" + elementConfiguration.getName() + "'");
        }
    }

    public Layout(Layout layout, RibbonConfigurationManager.CONTROLSIZE size) {
        this(layout._cols, size, layout._layoutAlign, layout._layoutLogger);
    }

    public Layout(int cols, RibbonConfigurationManager.CONTROLSIZE size, RibbonConfigurationManager.LAYOUTALIGN align, Logger logger) {
        this._layoutLogger = logger;
        this._cols = cols;
        if (this._layoutLogger.isDebugEnabled()) {
            this._layoutLogger.debug("Control colspan is " + this._cols);
        }
        this._layoutAlign = align;
        if (this._layoutLogger.isDebugEnabled()) {
            this._layoutLogger.debug("Control align is " + (Object)((Object)this._layoutAlign));
        }
        this._size = size;
        if (this._layoutLogger.isDebugEnabled()) {
            this._layoutLogger.debug("Control size is " + (Object)((Object)this._size));
        }
    }

    public RibbonConfigurationManager.CONTROLSIZE getSize() {
        return this._size;
    }

    public RibbonConfigurationManager.LAYOUTALIGN getAlign() {
        return this._layoutAlign;
    }

    @Override
    public int getColumns() {
        return this._cols;
    }

    @Override
    public void setColumns(int cols) {
        this._cols = cols;
    }

    @Override
    public List<Element> getChildren() {
        return this._elements;
    }

    @Override
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        if (this._layoutAlign != null) {
            attrs.addCDATAAttribute("align", this._layoutAlign.toString());
        }
        if (this._size != null) {
            attrs.addCDATAAttribute("size", this._size.toString());
        }
        attrs.addCDATAAttribute("cols", Integer.toString(this._cols));
        XMLUtils.startElement((ContentHandler)handler, (String)"layout", (Attributes)attrs);
        for (Element element : this._elements) {
            element.toSAX(handler);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"layout");
    }

    @Override
    public boolean isSame(Element element) {
        if (!(element instanceof Layout)) {
            return false;
        }
        Layout layout = (Layout)element;
        if (layout._cols != this._cols || layout._layoutAlign != this._layoutAlign || layout._size != this._size) {
            return false;
        }
        List<Element> layoutElements = layout.getChildren();
        if (layoutElements.size() != this._elements.size()) {
            return false;
        }
        for (int i = 0; i < this._elements.size(); ++i) {
            Element child = this._elements.get(i);
            Element objElement = layoutElements.get(i);
            if (child != null && objElement != null && child.isSame(objElement)) continue;
            return false;
        }
        return true;
    }
}

