/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.ui.ribbonconfiguration;

import java.util.ArrayList;
import java.util.List;
import org.ametys.core.ui.RibbonManager;
import org.ametys.core.ui.ribbonconfiguration.ControlRef;
import org.ametys.core.ui.ribbonconfiguration.Element;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Toolbar
implements Element {
    protected int _colspan;
    protected List<Element> _elements = new ArrayList<Element>();
    protected Logger _toolbarLogger;

    public Toolbar(Configuration toolbarConfiguration, RibbonManager ribbonManager, Logger logger) throws ConfigurationException {
        this(logger, toolbarConfiguration.getAttributeAsInteger("colspan", 1));
        Configuration[] elementsConfigurations;
        for (Configuration elementConfiguration : elementsConfigurations = toolbarConfiguration.getChildren()) {
            if ("control".equals(elementConfiguration.getName())) {
                ControlRef control = new ControlRef(elementConfiguration, ribbonManager, this._toolbarLogger);
                this._elements.add(control);
                continue;
            }
            if (!this._toolbarLogger.isWarnEnabled()) continue;
            this._toolbarLogger.warn("During configuration of the ribbon, the toolbar use an unknow tag '" + elementConfiguration.getName() + "'");
        }
    }

    public Toolbar(Logger logger, int colspan) {
        this._toolbarLogger = logger;
        this._colspan = colspan;
        if (this._toolbarLogger.isDebugEnabled()) {
            this._toolbarLogger.debug("Control colspan is " + this._colspan);
        }
    }

    @Override
    public int getColumns() {
        return this._colspan;
    }

    @Override
    public void setColumns(int size) {
        this._colspan = size;
    }

    @Override
    public List<Element> getChildren() {
        return this._elements;
    }

    @Override
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("colspan", Integer.toString(this._colspan));
        XMLUtils.startElement((ContentHandler)handler, (String)"toolbar", (Attributes)attrs);
        for (Element element : this._elements) {
            element.toSAX(handler);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"toolbar");
    }

    @Override
    public boolean isSame(Element element) {
        if (!(element instanceof Toolbar)) {
            return false;
        }
        Toolbar toolbar = (Toolbar)element;
        if (toolbar._colspan != this._colspan) {
            return false;
        }
        if (toolbar.getChildren().size() != this._elements.size()) {
            return false;
        }
        for (int i = 0; i < this._elements.size(); ++i) {
            Element child = this._elements.get(i);
            Element objElement = toolbar.getChildren().get(i);
            if (child != null && objElement != null && child.isSame(objElement)) continue;
            return false;
        }
        return true;
    }
}

