/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.user;

import java.security.Principal;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.UserDirectory;
import org.apache.commons.lang3.StringUtils;

public class User
implements Principal {
    protected UserIdentity _identity;
    protected String _lastName;
    protected String _firstName;
    protected String _email;
    protected UserDirectory _userDirectory;

    public User(String login, String populationId) {
        this(new UserIdentity(login, populationId));
    }

    public User(UserIdentity identity) {
        this(identity, null, null, null, null);
    }

    public User(UserIdentity identity, String lastName, String firstName, String email, UserDirectory userDirectory) {
        this._identity = identity;
        this._lastName = StringUtils.defaultString((String)lastName);
        this._firstName = StringUtils.defaultString((String)firstName);
        this._email = StringUtils.defaultString((String)email);
        this._userDirectory = userDirectory;
    }

    public UserIdentity getIdentity() {
        return this._identity;
    }

    @Override
    public String getName() {
        return UserIdentity.userIdentityToString(this._identity);
    }

    public String getLastName() {
        return this._lastName;
    }

    public String getFirstName() {
        return this._firstName;
    }

    public String getEmail() {
        return this._email;
    }

    public String getFullName() {
        return this._getFullName(true);
    }

    public String getSortableName() {
        return this._getFullName(false);
    }

    public UserDirectory getUserDirectory() {
        return this._userDirectory;
    }

    protected String _getFullName(boolean firstLast) {
        StringBuilder sb = new StringBuilder();
        if (firstLast && StringUtils.isNotEmpty((CharSequence)this._firstName)) {
            sb.append(this._firstName);
            if (StringUtils.isNotEmpty((CharSequence)this._lastName)) {
                sb.append(' ');
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)this._lastName)) {
            sb.append(this._lastName);
        }
        if (!firstLast && StringUtils.isNotEmpty((CharSequence)this._firstName)) {
            if (StringUtils.isNotEmpty((CharSequence)this._lastName)) {
                sb.append(' ');
            }
            sb.append(this._firstName);
        }
        return (String)StringUtils.defaultIfEmpty((CharSequence)sb.toString(), (CharSequence)this._identity.getLogin());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Principal[");
        sb.append(this._identity.toString());
        sb.append(" : ");
        sb.append(this.getFullName());
        sb.append(", ");
        sb.append(this._email);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object another) {
        if (another == null || !(another instanceof User)) {
            return false;
        }
        User otherUser = (User)another;
        return this._identity != null && this._identity.equals(otherUser.getIdentity());
    }

    @Override
    public int hashCode() {
        return this._identity.hashCode();
    }
}

