/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.userpref;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.Errors;
import org.apache.commons.lang.StringUtils;

public class UserPreferencesErrors {
    protected Map<String, Errors> _errors;

    public UserPreferencesErrors() {
        this(new LinkedHashMap<String, Errors>());
    }

    public UserPreferencesErrors(Map<String, Errors> errors) {
        this._errors = errors;
    }

    public Map<String, Errors> getErrors() {
        return Collections.unmodifiableMap(this._errors);
    }

    public Errors getErrors(String fieldId) {
        Errors fieldErrors;
        if (this._errors.containsKey(fieldId)) {
            fieldErrors = this._errors.get(fieldId);
        } else {
            fieldErrors = new Errors();
            this._errors.put(fieldId, fieldErrors);
        }
        return fieldErrors;
    }

    public void setErrors(Map<String, Errors> errors) {
        this._errors = errors;
    }

    public void addError(String fieldId, I18nizableText error) {
        if (StringUtils.isNotEmpty((String)fieldId) && error != null) {
            this.getErrors(fieldId).addError(error);
        }
    }

    public void addErrors(String fieldId, List<I18nizableText> errors) {
        if (StringUtils.isNotEmpty((String)fieldId) && !errors.isEmpty()) {
            Errors fieldErrors = this.getErrors(fieldId);
            for (I18nizableText errorLabel : errors) {
                fieldErrors.addError(errorLabel);
            }
        }
    }

    public boolean hasErrors() {
        return !this._errors.isEmpty();
    }
}

