/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.userpref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreference;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesExtensionPoint;
import org.ametys.core.userpref.UserPreferencesStorage;
import org.ametys.runtime.parameter.ParameterHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.lang.StringUtils;

public class UserPreferencesManager
extends AbstractLogEnabled
implements ThreadSafe,
Component,
Serviceable,
Configurable,
Initializable {
    public static final String ROLE = UserPreferencesManager.class.getName();
    protected UserPreferencesExtensionPoint _userPrefEP;
    protected Map<String, UserPreferencesStorage> _storageManagers;
    protected String _defaultStorageRole;
    protected ServiceManager _serviceManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._serviceManager = manager;
        this._userPrefEP = (UserPreferencesExtensionPoint)manager.lookup(UserPreferencesExtensionPoint.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._defaultStorageRole = configuration.getChild("default-storage-role").getValue();
    }

    public void initialize() throws Exception {
        this._storageManagers = new HashMap<String, UserPreferencesStorage>();
    }

    public Map<String, String> getUnTypedUserPrefs(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        HashMap<String, String> preferences = new HashMap<String, String>();
        Set<String> storageRoles = this.getStorageRoles(contextVars);
        for (String storageRole : storageRoles) {
            UserPreferencesStorage storageManager = this.getStorageManager(storageRole);
            preferences.putAll(storageManager.getUnTypedUserPrefs(user, storageContext, contextVars));
        }
        return preferences;
    }

    public Map<String, Object> getTypedUserPrefs(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Map<String, String> unTypedUserPrefs = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        return this._castValues(unTypedUserPrefs, contextVars);
    }

    public void addUserPreference(UserIdentity user, String storageContext, Map<String, String> contextVars, String name, String value) throws UserPreferencesException {
        Map<String, String> userPrefs = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        userPrefs.put(name, value);
        this.setUserPreferences(user, storageContext, contextVars, userPrefs);
    }

    public void addUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars, Map<String, String> values) throws UserPreferencesException {
        Map<String, String> userPrefs = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        userPrefs.putAll(values);
        this.setUserPreferences(user, storageContext, contextVars, userPrefs);
    }

    public void removeUserPreference(UserIdentity user, String storageContext, Map<String, String> contextVars, String name) throws UserPreferencesException {
        Map<String, String> userPrefs = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (userPrefs.containsKey(name)) {
            userPrefs.remove(name);
        }
        this.setUserPreferences(user, storageContext, contextVars, userPrefs);
    }

    public void removeAllUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Set<String> storageRoles = this.getStorageRoles(contextVars);
        for (String storageRole : storageRoles) {
            UserPreferencesStorage storageManager = this.getStorageManager(storageRole);
            storageManager.removeUserPreferences(user, storageContext, contextVars);
        }
    }

    public void setUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars, Map<String, String> preferenceValues) throws UserPreferencesException {
        Map<String, Map<String, String>> preferenceValuesByStorage = this.getUserPrefsValuesByStorage(contextVars, preferenceValues);
        for (String managerRole : preferenceValuesByStorage.keySet()) {
            Map<String, String> storagePrefValues = preferenceValuesByStorage.get(managerRole);
            UserPreferencesStorage storageManager = this.getStorageManager(managerRole);
            storageManager.setUserPreferences(user, storageContext, contextVars, storagePrefValues);
        }
    }

    public String getUserPreferenceAsString(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        UserPreferencesStorage storageManager = this.getStorageManager(contextVars, id);
        return storageManager.getUserPreferenceAsString(user, storageContext, contextVars, id);
    }

    public Long getUserPreferenceAsLong(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        UserPreferencesStorage storageManager = this.getStorageManager(contextVars, id);
        return storageManager.getUserPreferenceAsLong(user, storageContext, contextVars, id);
    }

    public Date getUserPreferenceAsDate(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        UserPreferencesStorage storageManager = this.getStorageManager(contextVars, id);
        return storageManager.getUserPreferenceAsDate(user, storageContext, contextVars, id);
    }

    public Boolean getUserPreferenceAsBoolean(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        UserPreferencesStorage storageManager = this.getStorageManager(contextVars, id);
        return storageManager.getUserPreferenceAsBoolean(user, storageContext, contextVars, id);
    }

    public Double getUserPreferenceAsDouble(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        UserPreferencesStorage storageManager = this.getStorageManager(contextVars, id);
        return storageManager.getUserPreferenceAsDouble(user, storageContext, contextVars, id);
    }

    protected Set<String> getStorageRoles(Map<String, String> contextVars) {
        HashSet<String> storageRoles = new HashSet<String>();
        storageRoles.add(this._defaultStorageRole);
        for (UserPreference preference : this._userPrefEP.getUserPreferences(contextVars).values()) {
            String role = StringUtils.defaultIfEmpty((String)preference.getManagerRole(), (String)this._defaultStorageRole);
            storageRoles.add(role);
        }
        return storageRoles;
    }

    protected Map<String, Collection<UserPreference>> getUserPrefsByStorage(Map<String, String> contextVars) {
        HashMap<String, Collection<UserPreference>> userPrefs = new HashMap<String, Collection<UserPreference>>();
        for (UserPreference preference : this._userPrefEP.getUserPreferences(contextVars).values()) {
            String role = StringUtils.defaultIfEmpty((String)preference.getManagerRole(), (String)this._defaultStorageRole);
            ArrayList<UserPreference> rolePrefs = (ArrayList<UserPreference>)userPrefs.get(role);
            if (rolePrefs == null) {
                rolePrefs = new ArrayList<UserPreference>();
                userPrefs.put(role, rolePrefs);
            }
            rolePrefs.add(preference);
        }
        return userPrefs;
    }

    protected Map<String, Map<String, String>> getUserPrefsValuesByStorage(Map<String, String> contextVars, Map<String, String> preferenceValues) {
        HashMap<String, Map<String, String>> preferenceValuesByStorage = new HashMap<String, Map<String, String>>();
        for (String storageRole : this.getStorageRoles(contextVars)) {
            preferenceValuesByStorage.put(storageRole, new HashMap());
        }
        Map<String, Collection<UserPreference>> userPrefsByStorage = this.getUserPrefsByStorage(contextVars);
        HashMap<String, String> unknownPreferenceValues = new HashMap<String, String>(preferenceValues);
        for (String storageRole : userPrefsByStorage.keySet()) {
            Map storagePrefValues = (Map)preferenceValuesByStorage.get(storageRole);
            Collection<UserPreference> storageUserPrefs = userPrefsByStorage.get(storageRole);
            for (UserPreference pref : storageUserPrefs) {
                String prefId = pref.getId();
                if (!preferenceValues.containsKey(prefId)) continue;
                storagePrefValues.put(prefId, preferenceValues.get(prefId));
                unknownPreferenceValues.remove(prefId);
            }
        }
        ((Map)preferenceValuesByStorage.get(this._defaultStorageRole)).putAll(unknownPreferenceValues);
        return preferenceValuesByStorage;
    }

    protected UserPreferencesStorage getStorageManager(String role) throws UserPreferencesException {
        UserPreferencesStorage storageManager = null;
        String componentRole = role;
        if (this._storageManagers.containsKey(componentRole)) {
            storageManager = this._storageManagers.get(componentRole);
        } else {
            try {
                storageManager = (UserPreferencesStorage)this._serviceManager.lookup(componentRole);
                this._storageManagers.put(componentRole, storageManager);
            }
            catch (ServiceException e) {
                throw new UserPreferencesException("Error looking up the user preference storage component of role " + componentRole, e);
            }
        }
        return storageManager;
    }

    protected UserPreferencesStorage getStorageManager(Map<String, String> contextVars, String id) throws UserPreferencesException {
        String storageManagerRole = this._defaultStorageRole;
        UserPreference preference = this._userPrefEP.getUserPreference(contextVars, id);
        if (preference != null && StringUtils.isNotEmpty((String)preference.getManagerRole())) {
            storageManagerRole = preference.getManagerRole();
        }
        return this.getStorageManager(storageManagerRole);
    }

    protected Map<String, Object> _castValues(Map<String, String> untypedValues, Map<String, String> contextVars) {
        HashMap<String, Object> typedValues = new HashMap<String, Object>(untypedValues.size());
        for (Map.Entry<String, String> entry : untypedValues.entrySet()) {
            UserPreference userPref = this._userPrefEP.getUserPreference(contextVars, entry.getKey());
            if (userPref != null) {
                Object value = ParameterHelper.castValue(entry.getValue(), (ParameterHelper.ParameterType)((Object)userPref.getType()));
                typedValues.put(userPref.getId(), value);
                continue;
            }
            typedValues.put(entry.getKey(), entry.getValue());
        }
        return typedValues;
    }
}

