/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.filereloader;

import java.io.InputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.util.filereloader.FileReloader;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;

public class FileReloaderUtils
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = FileReloaderUtils.class.getName();
    protected SourceResolver _resolver;
    private Map<String, FileMetadatas> _files;

    public void initialize() throws Exception {
        this._files = new HashMap<String, FileMetadatas>();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void updateFile(String sourceUrl, FileReloader fileReloader) throws Exception {
        this.updateFile(sourceUrl, null, fileReloader);
    }

    public void updateFile(String sourceUrl, boolean forceRead, FileReloader fileReloader) throws Exception {
        this.updateFile(sourceUrl, null, forceRead, fileReloader);
    }

    public void updateFile(String sourceUrl, Map parameters, FileReloader fileReloader) throws Exception {
        this.updateFile(sourceUrl, parameters, false, fileReloader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFile(String sourceUrl, Map parameters, boolean forceRead, FileReloader fileReloader) throws Exception {
        FileMetadatas fileMetadatas;
        String id = fileReloader.getId(sourceUrl);
        if (!this._files.containsKey(id)) {
            this._files.put(id, new FileMetadatas(sourceUrl, parameters));
        }
        FileMetadatas fileMetadatas2 = fileMetadatas = this._files.get(id);
        synchronized (fileMetadatas2) {
            Source source;
            block22: {
                source = null;
                try {
                    source = this._resolver.resolveURI(fileMetadatas.getSourceUrl(), null, fileMetadatas.getParameters());
                    if (!source.exists()) {
                        throw new SourceNotFoundException("Source '" + fileMetadatas.getSourceUrl() + "' not found");
                    }
                    long sourceLastModified = source.getLastModified() / 1000L * 1000L;
                    if (!forceRead && sourceLastModified < fileMetadatas.getLastFileReading()) break block22;
                    this.getLogger().debug("Reading configuration file at {}", (Object)fileMetadatas.getSourceUrl());
                    long lastFileReading = Instant.now().truncatedTo(ChronoUnit.SECONDS).toEpochMilli();
                    try (InputStream is = source.getInputStream();){
                        fileReloader.updateFile(fileMetadatas.getSourceUrl(), is);
                        fileMetadatas.setLastFileReading(lastFileReading);
                        this.getLogger().debug("Configuration file read. at {}", (Object)fileMetadatas.getSourceUrl());
                    }
                }
                catch (SourceNotFoundException e) {
                    try {
                        if (forceRead || fileMetadatas.getLastFileReading() < 0L) {
                            fileReloader.updateFile(fileMetadatas.getSourceUrl(), null);
                        }
                        fileMetadatas.setLastFileReading(0L);
                    }
                    catch (Throwable throwable) {
                        this._resolver.release(source);
                        throw throwable;
                    }
                    this._resolver.release(source);
                }
            }
            this._resolver.release(source);
        }
    }

    private static class FileMetadatas {
        private long _lastFileReading;
        private String _sourceUrl;
        private Map _parameters;

        public FileMetadatas(String sourceUrl, Map parameters) {
            this._sourceUrl = sourceUrl;
            this._lastFileReading = -1L;
            this._parameters = parameters;
        }

        public long getLastFileReading() {
            return this._lastFileReading;
        }

        public void setLastFileReading(long lastFileReading) {
            this._lastFileReading = lastFileReading;
        }

        public String getSourceUrl() {
            return this._sourceUrl;
        }

        public Map getParameters() {
            return this._parameters;
        }
    }
}

