/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.util.mail;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.jsoup.select.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SendMailHelper
extends AbstractLogEnabled
implements Disposable {
    protected static final Logger _LOGGER = LoggerFactory.getLogger(SendMailHelper.class);
    protected static final Pattern __CSS_SPECIFICITY_ATTR_PATTERN = Pattern.compile("(\\[[^\\]]+\\])");
    protected static final Pattern __CSS_SPECIFICITY_ID_PATTERN = Pattern.compile("(#[^\\s\\+>~\\.\\[:]+)");
    protected static final Pattern __CSS_SPECIFICITY_CLASS_PATTERN = Pattern.compile("(\\.[^\\s\\+>~\\.\\[:]+)");
    protected static final Pattern __CSS_SPECIFICITY_PSEUDO_ELEMENT_PATTERN = Pattern.compile("(::[^\\s\\+>~\\.\\[:]+|:first-line|:first-letter|:before|:after)", 2);
    protected static final Pattern __CSS_SPECIFICITY_PSEUDO_CLASS_WITH_BRACKETS_PATTERN = Pattern.compile("(:[\\w-]+\\([^\\)]*\\))", 2);
    protected static final Pattern __CSS_SPECIFICITY_PSEUDO_CLASS_PATTERN = Pattern.compile("(:[^\\s\\+>~\\.\\[:]+)");
    protected static final Pattern __CSS_SPECIFICITY_ELEMENT_PATTERN = Pattern.compile("([^\\s\\+>~\\.\\[:]+)");
    protected static final Pattern __CSS_SPECIFICITY_PSEUDO_CLASS_NOT_PATTERN = Pattern.compile(":not\\(([^\\)]*)\\)");
    protected static final Pattern __CSS_SPECIFICITY_UNIVERSAL_AND_SEPARATOR_PATTERN = Pattern.compile("[\\*\\s\\+>~]");
    private static final ExecutorService __SINGLE_THREAD_EXECUTOR = Executors.newSingleThreadExecutor(new MailSenderThreadFactory());

    private SendMailHelper() {
    }

    public static void sendMail(String subject, String htmlBody, String textBody, String recipient, String sender) throws MessagingException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, Collections.singletonList(recipient), sender);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, List<String> recipients, String sender) throws MessagingException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, recipients, sender, false);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, String recipient, String sender, boolean async) throws MessagingException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, Collections.singletonList(recipient), sender, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, List<String> recipients, String sender, boolean async) throws MessagingException {
        Config config = Config.getInstance();
        String smtpHost = (String)config.getValue("smtp.mail.host");
        long smtpPort = (Long)config.getValue("smtp.mail.port");
        String securityProtocol = (String)config.getValue("smtp.mail.security.protocol");
        SendMailHelper.sendMail(subject, htmlBody, textBody, recipients, sender, smtpHost, smtpPort, securityProtocol, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, String recipient, String sender, String host, long port, String securityProtocol, boolean async) throws MessagingException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, Collections.singletonList(recipient), sender, host, port, securityProtocol, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, List<String> recipients, String sender, String host, long port, String securityProtocol, boolean async) throws MessagingException {
        Config config = Config.getInstance();
        String user = (String)config.getValue("smtp.mail.user");
        String password = (String)config.getValue("smtp.mail.password");
        SendMailHelper.sendMail(subject, htmlBody, textBody, recipients, sender, host, port, securityProtocol, user, password, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, String recipient, String sender, String host, long port, String securityProtocol, String user, String password, boolean async) throws MessagingException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, Collections.singletonList(recipient), sender, host, port, securityProtocol, user, password, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, List<String> recipients, String sender, String host, long port, String securityProtocol, String user, String password, boolean async) throws MessagingException {
        try {
            String sp = (String)StringUtils.defaultIfEmpty((CharSequence)securityProtocol, (CharSequence)((CharSequence)Config.getInstance().getValue("smtp.mail.security.protocol")));
            SendMailHelper.sendMail(subject, htmlBody, textBody, null, recipients, sender, null, null, false, false, host, port, sp, user, password, async);
        }
        catch (IOException e) {
            _LOGGER.error("Cannot send mail " + subject + " to " + recipients, (Throwable)e);
        }
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, String recipient, String sender) throws MessagingException, IOException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, Collections.singletonList(recipient), sender);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, List<String> recipients, String sender) throws MessagingException, IOException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, recipients, sender, null, null, false);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, String recipient, String sender, List<String> cc, List<String> bcc, boolean async) throws MessagingException, IOException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, Collections.singletonList(recipient), sender, cc, bcc, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, List<String> recipients, String sender, List<String> cc, List<String> bcc, boolean async) throws MessagingException, IOException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, recipients, sender, cc, bcc, false, false, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, String recipient, String sender, List<String> cc, List<String> bcc, boolean deliveryReceipt, boolean readReceipt, boolean async) throws MessagingException, IOException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, Collections.singletonList(recipient), sender, cc, bcc, deliveryReceipt, readReceipt, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, List<String> recipients, String sender, List<String> cc, List<String> bcc, boolean deliveryReceipt, boolean readReceipt, boolean async) throws MessagingException, IOException {
        Config config = Config.getInstance();
        String smtpHost = (String)config.getValue("smtp.mail.host");
        long smtpPort = (Long)config.getValue("smtp.mail.port");
        String protocol = (String)config.getValue("smtp.mail.security.protocol");
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, recipients, sender, cc, bcc, deliveryReceipt, readReceipt, smtpHost, smtpPort, protocol, null, null, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, String recipient, String sender, List<String> cc, List<String> bcc, boolean deliveryReceipt, boolean readReceipt, String host, long port, String securityProtocol, boolean async) throws MessagingException, IOException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, Collections.singletonList(recipient), sender, cc, bcc, deliveryReceipt, readReceipt, host, port, securityProtocol, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, List<String> recipients, String sender, List<String> cc, List<String> bcc, boolean deliveryReceipt, boolean readReceipt, String host, long port, String securityProtocol, boolean async) throws MessagingException, IOException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, recipients, sender, cc, bcc, deliveryReceipt, readReceipt, host, port, securityProtocol, null, null, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, String recipient, String sender, List<String> cc, List<String> bcc, boolean deliveryReceipt, boolean readReceipt, String host, long port, String securityProtocol, String user, String password, boolean async) throws MessagingException, IOException {
        SendMailHelper.sendMail(subject, htmlBody, textBody, attachments, Collections.singletonList(recipient), sender, cc, bcc, deliveryReceipt, readReceipt, host, port, securityProtocol, user, password, async);
    }

    public static void sendMail(String subject, String htmlBody, String textBody, Collection<File> attachments, List<String> recipients, String sender, List<String> cc, List<String> bcc, boolean deliveryReceipt, boolean readReceipt, String host, long port, String securityProtocol, String user, String password, boolean async) throws MessagingException, IOException {
        MailSender mailSender = new MailSender(_LOGGER, subject, htmlBody, textBody, attachments, recipients, sender, cc, bcc, deliveryReceipt, readReceipt, host, port, securityProtocol, user, password);
        if (!async) {
            mailSender.sendMail();
        } else {
            __SINGLE_THREAD_EXECUTOR.execute(mailSender);
        }
    }

    public static String inlineCSS(String html) {
        LinkedList<CssRule> rules = new LinkedList<CssRule>();
        Document doc = Jsoup.parse((String)html);
        Elements els = doc.select("style");
        for (Element e : els) {
            String styleRules = ((Element)e.getAllElements().get(0)).data();
            styleRules = styleRules.replaceAll("\t|\n", "").replaceAll("<!--", "").replaceAll("-->", "");
            styleRules = SendMailHelper._removeComments(styleRules);
            styleRules = styleRules.trim();
            StringTokenizer st = new StringTokenizer(styleRules, "{}");
            while (st.countTokens() > 1) {
                String[] selector;
                String selectors = st.nextToken();
                String properties = st.nextToken();
                for (String s : selector = selectors.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    rules.add(new CssRule(s, properties, rules.size()));
                }
            }
            e.remove();
        }
        Collections.sort(rules, Collections.reverseOrder());
        for (CssRule rule : rules) {
            try {
                Elements selectedElements = doc.select(rule.getSelector());
                Iterator iterator = selectedElements.iterator();
                while (iterator.hasNext()) {
                    Element selElem;
                    String oldProperties = (selElem = (Element)iterator.next()).attr("style");
                    selElem.attr("style", oldProperties.length() > 0 ? SendMailHelper.concatenateProperties(oldProperties, rule.getProperties()) : rule.getProperties());
                }
            }
            catch (Selector.SelectorParseException ex) {
                _LOGGER.error("Cannot inline CSS. Ignoring this rule and continuing.", (Throwable)ex);
            }
        }
        return doc.toString();
    }

    private static String _removeComments(String styleRules) {
        int i = styleRules.indexOf("/*");
        int j = styleRules.indexOf("*/");
        if (i >= 0 && j > i) {
            return styleRules.substring(0, i) + SendMailHelper._removeComments(styleRules.substring(j + 2));
        }
        return styleRules;
    }

    private static String concatenateProperties(String oldProp, String newProp) {
        String between = "";
        if (!newProp.endsWith(";")) {
            between = between + ";";
        }
        return newProp + between + oldProp.trim();
    }

    public void dispose() {
        __SINGLE_THREAD_EXECUTOR.shutdownNow();
    }

    private static class MailSenderThreadFactory
    implements ThreadFactory {
        private ThreadFactory _defaultThreadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this._defaultThreadFactory.newThread(r);
            thread.setName("mail-sender-thread");
            thread.setDaemon(true);
            return thread;
        }
    }

    private static class MailSender
    implements Runnable {
        private String _subject;
        private String _htmlBody;
        private String _textBody;
        private Collection<File> _attachments;
        private List<String> _recipients;
        private String _sender;
        private List<String> _cc;
        private List<String> _bcc;
        private boolean _deliveryReceipt;
        private boolean _readReceipt;
        private String _host;
        private long _port;
        private String _securityProtocol;
        private String _user;
        private String _password;
        private Logger _logger;

        public MailSender(Logger logger, String subject, String htmlBody, String textBody, Collection<File> attachments, List<String> recipients, String sender, List<String> cc, List<String> bcc, boolean deliveryReceipt, boolean readReceipt, String host, long port, String securityProtocol, String user, String password) {
            this._logger = logger;
            this._subject = subject;
            this._htmlBody = htmlBody;
            this._textBody = textBody;
            this._attachments = attachments;
            this._recipients = recipients;
            this._sender = sender;
            this._cc = cc;
            this._bcc = bcc;
            this._deliveryReceipt = deliveryReceipt;
            this._readReceipt = readReceipt;
            this._host = host;
            this._port = port;
            this._securityProtocol = securityProtocol;
            this._user = user;
            this._password = password;
        }

        @Override
        public void run() {
            try {
                this.sendMail();
            }
            catch (Exception e) {
                this._logger.error("Unable to send mail: " + this._subject + "", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMail() throws MessagingException, IOException {
            Properties props = new Properties();
            props.put("mail.smtp.host", this._host);
            props.put("mail.smtp.port", (Object)this._port);
            if (this._securityProtocol.equals("starttls")) {
                props.put("mail.smtp.starttls.enable", "true");
            } else if (this._securityProtocol.equals("tlsssl")) {
                props.put("mail.smtp.ssl.enable", "true");
            }
            Session session = Session.getInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(session);
            if (this._sender != null) {
                message.setFrom((Address)new InternetAddress(this._sender));
            }
            message.setSentDate(new Date());
            message.setSubject(this._subject);
            MimeMultipart multipart = new MimeMultipart("mixed");
            MimeMultipart messageMultipart = new MimeMultipart("alternative");
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setContent((Multipart)messageMultipart);
            multipart.addBodyPart((BodyPart)messagePart);
            if (this._textBody != null) {
                MimeBodyPart textBodyPart = new MimeBodyPart();
                textBodyPart.setContent((Object)this._textBody, "text/plain;charset=utf-8");
                textBodyPart.addHeader("Content-Type", "text/plain;charset=utf-8");
                messageMultipart.addBodyPart((BodyPart)textBodyPart);
            }
            if (this._htmlBody != null) {
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                htmlBodyPart.setContent((Object)SendMailHelper.inlineCSS(this._htmlBody), "text/html;charset=utf-8");
                htmlBodyPart.addHeader("Content-Type", "text/html;charset=utf-8");
                messageMultipart.addBodyPart((BodyPart)htmlBodyPart);
            }
            if (this._attachments != null) {
                for (File attachment : this._attachments) {
                    MimeBodyPart fileBodyPart = new MimeBodyPart();
                    fileBodyPart.attachFile(attachment);
                    multipart.addBodyPart((BodyPart)fileBodyPart);
                }
            }
            message.setContent((Multipart)multipart);
            if (this._recipients != null) {
                message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)StringUtils.join(this._recipients, (char)','), (boolean)false));
            }
            if (this._cc != null) {
                message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)StringUtils.join(this._cc, (char)','), (boolean)false));
            }
            if (this._bcc != null) {
                message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)StringUtils.join(this._bcc, (char)','), (boolean)false));
            }
            if (this._deliveryReceipt) {
                message.setHeader("Return-Receipt-To", this._sender);
            }
            if (this._readReceipt) {
                message.setHeader("Disposition-Notification-To", this._sender);
            }
            message.saveChanges();
            try (Transport tr = session.getTransport("smtp");){
                tr.connect(this._host, (int)this._port, StringUtils.trimToNull((String)this._user), StringUtils.trimToNull((String)this._password));
                if (this._recipients != null && this._recipients.size() > 0 && this._sender != null) {
                    tr.sendMessage((Message)message, message.getAllRecipients());
                }
            }
        }
    }

    private static class CssSpecificity
    implements Comparable<CssSpecificity> {
        private int[] _weights;

        public CssSpecificity(String selector, int positionIdx) {
            this._weights = new int[]{0, 0, 0, 0, positionIdx};
            String input = selector;
            input = __CSS_SPECIFICITY_PSEUDO_CLASS_NOT_PATTERN.matcher(input).replaceAll(" $1 ");
            input = this._countReplaceAll(__CSS_SPECIFICITY_ATTR_PATTERN, input, 2);
            input = this._countReplaceAll(__CSS_SPECIFICITY_ID_PATTERN, input, 1);
            input = this._countReplaceAll(__CSS_SPECIFICITY_CLASS_PATTERN, input, 2);
            input = this._countReplaceAll(__CSS_SPECIFICITY_PSEUDO_ELEMENT_PATTERN, input, 3);
            input = this._countReplaceAll(__CSS_SPECIFICITY_PSEUDO_CLASS_WITH_BRACKETS_PATTERN, input, 2);
            input = this._countReplaceAll(__CSS_SPECIFICITY_PSEUDO_CLASS_PATTERN, input, 2);
            input = __CSS_SPECIFICITY_UNIVERSAL_AND_SEPARATOR_PATTERN.matcher(input).replaceAll(" ");
            this._countReplaceAll(__CSS_SPECIFICITY_ELEMENT_PATTERN, input, 3);
        }

        private String _countReplaceAll(Pattern pattern, String selector, int sIndex) {
            Matcher m = pattern.matcher(selector);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                int n = sIndex;
                this._weights[n] = this._weights[n] + 1;
                m.appendReplacement(sb, " ");
            }
            m.appendTail(sb);
            return sb.toString();
        }

        @Override
        public int compareTo(CssSpecificity o) {
            for (int i = 0; i < this._weights.length; ++i) {
                if (this._weights[i] == o._weights[i]) continue;
                return this._weights[i] - o._weights[i];
            }
            return 0;
        }
    }

    private static class CssRule
    implements Comparable<CssRule> {
        private String _selector;
        private String _properties;
        private CssSpecificity _specificity;

        public CssRule(String selector, String properties, int positionIdx) {
            this._selector = selector;
            this._properties = properties;
            this._specificity = new CssSpecificity(this._selector, positionIdx);
        }

        public String getSelector() {
            return this._selector;
        }

        public String getProperties() {
            return this._properties;
        }

        @Override
        public int compareTo(CssRule r) {
            return this._specificity.compareTo(r._specificity);
        }
    }
}

