/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.authentication;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.core.authentication.AbstractCredentialProvider;
import org.ametys.core.authentication.BlockingCredentialProvider;
import org.ametys.core.authentication.LogoutCapable;
import org.ametys.core.authentication.NonBlockingCredentialProvider;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.captcha.CaptchaHelper;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.http.HttpCookie;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.SourceResolver;

public class FormCredentialProvider
extends AbstractCredentialProvider
implements NonBlockingCredentialProvider,
BlockingCredentialProvider,
LogoutCapable,
Contextualizable,
Configurable,
Serviceable {
    public static final String AUTHENTICATION_BY_COOKIE = "authentication_by_cookie";
    public static final Integer NB_CONNECTION_ATTEMPTS = 3;
    public static final int COOKIE_LIFETIME = 1209600;
    protected static final Integer TIME_ALLOWED = 1;
    private static final String __PARAM_DATASOURCE = "runtime.authentication.form.security.storage";
    private static final String __PARAM_CAPTCHA = "runtime.authentication.form.captcha";
    private static final String __PARAM_COOKIES = "runtime.authentication.form.cookies";
    private static final String __PARAM_LOGIN_BY_EMAIL = "runtime.authentication.form.login-by-email";
    protected String _usernameField;
    protected String _passwordField;
    protected String _rememberMeField;
    protected String _captchaField;
    protected String _captchaKeyField;
    protected boolean _cookieEnabled;
    protected String _cookieName;
    protected long _cookieLifetime;
    protected Set<String> _acceptedUrlPrefixes;
    protected Collection<Pattern> _acceptedUrlPatterns = Arrays.asList(Pattern.compile("^plugins/core/captcha/[^/]+/image.png"));
    protected boolean _useCaptchaOnFailure;
    protected boolean _allowCookies;
    protected boolean _allowLoginByEmail;
    protected Context _context;
    protected UserPopulationDAO _userPopulationDAO;
    protected String _datasourceId;
    protected SourceResolver _sourceResolver;
    protected AuthenticationTokenManager _authenticationTokenManager;
    protected boolean _lazyInitialized;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        try {
            this._authenticationTokenManager = (AuthenticationTokenManager)manager.lookup(AuthenticationTokenManager.ROLE);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        manager.lookup(ConnectionHelper.ROLE);
    }

    @Override
    public void init(String id, String cpModelId, Map<String, Object> paramValues, String label) {
        super.init(id, cpModelId, paramValues, label);
        this._useCaptchaOnFailure = (Boolean)paramValues.get(__PARAM_CAPTCHA);
        this._allowCookies = (Boolean)paramValues.get(__PARAM_COOKIES);
        this._allowLoginByEmail = (Boolean)paramValues.get(__PARAM_LOGIN_BY_EMAIL);
        this._datasourceId = (String)paramValues.get(__PARAM_DATASOURCE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._usernameField = configuration.getChild("username-field").getValue("Username");
        this._passwordField = configuration.getChild("password-field").getValue("Password");
        this._rememberMeField = configuration.getChild("rememberMe-field").getValue("rememberMe");
        this._captchaField = configuration.getChild("capcha-field").getValue("Captcha");
        this._captchaKeyField = configuration.getChild("captchaKey-field").getValue("CaptchaKey");
        this._cookieEnabled = configuration.getChild("cookie").getChild("cookieEnabled").getValueAsBoolean(true);
        this._cookieLifetime = configuration.getChild("cookie").getChild("cookieLifeTime").getValueAsLong(604800L);
        this._cookieName = configuration.getChild("cookie").getChild("cookieName").getValue("AmetysAuthentication");
        this._acceptedUrlPrefixes = new HashSet<String>();
        for (Configuration prefixConf : configuration.getChild("unauthenticated").getChildren("urlPrefix")) {
            String prefix = prefixConf.getValue(null);
            if (prefix == null) continue;
            this._acceptedUrlPrefixes.add(prefix);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("FormBasedCredentialsProvider values :  Name field=" + this._usernameField + ", Pwd field=" + this._passwordField + ", CookieEnabled=" + this._cookieEnabled + ", Cookie duration=" + this._cookieLifetime + ", Cookie name=" + this._cookieName + ", accepted prefixes : [" + StringUtils.join(this._acceptedUrlPrefixes, (String)", ") + "]");
        }
    }

    protected Connection getSQLConnection() {
        if (!this._lazyInitialized) {
            try {
                if (this._useCaptchaOnFailure) {
                    SQLScriptHelper.createTableIfNotExists(this._datasourceId, "Users_FormConnectionFailed", "plugin:core://scripts/%s/users_form_failed_connection.sql", this._sourceResolver);
                }
            }
            catch (Exception e) {
                this.getLogger().error("The tables requires by the " + this.getClass().getName() + " could not be created. A degraded behavior will occur", (Throwable)e);
            }
            this._lazyInitialized = true;
        }
        return ConnectionHelper.getConnection(this._datasourceId);
    }

    @Override
    public void logout() {
        String token = this._getCookieValue();
        if (this._authenticationTokenManager != null && StringUtils.isNotEmpty((String)token)) {
            this._authenticationTokenManager.deleteTokenByValue(token, null);
        }
        this._deleteCookie();
    }

    @Override
    public boolean nonBlockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) {
        return true;
    }

    @Override
    public boolean blockingIsStillConnected(UserIdentity userIdentity, Redirector redirector) {
        return true;
    }

    @Override
    public boolean blockingGrantAnonymousRequest() {
        Request request = ContextHelper.getRequest((Context)this._context);
        boolean accept = false;
        String login = request.getParameter(this._usernameField);
        String password = request.getParameter(this._passwordField);
        String url = (String)request.getAttribute("inWorkspaceURL");
        if (login == null || password == null) {
            if (!accept) {
                for (String prefix : this._acceptedUrlPrefixes) {
                    if (!url.startsWith(prefix)) continue;
                    accept = true;
                    break;
                }
            }
            if (!accept) {
                for (Pattern pattern : this._acceptedUrlPatterns) {
                    if (!pattern.matcher(url).matches()) continue;
                    accept = true;
                    break;
                }
            }
        }
        if (accept && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("URL accepted : " + url);
        }
        return accept;
    }

    @Override
    public boolean nonBlockingGrantAnonymousRequest() {
        return this.blockingGrantAnonymousRequest();
    }

    @Override
    public UserIdentity blockingGetUserIdentity(Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        try {
            UserIdentity userIdentity = this._getUserIdentityFromRequest(request);
            if (userIdentity != null) {
                return userIdentity;
            }
            redirector.redirect(false, (String)request.getAttribute("Runtime:RequestLoginURL"));
            return null;
        }
        catch (NotUniqueUserException | AccessDeniedException e) {
            this.blockingUserNotAllowed(redirector);
            return null;
        }
    }

    @Override
    public UserIdentity nonBlockingGetUserIdentity(Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        try {
            UserIdentity userIdentity = this._getUserIdentityFromRequest(request);
            if (userIdentity != null) {
                return userIdentity;
            }
            if (this._allowCookies) {
                String token = this._getCookieValue();
                if (this._authenticationTokenManager != null && StringUtils.isNotEmpty((String)token)) {
                    UserIdentity userFromToken = this._authenticationTokenManager.validateToken(token);
                    if (userFromToken != null) {
                        return userFromToken;
                    }
                    this._deleteCookie();
                }
            }
        }
        catch (NotUniqueUserException | AccessDeniedException e) {
            this.nonBlockingUserNotAllowed(redirector);
            return null;
        }
        return null;
    }

    private UserIdentity _getUserIdentityFromRequest(Request request) throws AccessDeniedException, NotUniqueUserException {
        String login = request.getParameter(this._usernameField);
        String password = request.getParameter(this._passwordField);
        if (StringUtils.isNotBlank((String)login) && password != null) {
            Integer nbConnect;
            UserPopulation userPopulation = this._getPopulation(request);
            if (this._useCaptchaOnFailure && (nbConnect = this.requestNbConnectBDD(login, userPopulation.getId())) >= NB_CONNECTION_ATTEMPTS) {
                String answer = request.getParameter(this._captchaField);
                String captchaKey = request.getParameter(this._captchaKeyField);
                if (!CaptchaHelper.checkAndInvalidate(captchaKey, answer)) {
                    throw new AccessDeniedException("Captcha is invalid for user '" + login + "'");
                }
            }
            for (UserDirectory userDirectory : userPopulation.getUserDirectories()) {
                User user = userDirectory.getUser(login);
                if (user == null && this._allowLoginByEmail) {
                    user = userDirectory.getUserByEmail(login);
                }
                if (user == null) continue;
                if (userDirectory.checkCredentials(user.getIdentity().getLogin(), password)) {
                    return user.getIdentity();
                }
                throw new AccessDeniedException("Password is incorrect for user '" + user.getIdentity().getLogin() + "'");
            }
            throw new AccessDeniedException("Unknown user '" + login + "'");
        }
        return null;
    }

    private UserPopulation _getPopulation(Request request) {
        List userPopulations = (List)request.getAttribute("Runtime:UserPopulationsList");
        if (userPopulations.size() == 1) {
            return (UserPopulation)userPopulations.get(0);
        }
        String chosenUserPopulationId = (String)request.getAttribute("Runtime:CurrentUserPopulationId");
        if (StringUtils.isNotBlank((String)chosenUserPopulationId)) {
            UserPopulation chosenUserPopulation = userPopulations.stream().filter(userPopulation -> StringUtils.equals((String)userPopulation.getId(), (String)chosenUserPopulationId)).findFirst().get();
            return chosenUserPopulation;
        }
        throw new IllegalStateException("The " + this.getClass().getName() + " does not work when population is not known");
    }

    @Override
    public void blockingUserNotAllowed(Redirector redirector) throws Exception {
        Request request = ContextHelper.getRequest((Context)this._context);
        String url = (String)request.getAttribute("Runtime:RequestLoginURL");
        StringBuilder parameters = new StringBuilder();
        parameters.append(url.indexOf(63) >= 0 ? "&" : "?");
        parameters.append("login=");
        parameters.append(request.getParameter(this._usernameField));
        parameters.append("&authFailure=true");
        if (this._useCaptchaOnFailure) {
            int nbAttempts;
            String captchaKey = request.getParameter(this._captchaKeyField);
            int nbConnect = this._setNbConnectBDD(request.getParameter(this._usernameField), this._getPopulation(request).getId());
            if (nbConnect == (nbAttempts = NB_CONNECTION_ATTEMPTS - 1) || captchaKey == null && nbConnect > nbAttempts) {
                parameters.append("&tooManyAttempts=true");
            }
        }
        if (StringUtils.isNotEmpty((String)this._getCookieValue())) {
            parameters.append("&cookieFailure=true");
            this._deleteCookie();
        }
        redirector.redirect(false, url + parameters);
    }

    @Override
    public void nonBlockingUserNotAllowed(Redirector redirector) throws Exception {
    }

    @Override
    public void blockingUserAllowed(UserIdentity userConnected) {
        if (this._allowCookies) {
            Request request = ContextHelper.getRequest((Context)this._context);
            if ("true".equals(request.getParameter(this._rememberMeField))) {
                this.nonBlockingUserAllowed(userConnected);
            }
        } else {
            this._deleteLoginFailedBDD(userConnected.getLogin(), userConnected.getPopulationId());
        }
    }

    @Override
    public void nonBlockingUserAllowed(UserIdentity userConnected) {
        if (this._cookieEnabled && this._authenticationTokenManager != null) {
            String token = this._authenticationTokenManager.generateToken(userConnected, this._cookieLifetime, 1, "FormsCredentialProvider-Cookie", null);
            this._updateCookie(token);
        }
    }

    @Override
    public boolean requiresNewWindow() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteAllPastLoginFailedBDD() {
        block5: {
            Connection connection = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                connection = this.getSQLConnection();
                String sql = "DELETE FROM Users_FormConnectionFailed WHERE last_connect < ?";
                ZonedDateTime dateToday = ZonedDateTime.now();
                ZonedDateTime thresholdDate = dateToday.minusDays(TIME_ALLOWED.intValue());
                Timestamp threshold = Timestamp.from(thresholdDate.toInstant());
                stmt = connection.prepareStatement(sql);
                stmt.setTimestamp(1, threshold);
                stmt.execute();
                ConnectionHelper.cleanup(rs);
            }
            catch (SQLException e) {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
                break block5;
            }
            finally {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer requestNbConnectBDD(String login, String populationId) {
        Integer n;
        this._deleteAllPastLoginFailedBDD();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT nb_connect FROM Users_FormConnectionFailed WHERE login = ? and population_id = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, login);
            stmt.setString(2, populationId);
            rs = stmt.executeQuery();
            Integer nbConnect = 0;
            if (rs.next()) {
                nbConnect = rs.getInt("nb_connect");
            }
            n = nbConnect;
        }
        catch (SQLException e) {
            Integer n2;
            try {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
                n2 = 0;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
            return n2;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        return n;
    }

    protected Integer _setNbConnectBDD(String login, String populationId) {
        Integer nbConnect = this.requestNbConnectBDD(login, populationId);
        if (nbConnect == 0) {
            this._insertLoginNbConnectBDD(login, populationId);
        } else {
            this._updateLoginNbConnectBDD(login, populationId, nbConnect);
        }
        return nbConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _insertLoginNbConnectBDD(String login, String populationId) {
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sqlUpdate = "INSERT INTO Users_FormConnectionFailed (login, population_id, nb_connect, last_connect) VALUES (?, ?, ?, ?)";
            stmt = connection.prepareStatement(sqlUpdate);
            stmt.setString(1, login);
            stmt.setString(2, populationId);
            stmt.setInt(3, 1);
            Timestamp date = Timestamp.from(Instant.now());
            stmt.setTimestamp(4, date);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _deleteLoginFailedBDD(String login, String populationId) {
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "DELETE FROM Users_FormConnectionFailed WHERE login = ? and population_id = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, login);
            stmt.setString(2, populationId);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _updateLoginNbConnectBDD(String login, String populationId, Integer nbConnect) {
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sqlUpdate = "UPDATE Users_FormConnectionFailed SET nb_connect = ? WHERE login = ? and population_id = ?";
            stmt = connection.prepareStatement(sqlUpdate);
            stmt.setInt(1, nbConnect + 1);
            stmt.setString(2, login);
            stmt.setString(3, populationId);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    protected String _getCookieValue() {
        Cookie[] cookies = ContextHelper.getRequest((Context)this._context).getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._cookieName.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected boolean _isCookieAlreadySet() {
        Cookie[] cookies = ContextHelper.getRequest((Context)this._context).getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._cookieName.equals(cookie.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected void _updateCookie(String value) {
        Request request = ContextHelper.getRequest((Context)this._context);
        Response response = ContextHelper.getResponse((Context)this._context);
        Cookie cookie = response.createCookie(this._cookieName, value);
        cookie.setSecure(request.isSecure());
        cookie.setPath(ContextHelper.getRequest((Context)this._context).getContextPath());
        cookie.setMaxAge((int)this._cookieLifetime);
        ((HttpCookie)cookie).getServletCookie().setHttpOnly(true);
        ContextHelper.getResponse((Context)this._context).addCookie(cookie);
    }

    protected void _deleteCookie() {
        HttpCookie cookie = new HttpCookie(this._cookieName, "");
        cookie.setPath(ContextHelper.getRequest((Context)this._context).getContextPath());
        cookie.setMaxAge(0);
        ContextHelper.getResponse((Context)this._context).addCookie((Cookie)cookie);
    }
}

