/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.checker;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.util.StringUtils;
import org.apache.commons.lang.ArrayUtils;

public class HttpUrlChecker
implements ItemChecker,
Configurable {
    protected String _userAgent;
    protected String _method;
    protected int _timeout;
    protected String _okCodes;
    protected Map<String, String> _requestHeaderValues;
    protected Map<String, String> _responseHeaderValues;
    protected String _additionnalURL;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration config = configuration.getChild("configuration");
        Configuration requestConfig = config.getChild("request");
        Configuration responseConfig = config.getChild("response");
        Configuration timeoutConfig = requestConfig.getChild("timeout", false);
        this._timeout = timeoutConfig != null ? timeoutConfig.getValueAsInteger() : -1;
        this._userAgent = requestConfig.getChild("user-agent").getValue(null);
        this._method = requestConfig.getChild("method").getValue(null);
        this._additionnalURL = requestConfig.getChild("additionnal-url").getValue("");
        this._requestHeaderValues = new HashMap<String, String>();
        for (Configuration headerChildConfig : requestConfig.getChild("header").getChildren()) {
            this._requestHeaderValues.put(headerChildConfig.getName(), headerChildConfig.getValue());
        }
        this._okCodes = responseConfig.getChild("code").getValue(null);
        this._responseHeaderValues = new HashMap<String, String>();
        for (Configuration headerChildConfig : responseConfig.getChild("header").getChildren()) {
            this._responseHeaderValues.put(headerChildConfig.getName(), headerChildConfig.getValue());
        }
    }

    @Override
    public void check(List<String> values) throws ItemCheckerTestFailureException {
        String configUrl = values.get(0);
        try {
            HttpURLConnection httpUrlConnection = this._prepareConnection(configUrl + this._additionnalURL);
            int responseCode = httpUrlConnection.getResponseCode();
            this._testResponseCode(httpUrlConnection, responseCode);
            this._testHeaders(httpUrlConnection);
        }
        catch (IOException e) {
            throw new ItemCheckerTestFailureException("Unable to contact '" + configUrl + this._additionnalURL + "' (" + e.getMessage() + ")", e);
        }
    }

    private HttpURLConnection _prepareConnection(String configUrl) throws IOException, MalformedURLException, ProtocolException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)new URL(configUrl).openConnection();
        if (this._userAgent != null) {
            httpUrlConnection.setRequestProperty("User-Agent", this._userAgent);
        }
        if (this._method != null) {
            httpUrlConnection.setRequestMethod(this._method);
        }
        if (this._timeout != -1) {
            httpUrlConnection.setReadTimeout(this._timeout);
        }
        for (Map.Entry<String, String> headers : this._requestHeaderValues.entrySet()) {
            httpUrlConnection.setRequestProperty(headers.getKey(), headers.getValue());
        }
        return httpUrlConnection;
    }

    private void _testHeaders(HttpURLConnection httpUrlConnection) throws ItemCheckerTestFailureException {
        Set<String> keys = this._responseHeaderValues.keySet();
        for (String key : keys) {
            if (httpUrlConnection.getHeaderField(key) == null) {
                throw new ItemCheckerTestFailureException("The header field '" + key + "' does not exist");
            }
            if (httpUrlConnection.getHeaderField(key).equals(this._responseHeaderValues.get(key))) continue;
            throw new ItemCheckerTestFailureException("The header field '" + key + "' does not have the expected value '" + this._responseHeaderValues.get(key) + "', found '" + httpUrlConnection.getHeaderField(key) + "' instead.");
        }
    }

    private void _testResponseCode(HttpURLConnection httpUrlConnection, int responseCode) throws ItemCheckerTestFailureException, IOException {
        Object[] okCodes = new String[]{Integer.toString(200)};
        if (this._okCodes != null) {
            okCodes = StringUtils.split((String)this._okCodes, (String)",");
        }
        if (!ArrayUtils.contains((Object[])okCodes, (Object)Integer.toString(responseCode))) {
            throw new ItemCheckerTestFailureException("Error code " + responseCode + ". Message: " + httpUrlConnection.getResponseMessage());
        }
    }
}

