/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.checker;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ametys.plugins.core.impl.authentication.KerberosCredentialProvider;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class KerberosChecker
extends AbstractLogEnabled
implements ItemChecker,
Contextualizable {
    protected Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void check(List<String> values) throws ItemCheckerTestFailureException {
        String kdc = values.get(0);
        String realm = values.get(1);
        String login = values.get(2);
        String password = values.get(3);
        try {
            LoginContext loginContext = KerberosCredentialProvider.createLoginContext(kdc, realm, login, password, this._context);
            Subject subject = loginContext.getSubject();
            final GSSManager manager = GSSManager.getInstance();
            PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

                @Override
                public GSSCredential run() throws GSSException {
                    return manager.createCredential(null, Integer.MAX_VALUE, new Oid("1.3.6.1.5.5.2"), 1);
                }
            };
            GSSCredential gssCredential = Subject.doAs(loginContext.getSubject(), action);
            final GSSContext gssContext = GSSManager.getInstance().createContext(gssCredential);
            byte[] serviceTicket = Subject.doAs(subject, new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        byte[] token = new byte[]{};
                        gssContext.requestMutualAuth(false);
                        gssContext.requestCredDeleg(false);
                        return gssContext.initSecContext(token, 0, token.length);
                    }
                    catch (GSSException e) {
                        throw new ItemCheckerTestFailureException("aaa (" + e.getMessage() + ")", e);
                    }
                }
            });
            System.out.println(serviceTicket);
        }
        catch (IOException | PrivilegedActionException | LoginException | ContextException | GSSException e) {
            throw new ItemCheckerTestFailureException("Unable to connect to the KDC (" + e.getMessage() + ")", e);
        }
    }
}

