/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.right;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.datasource.AbstractMyBatisDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ModifiableProfileAssignmentStorage;
import org.ametys.core.user.UserIdentity;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.SqlSession;

public class JdbcProfileAssignmentStorage
extends AbstractMyBatisDAO
implements ModifiableProfileAssignmentStorage {
    protected final Map<String, Database> _cache = new HashMap<String, Database>();
    protected String _supportedContext;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._supportedContext = configuration.getChild("context").getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Database _getFullData(Object context) {
        String rootContext = "/" + StringUtils.split((String)((String)context), (char)'/')[0];
        Map<String, Database> map = this._cache;
        synchronized (map) {
            if (this._cache.containsKey(rootContext)) {
                return this._cache.get(rootContext);
            }
            try (SqlSession session = this.getSession();){
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("context", rootContext);
                List profiles = session.selectList("ProfilesAssignment.getAllProfiles", parameters);
                Database db = new Database(profiles);
                this._cache.put(rootContext, db);
                Database database = db;
                return database;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _clearCache() {
        Map<String, Database> map = this._cache;
        synchronized (map) {
            this._cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _clearCache(Object context) {
        String rootContext = "/" + StringUtils.split((String)((String)context), (char)'/')[0];
        Map<String, Database> map = this._cache;
        synchronized (map) {
            if (this._cache.containsKey(rootContext)) {
                this._cache.remove(rootContext);
            }
        }
    }

    protected Object getObjectWithPrefix(Object context) {
        return context;
    }

    protected String getPrefix() {
        return null;
    }

    @Override
    public boolean hasUserDeniedProfile(Set<? extends Object> rootContexts, UserIdentity user, Set<String> profileIds) {
        String prefix = this.getPrefix();
        Set stringPrefixContexts = rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
        try (SqlSession session = this.getSession();){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("login", user.getLogin());
            parameters.put("population", user.getPopulationId());
            parameters.put("contextPrefixes", stringPrefixContexts);
            parameters.put("profileIds", profileIds);
            List deniedProfiles = session.selectList("ProfilesAssignment.getUserDeniedProfiles", parameters);
            boolean bl = !deniedProfiles.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean hasUserAllowedProfile(Set<? extends Object> rootContexts, UserIdentity user, Set<String> profileIds) {
        String prefix = this.getPrefix();
        Set stringPrefixContexts = rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
        try (SqlSession session = this.getSession();){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("login", user.getLogin());
            parameters.put("population", user.getPopulationId());
            parameters.put("contextPrefixes", stringPrefixContexts);
            parameters.put("profileIds", profileIds);
            List allowedProfiles = session.selectList("ProfilesAssignment.getUserAllowedProfiles", parameters);
            boolean bl = !allowedProfiles.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean hasGroupDeniedProfile(Set<? extends Object> rootContexts, GroupIdentity group, Set<String> profileIds) {
        String prefix = this.getPrefix();
        Set stringPrefixContexts = rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
        try (SqlSession session = this.getSession();){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("groupId", group.getId());
            parameters.put("groupDirectory", group.getDirectoryId());
            parameters.put("contextPrefixes", stringPrefixContexts);
            parameters.put("profileIds", profileIds);
            List deniedProfiles = session.selectList("ProfilesAssignment.getGroupDeniedProfiles", parameters);
            boolean bl = !deniedProfiles.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean hasGroupAllowedProfile(Set<? extends Object> rootContexts, GroupIdentity group, Set<String> profileIds) {
        String prefix = this.getPrefix();
        Set stringPrefixContexts = rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
        try (SqlSession session = this.getSession();){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("groupId", group.getId());
            parameters.put("groupDirectory", group.getDirectoryId());
            parameters.put("contextPrefixes", stringPrefixContexts);
            parameters.put("profileIds", profileIds);
            List allowedProfiles = session.selectList("ProfilesAssignment.getGroupAllowedProfiles", parameters);
            boolean bl = !allowedProfiles.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean hasAnyConnectedDeniedProfile(Set<? extends Object> rootContexts, Set<String> profileIds) {
        String prefix = this.getPrefix();
        Set stringPrefixContexts = rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
        try (SqlSession session = this.getSession();){
            HashMap<String, Set<Object>> parameters = new HashMap<String, Set<Object>>();
            parameters.put("contextPrefixes", stringPrefixContexts);
            parameters.put("profileIds", profileIds);
            List deniedProfiles = session.selectList("ProfilesAssignment.getAnyConnectedDeniedProfiles", parameters);
            boolean bl = !deniedProfiles.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean hasAnyConnectedAllowedProfile(Set<? extends Object> rootContexts, Set<String> profileIds) {
        String prefix = this.getPrefix();
        Set stringPrefixContexts = rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
        try (SqlSession session = this.getSession();){
            HashMap<String, Set<Object>> parameters = new HashMap<String, Set<Object>>();
            parameters.put("contextPrefixes", stringPrefixContexts);
            parameters.put("profileIds", profileIds);
            List allowedProfiles = session.selectList("ProfilesAssignment.getAnyConnectedAllowedProfiles", parameters);
            boolean bl = !allowedProfiles.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean hasAnonymousDeniedProfile(Set<? extends Object> rootContexts, Set<String> profileIds) {
        String prefix = this.getPrefix();
        Set stringPrefixContexts = rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
        try (SqlSession session = this.getSession();){
            HashMap<String, Set<Object>> parameters = new HashMap<String, Set<Object>>();
            parameters.put("contextPrefixes", stringPrefixContexts);
            parameters.put("profileIds", profileIds);
            List deniedProfiles = session.selectList("ProfilesAssignment.getAnonymousDeniedProfiles", parameters);
            boolean bl = !deniedProfiles.isEmpty();
            return bl;
        }
    }

    @Override
    public boolean hasAnonymousAllowedProfile(Set<? extends Object> rootContexts, Set<String> profileIds) {
        String prefix = this.getPrefix();
        Set stringPrefixContexts = rootContexts.stream().filter(String.class::isInstance).map(context -> (prefix != null ? prefix : "") + (String)context).collect(Collectors.toSet());
        try (SqlSession session = this.getSession();){
            HashMap<String, Set<Object>> parameters = new HashMap<String, Set<Object>>();
            parameters.put("contextPrefixes", stringPrefixContexts);
            parameters.put("profileIds", profileIds);
            List allowedProfiles = session.selectList("ProfilesAssignment.getAnonymousAllowedProfiles", parameters);
            boolean bl = !allowedProfiles.isEmpty();
            return bl;
        }
    }

    @Override
    public Set<String> getAllowedProfilesForAnyConnectedUser(Object object) {
        return Optional.ofNullable(this._getFullData(object).getAllowedAnyConnected().get(object)).orElse(Collections.emptySet());
    }

    @Override
    public boolean isAnyConnectedUserAllowed(Object object, String profileId) {
        return this.getAllowedProfilesForAnyConnectedUser(object).contains(profileId);
    }

    @Override
    public void addAllowedProfilesForAnyConnectedUser(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (String profileId : profileIds) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List allowedProfiles = session.selectList("ProfilesAssignment.getAnyConnectedAllowedProfiles", parameters);
                if (allowedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addAllowedAnyConnected", parameters);
                    continue;
                }
                this.getLogger().debug("Profile {} is already allowed for anyconnected on context {}", (Object)profileId, prefixedObject);
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedProfilesForAnyConnectedUser(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession(true);){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", this.getObjectWithPrefix(object));
            parameters.put("profileIds", profileIds);
            session.delete("ProfilesAssignment.deleteAllowedAnyConnected", parameters);
        }
    }

    @Override
    public Set<String> getDeniedProfilesForAnyConnectedUser(Object object) {
        return Optional.ofNullable(this._getFullData(object).getDeniedAnyConnected().get(object)).orElse(Collections.emptySet());
    }

    @Override
    public boolean isAnyConnectedUserDenied(Object object, String profileId) {
        return this.getDeniedProfilesForAnyConnectedUser(object).contains(profileId);
    }

    @Override
    public void addDeniedProfilesForAnyConnectedUser(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (String profileId : profileIds) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List deniedProfiles = session.selectList("ProfilesAssignment.getAnyConnectedDeniedProfiles", parameters);
                if (deniedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addDeniedAnyConnected", parameters);
                    continue;
                }
                this.getLogger().debug("Profile {} is already denied for anyconnected on context {}", (Object)profileId, prefixedObject);
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedProfilesForAnyConnectedUser(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession(true);){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", this.getObjectWithPrefix(object));
            parameters.put("profileIds", profileIds);
            session.delete("ProfilesAssignment.deleteDeniedAnyConnected", parameters);
        }
    }

    @Override
    public Set<String> getAllowedProfilesForAnonymous(Object object) {
        return Optional.ofNullable(this._getFullData(object).getAllowedAnonymous().get(object)).orElse(Collections.emptySet());
    }

    @Override
    public boolean isAnonymousAllowed(Object object, String profileId) {
        return this.getAllowedProfilesForAnonymous(object).contains(profileId);
    }

    @Override
    public void addAllowedProfilesForAnonymous(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (String profileId : profileIds) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List allowedProfiles = session.selectList("ProfilesAssignment.getAnonymousAllowedProfiles", parameters);
                if (allowedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addAllowedAnonymous", parameters);
                    continue;
                }
                this.getLogger().debug("Profile {} is already allowed for anonymous on context {}", (Object)profileId, prefixedObject);
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedProfilesForAnonymous(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession(true);){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", this.getObjectWithPrefix(object));
            parameters.put("profileIds", profileIds);
            session.delete("ProfilesAssignment.deleteAllowedAnonymous", parameters);
        }
    }

    @Override
    public Set<String> getDeniedProfilesForAnonymous(Object object) {
        return Optional.ofNullable(this._getFullData(object).getDeniedAnonymous().get(object)).orElse(Collections.emptySet());
    }

    @Override
    public boolean isAnonymousDenied(Object object, String profileId) {
        return this.getDeniedProfilesForAnonymous(object).contains(profileId);
    }

    @Override
    public void addDeniedProfilesForAnonymous(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (String profileId : profileIds) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List deniedProfiles = session.selectList("ProfilesAssignment.getAnonymousDeniedProfiles", parameters);
                if (deniedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addDeniedAnonymous", parameters);
                    continue;
                }
                this.getLogger().debug("Profile {} is already denied for anonymous on context {}", (Object)profileId, prefixedObject);
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedProfilesForAnonymous(Object object, Set<String> profileIds) {
        this._clearCache(object);
        try (SqlSession session = this.getSession(true);){
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("context", this.getObjectWithPrefix(object));
            parameters.put("profileIds", profileIds);
            session.delete("ProfilesAssignment.deleteDeniedAnonymous", parameters);
        }
    }

    @Override
    public Set<String> getAllowedProfilesForUser(UserIdentity user, Object object) {
        return Optional.ofNullable(this._getFullData(object).getAlloweUserData().get(object)).map(contextMap -> (Set)contextMap.get(user)).orElse(Collections.emptySet());
    }

    @Override
    public Map<UserIdentity, Set<String>> getAllowedProfilesForUsers(Object object) {
        return Optional.ofNullable(this._getFullData(object).getAlloweUserData().get(object)).orElse(Collections.emptyMap());
    }

    @Override
    public Set<UserIdentity> getAllowedUsers(Object object, String profileId) {
        return Optional.ofNullable(this._getFullData(object).getAlloweUserData().get(object)).map(m -> m.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(profileId)).map(e -> (UserIdentity)e.getKey()).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Override
    public void addAllowedUsers(Set<UserIdentity> users, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List allowedProfiles = session.selectList("ProfilesAssignment.getUserAllowedProfiles", parameters);
                if (allowedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addAllowedUser", parameters);
                    continue;
                }
                this.getLogger().debug("Login {} has already profile {} on context {}", new Object[]{userIdentity, profileId, prefixedObject});
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedUsers(Set<UserIdentity> users, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                parameters.put("profileIds", Arrays.asList(profileId));
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteAllowedUser", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedUsers(Set<UserIdentity> users, Object object) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteAllowedUser", parameters);
            }
            session.commit();
        }
    }

    @Override
    public Map<GroupIdentity, Set<String>> getAllowedProfilesForGroups(Object object) {
        return Optional.ofNullable(this._getFullData(object).getAlloweGroupData().get(object)).orElse(Collections.emptyMap());
    }

    @Override
    public Set<GroupIdentity> getAllowedGroups(Object object, String profileId) {
        return Optional.ofNullable(this._getFullData(object).getAlloweGroupData().get(object)).map(m -> m.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(profileId)).map(e -> (GroupIdentity)e.getKey()).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Override
    public void addAllowedGroups(Set<GroupIdentity> groups, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List allowedProfiles = session.selectList("ProfilesAssignment.getGroupAllowedProfiles", parameters);
                if (allowedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addAllowedGroup", parameters);
                    continue;
                }
                this.getLogger().debug("Group {} is already allowed for profile {} on context {}", new Object[]{group, profileId, prefixedObject});
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedGroups(Set<GroupIdentity> groups, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                parameters.put("profileIds", Arrays.asList(profileId));
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteAllowedGroup", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeAllowedGroups(Set<GroupIdentity> groups, Object object) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteAllowedGroup", parameters);
            }
            session.commit();
        }
    }

    @Override
    public Set<String> getDeniedProfilesForUser(UserIdentity user, Object object) {
        return Optional.ofNullable(this._getFullData(object).getDeniedUserData().get(object)).map(contextMap -> (Set)contextMap.get(user)).orElse(Collections.emptySet());
    }

    @Override
    public Map<UserIdentity, Set<String>> getDeniedProfilesForUsers(Object object) {
        return Optional.ofNullable(this._getFullData(object).getDeniedUserData().get(object)).orElse(Collections.emptyMap());
    }

    @Override
    public Set<UserIdentity> getDeniedUsers(Object object, String profileId) {
        return Optional.ofNullable(this._getFullData(object).getDeniedUserData().get(object)).map(m -> m.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(profileId)).map(e -> (UserIdentity)e.getKey()).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Override
    public void addDeniedUsers(Set<UserIdentity> users, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List deniedProfiles = session.selectList("ProfilesAssignment.getUserDeniedProfiles", parameters);
                if (deniedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addDeniedUser", parameters);
                    continue;
                }
                this.getLogger().debug("Login {} is already denied for profile {} on context {}", new Object[]{userIdentity, profileId, prefixedObject});
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedUsers(Set<UserIdentity> users, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                parameters.put("profileIds", Arrays.asList(profileId));
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteDeniedUser", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedUsers(Set<UserIdentity> users, Object object) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (UserIdentity userIdentity : users) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("login", userIdentity.getLogin());
                parameters.put("population", userIdentity.getPopulationId());
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteDeniedUser", parameters);
            }
            session.commit();
        }
    }

    @Override
    public Map<GroupIdentity, Set<String>> getDeniedProfilesForGroups(Object object) {
        return Optional.ofNullable(this._getFullData(object).getDeniedGroupData().get(object)).orElse(Collections.emptyMap());
    }

    @Override
    public Set<GroupIdentity> getDeniedGroups(Object object, String profileId) {
        return Optional.ofNullable(this._getFullData(object).getDeniedGroupData().get(object)).map(m -> m.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(profileId)).map(e -> (GroupIdentity)e.getKey()).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    @Override
    public void addDeniedGroups(Set<GroupIdentity> groups, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            Object prefixedObject = this.getObjectWithPrefix(object);
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                parameters.put("context", prefixedObject);
                parameters.put("profileIds", Arrays.asList(profileId));
                List deniedProfiles = session.selectList("ProfilesAssignment.getGroupDeniedProfiles", parameters);
                if (deniedProfiles.isEmpty()) {
                    parameters.put("profileId", profileId);
                    session.insert("ProfilesAssignment.addDeniedGroup", parameters);
                    continue;
                }
                this.getLogger().debug("Group {} is already denied for profile {} on context {}", new Object[]{group, profileId, prefixedObject});
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedGroups(Set<GroupIdentity> groups, Object object, String profileId) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                parameters.put("profileIds", Arrays.asList(profileId));
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteDeniedGroup", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeDeniedGroups(Set<GroupIdentity> groups, Object object) {
        this._clearCache(object);
        try (SqlSession session = this.getSession();){
            for (GroupIdentity group : groups) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("groupId", group.getId());
                parameters.put("groupDirectory", group.getDirectoryId());
                if (object != null) {
                    parameters.put("context", this.getObjectWithPrefix(object));
                }
                session.delete("ProfilesAssignment.deleteDeniedGroup", parameters);
            }
            session.commit();
        }
    }

    @Override
    public void removeProfile(String profileId) {
        this._clearCache();
        try (SqlSession session = this.getSession();){
            HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
            parameters.put("profileIds", Arrays.asList(profileId));
            session.delete("ProfilesAssignment.deleteAllowedUser", parameters);
            session.delete("ProfilesAssignment.deleteDeniedUser", parameters);
            session.delete("ProfilesAssignment.deleteAllowedGroup", parameters);
            session.delete("ProfilesAssignment.deleteDeniedGroup", parameters);
            session.delete("ProfilesAssignment.deleteAllowedAnonymous", parameters);
            session.delete("ProfilesAssignment.deleteDeniedAnonymous", parameters);
            session.delete("ProfilesAssignment.deleteAllowedAnyConnected", parameters);
            session.delete("ProfilesAssignment.deleteDeniedAnyConnected", parameters);
            session.commit();
        }
    }

    @Override
    public void removeUser(UserIdentity user) {
        this._clearCache();
        try (SqlSession session = this.getSession();){
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("login", user.getLogin());
            parameters.put("population", user.getPopulationId());
            session.delete("ProfilesAssignment.deleteAllowedUser", parameters);
            session.delete("ProfilesAssignment.deleteDeniedUser", parameters);
            session.commit();
        }
    }

    @Override
    public void removeGroup(GroupIdentity group) {
        this._clearCache();
        try (SqlSession session = this.getSession();){
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("groupId", group.getId());
            parameters.put("groupDirectory", group.getDirectoryId());
            session.delete("ProfilesAssignment.deleteAllowedGroup", parameters);
            session.delete("ProfilesAssignment.deleteDeniedGroup", parameters);
            session.commit();
        }
    }

    @Override
    public boolean isSupported(Object object) {
        if (object instanceof String) {
            String context = (String)object;
            return context.equals(this._supportedContext) || context.startsWith(this._supportedContext + "/");
        }
        return false;
    }

    @Override
    public boolean isRootContextSupported(Object rootContext) {
        return this.isSupported(rootContext);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    private static class Database {
        private Map<String, Set<String>> _allowedAnonymousData = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> _deniedAnonymousData = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> _allowedAnyConnectedData = new HashMap<String, Set<String>>();
        private Map<String, Set<String>> _deniedAnyConnectedData = new HashMap<String, Set<String>>();
        private Map<String, Map<UserIdentity, Set<String>>> _allowedUserData = new HashMap<String, Map<UserIdentity, Set<String>>>();
        private Map<String, Map<UserIdentity, Set<String>>> _deniedUserData = new HashMap<String, Map<UserIdentity, Set<String>>>();
        private Map<String, Map<GroupIdentity, Set<String>>> _allowedGroupData = new HashMap<String, Map<GroupIdentity, Set<String>>>();
        private Map<String, Map<GroupIdentity, Set<String>>> _deniedGroupData = new HashMap<String, Map<GroupIdentity, Set<String>>>();

        Database(List<Map<String, String>> data) {
            for (Map<String, String> map : data) {
                String targetGroup;
                String targetId;
                String type = map.get("type").trim();
                String profileId = map.get("profileId");
                String context = map.get("context");
                if ("ALLOWED_ANONYMOUS".equals(type) || "DENIED_ANONYMOUS".equals(type) || "ALLOWED_ANYCONNECTED".equals(type) || "DENIED_ANYCONNECTED".equals(type)) {
                    this._buildAnonymousOrAnyConnectedData(type, profileId, context);
                    continue;
                }
                if ("ALLOWED_USER".equals(type) || "DENIED_USER".equals(type)) {
                    targetId = map.get("targetId");
                    targetGroup = map.get("targetGroup");
                    UserIdentity user = new UserIdentity(targetId, targetGroup);
                    this._buildUserData(type, profileId, context, user);
                    continue;
                }
                targetId = map.get("targetId");
                targetGroup = map.get("targetGroup");
                GroupIdentity group = new GroupIdentity(targetId, targetGroup);
                this._buildGroupData(type, profileId, context, group);
            }
        }

        private void _buildGroupData(String type, String profileId, String context, GroupIdentity group) {
            Map<GroupIdentity, Set<String>> contextMap;
            Map<String, Map<GroupIdentity, Set<String>>> wData = "ALLOWED_GROUP".equals(type) ? this._allowedGroupData : this._deniedGroupData;
            if (!wData.containsKey(context)) {
                wData.put(context, new HashMap());
            }
            if (!(contextMap = wData.get(context)).containsKey(group)) {
                contextMap.put(group, new HashSet());
            }
            Set<String> profileSet = contextMap.get(group);
            profileSet.add(profileId);
        }

        private void _buildUserData(String type, String profileId, String context, UserIdentity user) {
            Map<UserIdentity, Set<String>> contextMap;
            Map<String, Map<UserIdentity, Set<String>>> wData = "ALLOWED_USER".equals(type) ? this._allowedUserData : this._deniedUserData;
            if (!wData.containsKey(context)) {
                wData.put(context, new HashMap());
            }
            if (!(contextMap = wData.get(context)).containsKey(user)) {
                contextMap.put(user, new HashSet());
            }
            Set<String> profileSet = contextMap.get(user);
            profileSet.add(profileId);
        }

        private void _buildAnonymousOrAnyConnectedData(String type, String profileId, String context) {
            Map<String, Set<String>> wData = "ALLOWED_ANONYMOUS".equals(type) ? this._allowedAnonymousData : ("DENIED_ANONYMOUS".equals(type) ? this._deniedAnonymousData : ("ALLOWED_ANYCONNECTED".equals(type) ? this._allowedAnyConnectedData : this._deniedAnyConnectedData));
            if (!wData.containsKey(context)) {
                wData.put(context, new HashSet());
            }
            Set<String> profileSet = wData.get(context);
            profileSet.add(profileId);
        }

        public Map<String, Set<String>> getAllowedAnonymous() {
            return this._allowedAnonymousData;
        }

        public Map<String, Set<String>> getDeniedAnonymous() {
            return this._deniedAnonymousData;
        }

        public Map<String, Set<String>> getAllowedAnyConnected() {
            return this._allowedAnyConnectedData;
        }

        public Map<String, Set<String>> getDeniedAnyConnected() {
            return this._deniedAnyConnectedData;
        }

        public Map<String, Map<UserIdentity, Set<String>>> getAlloweUserData() {
            return this._allowedUserData;
        }

        public Map<String, Map<UserIdentity, Set<String>>> getDeniedUserData() {
            return this._deniedUserData;
        }

        public Map<String, Map<GroupIdentity, Set<String>>> getAlloweGroupData() {
            return this._allowedGroupData;
        }

        public Map<String, Map<GroupIdentity, Set<String>>> getDeniedGroupData() {
            return this._deniedGroupData;
        }
    }
}

