/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.directory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.InvalidModificationException;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.util.CachingComponent;
import org.ametys.plugins.core.impl.user.jdbc.JdbcParameter;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.AbstractParameterParser;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Enumerator;
import org.ametys.runtime.parameter.Errors;
import org.ametys.runtime.parameter.Parameter;
import org.ametys.runtime.parameter.ParameterHelper;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.excalibur.source.SourceResolver;

public class JdbcUserDirectory
extends CachingComponent<String, User>
implements ModifiableUserDirectory,
Component,
Serviceable,
Contextualizable,
PluginAware {
    protected static final String BASE_PLUGIN_NAME = "core";
    static final String[] __COLUMNS = new String[]{"login", "password", "firstname", "lastname", "email"};
    private static final String __DATASOURCE_PARAM_NAME = "runtime.users.jdbc.datasource";
    private static final String __USERS_TABLE_PARAM_NAME = "runtime.users.jdbc.table";
    private static final String __COLUMN_LOGIN = "login";
    private static final String __COLUMN_PASSWORD = "password";
    private static final String __COLUMN_FIRSTNAME = "firstname";
    private static final String __COLUMN_LASTNAME = "lastname";
    private static final String __COLUMN_EMAIL = "email";
    private static final String __COLUMN_SALT = "salt";
    private static final String __CACKE_KEY_PREFIX_FOR_LOGIN = "login$";
    private static final String __CACKE_KEY_PREFIX_FOR_EMAIL = "email$";
    protected String _dataSourceId;
    protected String _userTableName;
    protected Map<String, JdbcParameter> _model;
    protected String _pluginName;
    protected ServiceManager _manager;
    protected Context _context;
    protected SourceResolver _sourceResolver;
    private ThreadSafeComponentManager<Validator> _validatorManager;
    private ThreadSafeComponentManager<Enumerator> _enumeratorManager;
    private ObservationManager _observationManager;
    private CurrentUserProvider _currentUserProvider;
    private String _udModelId;
    private Map<String, Object> _paramValues;
    private String _populationId;
    private String _label;
    private String _id;
    private boolean _lazyInitialized;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._enumeratorManager.dispose();
        this._enumeratorManager = null;
        this._validatorManager.dispose();
        this._validatorManager = null;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void init(String id, String udModelId, Map<String, Object> paramValues, String label) {
        this._id = id;
        this._udModelId = udModelId;
        this._paramValues = paramValues;
        this._label = label;
        this._userTableName = (String)paramValues.get(__USERS_TABLE_PARAM_NAME);
        this._dataSourceId = (String)paramValues.get(__DATASOURCE_PARAM_NAME);
        this.configureModelParameters();
    }

    protected ObservationManager getObservationManager() {
        if (this._observationManager == null) {
            try {
                this._observationManager = (ObservationManager)((Object)this._manager.lookup(ObservationManager.ROLE));
            }
            catch (ServiceException e) {
                if (PluginsManager.getInstance().isSafeMode()) {
                    this.getLogger().debug("Unable to lookup ObservationManager component in safe mode", (Throwable)e);
                }
                this.getLogger().error("Unable to lookup ObservationManager component", (Throwable)e);
            }
        }
        return this._observationManager;
    }

    protected CurrentUserProvider getCurrentUserProvider() {
        if (this._currentUserProvider == null) {
            try {
                this._currentUserProvider = (CurrentUserProvider)this._manager.lookup(CurrentUserProvider.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException("Unable to lookup CurrentUserProvider component", e);
            }
        }
        return this._currentUserProvider;
    }

    protected Connection getSQLConnection() {
        Connection connection = ConnectionHelper.getConnection(this._dataSourceId);
        if (!this._lazyInitialized) {
            try {
                SQLScriptHelper.createTableIfNotExists(connection, this._userTableName, "plugin:core://scripts/%s/jdbc_users.template.sql", this._sourceResolver, (Map<String, String>)ArrayUtils.toMap((Object[])new String[][]{{"%TABLENAME%", this._userTableName}}));
            }
            catch (Exception e) {
                this.getLogger().error("The tables requires by the " + this.getClass().getName() + " could not be created. A degraded behavior will occur", (Throwable)e);
            }
            this._lazyInitialized = true;
        }
        return connection;
    }

    @Override
    public void setPopulationId(String populationId) {
        this._populationId = populationId;
    }

    @Override
    public String getPopulationId() {
        return this._populationId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    @Override
    public String getUserDirectoryModelId() {
        return this._udModelId;
    }

    @Override
    public Collection<User> getUsers() {
        return this.getUsers(Integer.MAX_VALUE, 0, Collections.EMPTY_MAP);
    }

    @Override
    public List<User> getUsers(int count, int offset, Map<String, Object> parameters) {
        String pattern = StringUtils.defaultIfEmpty((String)((String)parameters.get("pattern")), null);
        int boundedCount = count >= 0 ? count : Integer.MAX_VALUE;
        int boundedOffset = offset >= 0 ? offset : 0;
        SelectUsersJdbcQueryExecutor<List<User>> queryExecutor = new SelectUsersJdbcQueryExecutor<List<User>>(pattern, boundedCount, boundedOffset){

            @Override
            protected List<User> processResultSet(ResultSet rs) throws SQLException {
                return JdbcUserDirectory.this._getUsersProcessResultSet(rs, JdbcUserDirectory.__CACKE_KEY_PREFIX_FOR_LOGIN);
            }
        };
        return (List)queryExecutor.run();
    }

    @Override
    public User getUser(final String login) {
        User user;
        if (this.isCacheEnabled() && (user = (User)this.getObjectFromCache(__CACKE_KEY_PREFIX_FOR_LOGIN + login)) != null) {
            return user;
        }
        SelectUserJdbcQueryExecutor<User> queryExecutor = new SelectUserJdbcQueryExecutor<User>(login){

            @Override
            protected User processResultSet(ResultSet rs) throws SQLException {
                return JdbcUserDirectory.this._getUserProcessResultSet(rs, login, JdbcUserDirectory.__CACKE_KEY_PREFIX_FOR_LOGIN);
            }
        };
        return (User)queryExecutor.run();
    }

    @Override
    public User getUserByEmail(String email) throws NotUniqueUserException {
        User user;
        if (this.isCacheEnabled() && (user = (User)this.getObjectFromCache(__CACKE_KEY_PREFIX_FOR_EMAIL + email)) != null) {
            return user;
        }
        SelectUserJdbcQueryExecutor<List<User>> queryExecutor = new SelectUserJdbcQueryExecutor<List<User>>(email, __COLUMN_EMAIL){

            @Override
            protected List<User> processResultSet(ResultSet rs) throws SQLException {
                return JdbcUserDirectory.this._getUsersProcessResultSet(rs, JdbcUserDirectory.__CACKE_KEY_PREFIX_FOR_EMAIL);
            }
        };
        List users = (List)queryExecutor.run();
        if (users.size() == 1) {
            return (User)users.get(0);
        }
        if (users.isEmpty()) {
            return null;
        }
        throw new NotUniqueUserException("Find " + users.size() + " users matching the email " + email);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkCredentials(String login, String password) {
        boolean bl;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        boolean updateNeeded;
        block22: {
            boolean bl2;
            block21: {
                boolean bl3;
                block20: {
                    boolean bl4;
                    block19: {
                        boolean bl5;
                        block18: {
                            boolean bl6;
                            block17: {
                                updateNeeded = false;
                                con = null;
                                stmt = null;
                                rs = null;
                                try {
                                    con = this.getSQLConnection();
                                    String sql = "SELECT login, password, salt FROM " + this._userTableName + " WHERE " + __COLUMN_LOGIN + " = ?";
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug(sql);
                                    }
                                    stmt = con.prepareStatement(sql);
                                    stmt.setString(1, login);
                                    rs = stmt.executeQuery();
                                    if (rs.next()) {
                                        String storedPassword = rs.getString(__COLUMN_PASSWORD);
                                        String salt = rs.getString(__COLUMN_SALT);
                                        if (salt == null && this._isMD5Encrypted(storedPassword)) {
                                            String encryptedPassword = org.ametys.core.util.StringUtils.md5Base64(password);
                                            if (encryptedPassword == null) {
                                                this.getLogger().error("Unable to encrypt password");
                                                bl6 = false;
                                                ConnectionHelper.cleanup(rs);
                                                break block17;
                                            }
                                            if (storedPassword.equals(encryptedPassword)) {
                                                updateNeeded = true;
                                                bl5 = true;
                                                ConnectionHelper.cleanup(rs);
                                                break block18;
                                            }
                                            bl4 = false;
                                            ConnectionHelper.cleanup(rs);
                                            break block19;
                                        }
                                        String encryptedPassword = DigestUtils.sha512Hex((String)(salt + password));
                                        if (encryptedPassword == null) {
                                            this.getLogger().error("Unable to encrypt password");
                                            bl3 = false;
                                            ConnectionHelper.cleanup(rs);
                                            break block20;
                                        }
                                        bl2 = storedPassword.equalsIgnoreCase(encryptedPassword);
                                        ConnectionHelper.cleanup(rs);
                                        break block21;
                                    }
                                    bl = false;
                                    ConnectionHelper.cleanup(rs);
                                    break block22;
                                }
                                catch (SQLException e) {
                                    this.getLogger().error("Error during the connection to the database", (Throwable)e);
                                    boolean bl7 = false;
                                    return bl7;
                                }
                            }
                            ConnectionHelper.cleanup(stmt);
                            ConnectionHelper.cleanup(con);
                            if (!updateNeeded) return bl6;
                            this._updateToSSHAPassword(login, password);
                            return bl6;
                        }
                        ConnectionHelper.cleanup(stmt);
                        ConnectionHelper.cleanup(con);
                        if (!updateNeeded) return bl5;
                        this._updateToSSHAPassword(login, password);
                        return bl5;
                    }
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup(con);
                    if (!updateNeeded) return bl4;
                    this._updateToSSHAPassword(login, password);
                    return bl4;
                }
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                if (!updateNeeded) return bl3;
                this._updateToSSHAPassword(login, password);
                return bl3;
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(con);
            if (!updateNeeded) return bl2;
            this._updateToSSHAPassword(login, password);
            return bl2;
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(con);
        if (!updateNeeded) return bl;
        this._updateToSSHAPassword(login, password);
        return bl;
        finally {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(con);
            if (updateNeeded) {
                this._updateToSSHAPassword(login, password);
            }
        }
    }

    @Override
    public void add(Map<String, String> userInformation) throws InvalidModificationException {
        Map<String, Errors> errorFields;
        Connection con = null;
        PreparedStatement stmt = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Starting adding a new user");
        }
        if ((errorFields = this.validate(userInformation)).size() > 0) {
            throw new InvalidModificationException("The creation of user failed because of invalid parameter values", errorFields);
        }
        String login = userInformation.get(__COLUMN_LOGIN);
        try {
            con = this.getSQLConnection();
            stmt = this.createAddStatement(con, userInformation);
            if (stmt.executeUpdate() != 1) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("The user to remove '" + login + "' was not removed.");
                }
                throw new InvalidModificationException("Error no user inserted");
            }
            if (this.getObservationManager() != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("user", new UserIdentity(login, this._populationId));
                this.getObservationManager().notify(new Event("user.added", this.getCurrentUserProvider().getUser(), eventParams));
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error communication with database", (Throwable)e);
                throw new InvalidModificationException("Error during the communication with the database", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(con);
    }

    @Override
    public Map<String, Errors> validate(Map<String, String> userInformation) {
        HashMap<String, Errors> errorFields = new HashMap<String, Errors>();
        for (JdbcParameter parameter : this._model.values()) {
            String untypedvalue = userInformation.get(parameter.getId());
            Object typedvalue = ParameterHelper.castValue(untypedvalue, (ParameterHelper.ParameterType)((Object)parameter.getType()));
            Validator validator = parameter.getValidator();
            if (validator == null) continue;
            Errors errors = new Errors();
            validator.validate(typedvalue, errors);
            if (!errors.hasErrors()) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The field '" + parameter.getId() + "' is not valid");
            }
            errorFields.put(parameter.getId(), errors);
        }
        return errorFields;
    }

    @Override
    public void update(Map<String, String> userInformation) throws InvalidModificationException {
        Connection con = null;
        PreparedStatement stmt = null;
        HashMap<String, Errors> errorFields = new HashMap<String, Errors>();
        for (String id : userInformation.keySet()) {
            JdbcParameter parameter = this._model.get(id);
            if (parameter == null) continue;
            String untypedvalue = userInformation.get(parameter.getId());
            Object typedvalue = ParameterHelper.castValue(untypedvalue, (ParameterHelper.ParameterType)((Object)parameter.getType()));
            Validator validator = parameter.getValidator();
            if (validator == null) continue;
            Errors errors = new Errors();
            validator.validate(typedvalue, errors);
            if (!errors.hasErrors()) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The field '" + parameter.getId() + "' is not valid");
            }
            errorFields.put(parameter.getId(), errors);
        }
        if (errorFields.size() > 0) {
            throw new InvalidModificationException("The modification of user failed because of invalid parameter values", errorFields);
        }
        String login = userInformation.get(__COLUMN_LOGIN);
        if (StringUtils.isEmpty((String)login)) {
            throw new InvalidModificationException("Cannot update without login information");
        }
        try {
            con = this.getSQLConnection();
            stmt = this.createModifyStatement(con, userInformation);
            if (stmt.executeUpdate() != 1) {
                throw new InvalidModificationException("Error. User '" + login + "' not updated");
            }
            if (this.getObservationManager() != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("user", new UserIdentity(login, this._populationId));
                this.getObservationManager().notify(new Event("user.updated", this.getCurrentUserProvider().getUser(), eventParams));
            }
            if (this.isCacheEnabled()) {
                this.removeObjectFromCache(__CACKE_KEY_PREFIX_FOR_LOGIN + login);
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error communication with database", (Throwable)e);
                throw new InvalidModificationException("Error communication with database", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(con);
    }

    @Override
    public void remove(String login) throws InvalidModificationException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getSQLConnection();
            String sqlRequest = "DELETE FROM " + this._userTableName + " WHERE " + __COLUMN_LOGIN + " = ?";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(sqlRequest);
            }
            stmt = con.prepareStatement(sqlRequest);
            stmt.setString(1, login);
            if (stmt.executeUpdate() != 1) {
                throw new InvalidModificationException("Error user was not deleted");
            }
            if (this.getObservationManager() != null) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("user", new UserIdentity(login, this._populationId));
                this.getObservationManager().notify(new Event("user.deleted", this.getCurrentUserProvider().getUser(), eventParams));
            }
            if (this.isCacheEnabled()) {
                this.removeObjectFromCache(__CACKE_KEY_PREFIX_FOR_LOGIN + login);
            }
        }
        catch (SQLException e) {
            try {
                throw new InvalidModificationException("Error during the communication with the database", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(con);
    }

    @Override
    public Collection<? extends Parameter<ParameterHelper.ParameterType>> getModel() {
        return Collections.unmodifiableCollection(this._model.values());
    }

    protected void configureModelParameters() {
        this._validatorManager = new ThreadSafeComponentManager();
        this._validatorManager.setLogger(this.getLogger());
        this._validatorManager.contextualize(this._context);
        this._validatorManager.service(this._manager);
        this._enumeratorManager = new ThreadSafeComponentManager();
        this._enumeratorManager.setLogger(this.getLogger());
        this._enumeratorManager.contextualize(this._context);
        this._enumeratorManager.service(this._manager);
        this._model = new LinkedHashMap<String, JdbcParameter>();
        JdbcParameterParser jdbcParameterParser = new JdbcParameterParser(this._enumeratorManager, this._validatorManager);
        for (String column : __COLUMNS) {
            JdbcParameter parameter = this._configureParameter(jdbcParameterParser, column, column);
            if (parameter == null) continue;
            this._model.put(parameter.getId(), parameter);
        }
        try {
            jdbcParameterParser.lookupComponents();
        }
        catch (Exception e) {
            this.getLogger().error("Unable to lookup parameter local components", (Throwable)e);
        }
    }

    protected JdbcParameter _configureParameter(JdbcParameterParser jdbcParameterParser, String id, String column) {
        JdbcParameter parameter = new JdbcParameter();
        String catalog = "plugin.core";
        if (__COLUMN_PASSWORD.equals(id)) {
            parameter.setPluginName(BASE_PLUGIN_NAME);
            parameter.setLabel(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_PASSWORD_LABEL"));
            parameter.setDescription(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_PASSWORD_DESCRIPTION"));
            parameter.setType(ParameterHelper.ParameterType.PASSWORD);
            parameter.setValidator(new DefaultValidator(null, true));
        } else if (__COLUMN_LOGIN.equals(id)) {
            parameter.setPluginName(BASE_PLUGIN_NAME);
            parameter.setLabel(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_LOGIN_LABEL"));
            parameter.setDescription(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_LOGIN_DESCRIPTION"));
            parameter.setType(ParameterHelper.ParameterType.STRING);
            I18nizableText invalidText = new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_LOGIN_INVALID");
            parameter.setValidator(new DefaultValidator("^[a-zA-Z0-9_\\-\\.@]{3,64}$", invalidText, true));
        } else if (__COLUMN_LASTNAME.equals(id)) {
            parameter.setPluginName(BASE_PLUGIN_NAME);
            parameter.setLabel(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_LASTNAME_LABEL"));
            parameter.setDescription(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_LASTNAME_DESCRIPTION"));
            parameter.setType(ParameterHelper.ParameterType.STRING);
            parameter.setValidator(new DefaultValidator(null, true));
        } else if (__COLUMN_FIRSTNAME.equals(id)) {
            parameter.setPluginName(BASE_PLUGIN_NAME);
            parameter.setLabel(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_FIRSTNAME_LABEL"));
            parameter.setDescription(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_FIRSTNAME_DESCRIPTION"));
            parameter.setType(ParameterHelper.ParameterType.STRING);
            parameter.setValidator(new DefaultValidator(null, true));
        } else if (__COLUMN_EMAIL.equals(id)) {
            parameter.setPluginName(BASE_PLUGIN_NAME);
            parameter.setLabel(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_EMAIL_LABEL"));
            parameter.setDescription(new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_EMAIL_DESCRIPTION"));
            parameter.setType(ParameterHelper.ParameterType.STRING);
            I18nizableText invalidText = new I18nizableText(catalog, "PLUGINS_CORE_USERS_JDBC_FIELD_EMAIL_INVALID");
            parameter.setValidator(new DefaultValidator("^([\\w\\-\\.])+@([\\w\\-\\.])+\\.([a-zA-Z])+$", invalidText, false));
        } else {
            return null;
        }
        parameter.setId(id);
        parameter.setColumn(column);
        return parameter;
    }

    protected JdbcPredicate _getMandatoryPredicate(String pattern) {
        return null;
    }

    protected String _getPatternToMatch(String pattern) {
        if (pattern != null) {
            return "%" + pattern + "%";
        }
        return null;
    }

    protected boolean _isMD5Encrypted(String password) {
        return password.length() == 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _updateToSSHAPassword(String login, String password) {
        block6: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getSQLConnection();
                String generateSaltKey = RandomStringUtils.randomAlphanumeric((int)48);
                String newEncryptedPassword = DigestUtils.sha512Hex((String)(generateSaltKey + password));
                String sqlUpdate = "UPDATE " + this._userTableName + " SET " + __COLUMN_PASSWORD + " = ?, " + __COLUMN_SALT + " = ? WHERE " + __COLUMN_LOGIN + " = ?";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(sqlUpdate);
                }
                stmt = con.prepareStatement(sqlUpdate);
                stmt.setString(1, newEncryptedPassword);
                stmt.setString(2, generateSaltKey);
                stmt.setString(3, login);
                stmt.execute();
                ConnectionHelper.cleanup(rs);
            }
            catch (SQLException e) {
                this.getLogger().error("Error during the connection to the database", (Throwable)e);
                break block6;
            }
            finally {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(con);
            }
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(con);
        }
    }

    protected PreparedStatement createAddStatement(Connection con, Map<String, String> userInformation) throws SQLException {
        String beginClause = "INSERT INTO " + this._userTableName + " (";
        String middleClause = ") VALUES (";
        String endClause = ")";
        StringBuffer intoClause = new StringBuffer();
        StringBuffer valueClause = new StringBuffer();
        intoClause.append(__COLUMN_SALT);
        valueClause.append("?");
        for (String column : __COLUMNS) {
            intoClause.append(", " + column);
            valueClause.append(", ?");
        }
        String sqlRequest = beginClause + intoClause.toString() + middleClause + valueClause + endClause;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(sqlRequest);
        }
        PreparedStatement stmt = con.prepareStatement(sqlRequest);
        int i = 1;
        boolean clearText = !userInformation.containsKey("clearText") || !"false".equals(userInformation.get("clearText")) || !userInformation.containsKey(__COLUMN_SALT);
        String generatedSaltKey = clearText ? RandomStringUtils.randomAlphanumeric((int)48) : userInformation.get(__COLUMN_SALT);
        stmt.setString(i++, generatedSaltKey);
        for (String column : __COLUMNS) {
            if (__COLUMN_PASSWORD.equals(column)) {
                String encryptedPassword;
                if (clearText) {
                    encryptedPassword = DigestUtils.sha512Hex((String)(generatedSaltKey + userInformation.get(column)));
                    if (encryptedPassword == null) {
                        String message = "Cannot encode password";
                        this.getLogger().error(message);
                        throw new SQLException(message);
                    }
                } else {
                    encryptedPassword = userInformation.get(column);
                }
                stmt.setString(i++, encryptedPassword);
                continue;
            }
            stmt.setString(i++, userInformation.get(column));
        }
        return stmt;
    }

    protected PreparedStatement createModifyStatement(Connection con, Map<String, String> userInformation) throws SQLException {
        String beginClause = "UPDATE " + this._userTableName + " SET ";
        String endClause = " WHERE login = ?";
        StringBuffer columnNames = new StringBuffer("");
        boolean passwordUpdate = false;
        for (String id : userInformation.keySet()) {
            if (!ArrayUtils.contains((Object[])__COLUMNS, (Object)id) || __COLUMN_LOGIN.equals(id) || __COLUMN_PASSWORD.equals(id) && userInformation.get(id) == null) continue;
            if (__COLUMN_PASSWORD.equals(id)) {
                passwordUpdate = true;
            }
            if (columnNames.length() > 0) {
                columnNames.append(", ");
            }
            columnNames.append(id + " = ?");
        }
        if (passwordUpdate) {
            columnNames.append(", salt = ?");
        }
        String sqlRequest = beginClause + columnNames.toString() + endClause;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(sqlRequest);
        }
        PreparedStatement stmt = con.prepareStatement(sqlRequest);
        this._fillModifyStatement(stmt, userInformation);
        return stmt;
    }

    protected void _fillModifyStatement(PreparedStatement stmt, Map<String, String> userInformation) throws SQLException {
        int index = 1;
        boolean clearText = !userInformation.containsKey("clearText") || !"false".equals(userInformation.get("clearText")) || !userInformation.containsKey(__COLUMN_SALT);
        String generatedSaltKey = clearText ? RandomStringUtils.randomAlphanumeric((int)48) : userInformation.get(__COLUMN_SALT);
        boolean passwordUpdate = false;
        for (String id : userInformation.keySet()) {
            if (!ArrayUtils.contains((Object[])__COLUMNS, (Object)id) || __COLUMN_LOGIN.equals(id)) continue;
            if (__COLUMN_PASSWORD.equals(id)) {
                String encryptedPassword;
                if (userInformation.get(id) == null) continue;
                if (clearText) {
                    encryptedPassword = DigestUtils.sha512Hex((String)(generatedSaltKey + userInformation.get(id)));
                    if (encryptedPassword == null) {
                        String message = "Cannot encrypt password";
                        this.getLogger().error(message);
                        throw new SQLException(message);
                    }
                } else {
                    encryptedPassword = userInformation.get(id);
                }
                stmt.setString(index++, encryptedPassword);
                passwordUpdate = true;
                continue;
            }
            stmt.setString(index++, userInformation.get(id));
        }
        if (passwordUpdate) {
            stmt.setString(index++, generatedSaltKey);
        }
        stmt.setString(index++, userInformation.get(__COLUMN_LOGIN));
    }

    protected List<User> _getUsersProcessResultSet(ResultSet rs, String cachePrefix) throws SQLException {
        ArrayList<User> users = new ArrayList<User>();
        while (rs.next()) {
            User user = null;
            if (this.isCacheEnabled()) {
                String login = rs.getString(__COLUMN_LOGIN);
                user = (User)this.getObjectFromCache(__CACKE_KEY_PREFIX_FOR_LOGIN + login);
            }
            if (user == null) {
                user = this._createUserFromResultSet(rs);
                if (this.isCacheEnabled()) {
                    this.addObjectInCache(cachePrefix + user.getIdentity().getLogin(), user);
                }
            }
            users.add(user);
        }
        return users;
    }

    protected User _createUserFromResultSet(ResultSet rs) throws SQLException {
        String login = rs.getString(__COLUMN_LOGIN);
        String lastName = rs.getString(__COLUMN_LASTNAME);
        String firstName = rs.getString(__COLUMN_FIRSTNAME);
        String email = rs.getString(__COLUMN_EMAIL);
        return new User(new UserIdentity(login, this._populationId), lastName, firstName, email, this);
    }

    protected User _getUserProcessResultSet(ResultSet rs, String login, String cachePrefix) throws SQLException {
        if (rs.next()) {
            User user = this._createUserFromResultSet(rs);
            if (this.isCacheEnabled()) {
                this.addObjectInCache(cachePrefix + login, user);
            }
            return user;
        }
        return null;
    }

    public class JdbcPredicate {
        protected String _predicate;
        protected List<String> _predicateParamValues;

        public JdbcPredicate(String predicate, String ... values) {
            this(predicate, Arrays.asList(values));
        }

        public JdbcPredicate(String predicate, List<String> values) {
            this._predicate = predicate;
            this._predicateParamValues = values;
        }

        public String getPredicate() {
            return this._predicate;
        }

        public void setPredicate(String predicate) {
            this._predicate = predicate;
        }

        public List<String> getValues() {
            return this._predicateParamValues;
        }

        public void setValues(List<String> values) {
            this._predicateParamValues = values;
        }
    }

    protected static class JdbcParameterParser
    extends AbstractParameterParser<JdbcParameter, ParameterHelper.ParameterType> {
        JdbcParameterParser(ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager) {
            super(enumeratorManager, validatorManager);
        }

        @Override
        protected JdbcParameter _createParameter(Configuration parameterConfig) throws ConfigurationException {
            return new JdbcParameter();
        }

        @Override
        protected String _parseId(Configuration parameterConfig) throws ConfigurationException {
            return parameterConfig.getAttribute("id");
        }

        @Override
        protected ParameterHelper.ParameterType _parseType(Configuration parameterConfig) throws ConfigurationException {
            try {
                return ParameterHelper.ParameterType.valueOf(parameterConfig.getAttribute("type").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Invalid type", parameterConfig, (Throwable)e);
            }
        }

        @Override
        protected Object _parseDefaultValue(Configuration parameterConfig, JdbcParameter jdbcParameter) {
            String defaultValue = parameterConfig.getChild("default-value").getValue(null);
            return ParameterHelper.castValue(defaultValue, (ParameterHelper.ParameterType)((Object)jdbcParameter.getType()));
        }
    }

    protected class SelectUsersJdbcQueryExecutor<T>
    extends AbstractJdbcQueryExecutor<T> {
        protected String _pattern;
        protected int _length;
        protected int _offset;
        protected JdbcPredicate _mandatoryPredicate;
        protected String _patternToMatch;

        protected SelectUsersJdbcQueryExecutor(String pattern, int length, int offset) {
            this._pattern = pattern;
            this._length = length;
            this._offset = offset;
        }

        @Override
        protected String getSqlQuery(Connection connection) {
            StringBuilder selectClause = new StringBuilder();
            for (String column : __COLUMNS) {
                if (selectClause.length() > 0) {
                    selectClause.append(", ");
                }
                selectClause.append(column);
            }
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append((CharSequence)selectClause).append(" FROM ").append(JdbcUserDirectory.this._userTableName);
            this._mandatoryPredicate = JdbcUserDirectory.this._getMandatoryPredicate(this._pattern);
            if (this._mandatoryPredicate != null) {
                sql.append(" WHERE ").append(this._mandatoryPredicate.getPredicate());
            }
            this._patternToMatch = JdbcUserDirectory.this._getPatternToMatch(this._pattern);
            if (this._patternToMatch != null) {
                if ("derby".equals(ConnectionHelper.getDatabaseType(connection))) {
                    sql.append(this._mandatoryPredicate != null ? " AND (" : " WHERE ").append("UPPER(").append(JdbcUserDirectory.__COLUMN_LOGIN).append(") LIKE UPPER(?) OR ").append("UPPER(").append(JdbcUserDirectory.__COLUMN_LASTNAME).append(") LIKE UPPER(?) OR ").append("UPPER(").append(JdbcUserDirectory.__COLUMN_FIRSTNAME).append(") LIKE UPPER(?)");
                } else {
                    sql.append(this._mandatoryPredicate != null ? " AND (" : " WHERE ").append(JdbcUserDirectory.__COLUMN_LOGIN).append(" LIKE ? OR ").append(JdbcUserDirectory.__COLUMN_LASTNAME).append(" LIKE ? OR ").append(JdbcUserDirectory.__COLUMN_FIRSTNAME).append(" LIKE ?");
                }
                if (this._mandatoryPredicate != null) {
                    sql.append(')');
                }
            }
            sql = this._addQuerySize(this._length, this._offset, connection, selectClause, sql);
            return sql.toString();
        }

        private StringBuilder _addQuerySize(int length, int offset, Connection con, StringBuilder selectClause, StringBuilder sql) {
            if (length == Integer.MAX_VALUE && offset == 0) {
                return sql;
            }
            String dbType = ConnectionHelper.getDatabaseType(con);
            if ("mysql".equals(dbType) || "postgresql".equals(dbType) || "hsqldb".equals(dbType)) {
                sql.append(" LIMIT " + length + " OFFSET " + offset);
                return sql;
            }
            if ("oracle".equals(dbType)) {
                return new StringBuilder("select " + selectClause.toString() + " from (select rownum r, " + selectClause.toString() + " from (" + sql.toString() + ")) where r BETWEEN " + (offset + 1) + " AND " + (offset + length));
            }
            if ("derby".equals(dbType)) {
                return new StringBuilder("select ").append((CharSequence)selectClause).append(" from (select ROW_NUMBER() OVER () AS ROWNUM, ").append(selectClause.toString()).append(" from (").append(sql.toString()).append(") AS TR ) AS TRR where ROWNUM BETWEEN ").append(offset + 1).append(" AND ").append(offset + length);
            }
            if (JdbcUserDirectory.this.getLogger().isWarnEnabled()) {
                JdbcUserDirectory.this.getLogger().warn("The request will not have the limit and offset set, since its type is unknown");
            }
            return sql;
        }

        @Override
        protected PreparedStatement prepareStatement(Connection connection, String sql) throws SQLException {
            PreparedStatement stmt = super.prepareStatement(connection, sql);
            int i = 1;
            if (this._mandatoryPredicate != null) {
                for (String value : this._mandatoryPredicate.getValues()) {
                    stmt.setString(i++, value);
                }
            }
            if (this._patternToMatch != null) {
                stmt.setString(i++, this._patternToMatch);
                stmt.setString(i++, this._patternToMatch);
                stmt.setString(i++, this._patternToMatch);
            }
            return stmt;
        }
    }

    protected class SelectUserJdbcQueryExecutor<T>
    extends AbstractJdbcQueryExecutor<T> {
        protected String _value;
        protected String _searchColumn;

        protected SelectUserJdbcQueryExecutor(String value) {
            this._value = value;
            this._searchColumn = JdbcUserDirectory.__COLUMN_LOGIN;
        }

        protected SelectUserJdbcQueryExecutor(String value, String searchColumn) {
            this._value = value;
            this._searchColumn = searchColumn;
        }

        @Override
        protected String getSqlQuery(Connection connection) {
            StringBuilder selectClause = new StringBuilder();
            for (String id : __COLUMNS) {
                if (selectClause.length() > 0) {
                    selectClause.append(", ");
                }
                selectClause.append(id);
            }
            StringBuilder sql = new StringBuilder("SELECT ");
            sql.append((CharSequence)selectClause).append(" FROM ").append(JdbcUserDirectory.this._userTableName);
            sql.append(" WHERE ").append(this._searchColumn).append(" = ?");
            return sql.toString();
        }

        @Override
        protected PreparedStatement prepareStatement(Connection connection, String sql) throws SQLException {
            PreparedStatement stmt = super.prepareStatement(connection, sql);
            stmt.setString(1, this._value);
            return stmt;
        }
    }

    protected abstract class AbstractJdbcQueryExecutor<T> {
        protected AbstractJdbcQueryExecutor() {
        }

        public T run() {
            try {
                return this.runWithException();
            }
            catch (Exception e) {
                JdbcUserDirectory.this.getLogger().error("Exception during a query execution", (Throwable)e);
                throw new RuntimeException("Exception during a query execution", e);
            }
        }

        public T runWithException() throws Exception {
            T t;
            Connection connection = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                connection = JdbcUserDirectory.this.getSQLConnection();
                String sql = this.getSqlQuery(connection);
                if (JdbcUserDirectory.this.getLogger().isDebugEnabled()) {
                    JdbcUserDirectory.this.getLogger().debug("Executing SQL query: " + sql);
                }
                stmt = this.prepareStatement(connection, sql);
                rs = this.executeQuery(stmt);
                t = this.processResultSet(rs);
            }
            catch (SQLException e) {
                try {
                    JdbcUserDirectory.this.getLogger().error("Error during the communication with the database", (Throwable)e);
                    throw new RuntimeException("Error during the communication with the database", e);
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(stmt);
                    ConnectionHelper.cleanup(connection);
                    throw throwable;
                }
            }
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            ConnectionHelper.cleanup(connection);
            return t;
        }

        protected abstract String getSqlQuery(Connection var1);

        protected PreparedStatement prepareStatement(Connection connection, String sql) throws SQLException {
            return connection.prepareStatement(sql);
        }

        protected ResultSet executeQuery(PreparedStatement stmt) throws SQLException {
            return stmt.executeQuery();
        }

        protected T processResultSet(ResultSet rs) throws SQLException, Exception {
            return null;
        }
    }
}

