/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.user.directory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.SortControl;
import org.ametys.core.user.User;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.util.ldap.AbstractLDAPConnector;
import org.ametys.core.util.ldap.ScopeEnumerator;
import org.ametys.plugins.core.impl.user.LdapUserIdentity;
import org.apache.avalon.framework.component.Component;
import org.apache.commons.lang3.StringUtils;

public class LdapUserDirectory
extends AbstractLDAPConnector<String, User>
implements UserDirectory,
Component {
    public static final String PARAM_DATASOURCE_ID = "runtime.users.ldap.datasource";
    public static final String PARAM_USERS_RELATIVE_DN = "runtime.users.ldap.peopleDN";
    public static final String PARAM_USERS_OBJECT_FILTER = "runtime.users.ldap.baseFilter";
    public static final String PARAM_USERS_SEARCH_SCOPE = "runtime.users.ldap.scope";
    public static final String PARAM_USERS_LOGIN_ATTRIBUTE = "runtime.users.ldap.loginAttr";
    public static final String PARAM_USERS_FIRSTNAME_ATTRIBUTE = "runtime.users.ldap.firstnameAttr";
    public static final String PARAM_USERS_LASTNAME_ATTRIBUTE = "runtime.users.ldap.lastnameAttr";
    public static final String PARAM_USERS_EMAIL_ATTRIBUTE = "runtime.users.ldap.emailAttr";
    public static final String PARAM_USERS_EMAIL_IS_MANDATORY = "runtime.users.ldap.emailMandatory";
    public static final String PARAM_SERVER_SIDE_SORTING = "runtime.users.ldap.serverSideSorting";
    private static final String __CACKE_KEY_PREFIX_FOR_LOGIN = "login$";
    private static final String __CACKE_KEY_PREFIX_FOR_EMAIL = "email$";
    protected String _usersRelativeDN;
    protected String _usersObjectFilter;
    protected int _usersSearchScope;
    protected String _usersLoginAttribute;
    protected String _usersFirstnameAttribute;
    protected String _usersLastnameAttribute;
    protected String _usersEmailAttribute;
    protected boolean _userEmailIsMandatory;
    protected boolean _serverSideSorting;
    protected int _pageSize;
    private String _udModelId;
    private Map<String, Object> _paramValues;
    private String _populationId;
    private String _label;
    private String _id;

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public void init(String id, String udModelId, Map<String, Object> paramValues, String label) throws Exception {
        this._id = id;
        this._udModelId = udModelId;
        this._paramValues = paramValues;
        this._label = label;
        this._usersRelativeDN = (String)paramValues.get(PARAM_USERS_RELATIVE_DN);
        this._usersObjectFilter = (String)paramValues.get(PARAM_USERS_OBJECT_FILTER);
        this._usersSearchScope = ScopeEnumerator.parseScope((String)paramValues.get(PARAM_USERS_SEARCH_SCOPE));
        this._usersLoginAttribute = (String)paramValues.get(PARAM_USERS_LOGIN_ATTRIBUTE);
        this._usersFirstnameAttribute = (String)paramValues.get(PARAM_USERS_FIRSTNAME_ATTRIBUTE);
        if (this._usersFirstnameAttribute != null && this._usersFirstnameAttribute.length() == 0) {
            this._usersFirstnameAttribute = null;
        }
        this._usersLastnameAttribute = (String)paramValues.get(PARAM_USERS_LASTNAME_ATTRIBUTE);
        this._usersEmailAttribute = (String)paramValues.get(PARAM_USERS_EMAIL_ATTRIBUTE);
        this._userEmailIsMandatory = (Boolean)paramValues.get(PARAM_USERS_EMAIL_IS_MANDATORY);
        this._serverSideSorting = (Boolean)paramValues.get(PARAM_SERVER_SIDE_SORTING);
        String dataSourceId = (String)paramValues.get(PARAM_DATASOURCE_ID);
        this._delayedInitialize(dataSourceId);
        this._pageSize = 500;
    }

    @Override
    public void setPopulationId(String populationId) {
        this._populationId = populationId;
    }

    @Override
    public String getPopulationId() {
        return this._populationId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._paramValues;
    }

    @Override
    public String getUserDirectoryModelId() {
        return this._udModelId;
    }

    @Override
    public Collection<User> getUsers() {
        ArrayList<User> users = new ArrayList<User>();
        try {
            for (SearchResult result : this._search(this._pageSize, this._usersRelativeDN, this._usersObjectFilter, this._getSearchConstraint(0))) {
                Map<String, Object> attributes = this._getAttributes(result);
                if (attributes == null) continue;
                User user = this._createUser(attributes);
                if (this.isCacheEnabled()) {
                    this.addObjectInCache(__CACKE_KEY_PREFIX_FOR_LOGIN + user.getIdentity().getLogin(), user);
                }
                users.add(user);
            }
        }
        catch (NamingException e) {
            this.getLogger().error("Error of communication with ldap server", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Error missing at least one attribute or attribute value", (Throwable)e);
        }
        return users;
    }

    @Override
    public List<User> getUsers(int count, int offset, Map<String, Object> parameters) {
        String pattern = (String)parameters.get("pattern");
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = null;
        }
        if (count != 0) {
            LinkedHashMap<String, Map<String, Object>> entries = new LinkedHashMap<String, Map<String, Object>>();
            return this._internalGetUsers(entries, count, offset >= 0 ? offset : 0, pattern, 0);
        }
        return new ArrayList<User>();
    }

    /*
     * Exception decompiling
     */
    @Override
    public User getUserByEmail(String email) throws NotUniqueUserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public User getUser(String login) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCredentials(String login, String password) {
        boolean authenticated = false;
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            String userDN = this.getUserDN(login);
            if (userDN != null) {
                InitialDirContext context = null;
                Hashtable<String, String> env = this._getContextEnv();
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", userDN);
                env.put("java.naming.security.credentials", password);
                try {
                    context = new InitialDirContext(env);
                    authenticated = true;
                }
                catch (AuthenticationException e) {
                    this.getLogger().info("Authentication failed", (Throwable)e);
                }
                catch (NamingException e) {
                    this.getLogger().error("Error communication with ldap server", (Throwable)e);
                }
                finally {
                    this._cleanup(context, null);
                }
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("LDAP Authentication failed since no password (or an empty one) was given");
        }
        return authenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserDN(String login) {
        String userDN = null;
        InitialDirContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialDirContext(this._getContextEnv());
            String filter = "(&" + this._usersObjectFilter + "(" + this._usersLoginAttribute + "={0}))";
            Object[] params = new Object[]{login};
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(this._usersSearchScope);
            constraints.setReturningAttributes(new String[0]);
            results = context.search(this._usersRelativeDN, filter, params, constraints);
            if (results.hasMore()) {
                SearchResult result = results.next();
                userDN = result.getName();
                if (result.isRelative()) {
                    NameParser parser = context.getNameParser("");
                    Name topDN = parser.parse(context.getNameInNamespace());
                    topDN.addAll(parser.parse(this._usersRelativeDN));
                    topDN.addAll(parser.parse(userDN));
                    userDN = topDN.toString();
                }
                if (results.hasMoreElements()) {
                    userDN = null;
                    this.getLogger().error("Multiple matches for attribute \"{}\" and value = \"{}\"", (Object)this._usersLoginAttribute, (Object)login);
                }
            }
        }
        catch (NamingException e) {
            this.getLogger().error("Error communicating with ldap server retrieving user with login '" + login + "'", (Throwable)e);
        }
        finally {
            this._cleanup(context, results);
        }
        return userDN;
    }

    protected User _createUser(Map<String, Object> attributes) {
        if (attributes == null) {
            return null;
        }
        String login = (String)attributes.get(this._usersLoginAttribute);
        String userDn = (String)attributes.get("userDN");
        String lastName = (String)attributes.get(this._usersLastnameAttribute);
        String firstName = null;
        if (this._usersFirstnameAttribute != null) {
            firstName = (String)attributes.get(this._usersFirstnameAttribute);
        }
        String email = (String)attributes.get(this._usersEmailAttribute);
        return new User(new LdapUserIdentity(login, this._populationId, userDn), lastName, firstName, email, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected List<User> _internalGetUsers(Map<String, Map<String, Object>> entries, int count, int offset, String pattern, int possibleErrors) {
        List<User> list;
        InitialLdapContext context = null;
        NamingEnumeration<SearchResult> results = null;
        try {
            context = new InitialLdapContext(this._getContextEnv(), null);
            if (this._serverSideSorting) {
                context.setRequestControls(this._getSortControls());
            }
            Map<String, Object> filter = this._getPatternFilter(pattern);
            results = context.search(this._usersRelativeDN, (String)filter.get("filter"), (Object[])filter.get("params"), this._getSearchConstraint(count == -1 ? 0 : count + offset + possibleErrors));
            list = this._users(entries, count, offset, pattern, results, possibleErrors);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Error missing at least one attribute or value", (Throwable)e);
            ArrayList<User> arrayList = new ArrayList<User>();
            this._cleanup(context, results);
            return arrayList;
        }
        catch (NamingException e2) {
            this.getLogger().error("Error during the communication with ldap server", (Throwable)e2);
            ArrayList<User> arrayList = new ArrayList<User>();
            {
                catch (Throwable throwable) {
                    this._cleanup(context, results);
                    throw throwable;
                }
            }
            this._cleanup(context, results);
            return arrayList;
        }
        this._cleanup(context, results);
        return list;
    }

    private List<User> _users(Map<String, Map<String, Object>> entries, int count, int offset, String pattern, NamingEnumeration<SearchResult> results, int possibleErrors) {
        int nbResults;
        boolean hasMoreElement = results.hasMoreElements();
        for (nbResults = 0; nbResults < offset && hasMoreElement; ++nbResults) {
            results.nextElement();
            hasMoreElement = results.hasMoreElements();
        }
        while ((count == -1 || entries.size() < count) && hasMoreElement) {
            ++nbResults;
            SearchResult result = (SearchResult)results.nextElement();
            Map<String, Object> attrs = this._getAttributes(result);
            if (attrs != null) {
                entries.put((String)attrs.get(this._usersLoginAttribute), attrs);
            }
            hasMoreElement = results.hasMoreElements();
        }
        if (entries.size() < count && nbResults == count + offset + possibleErrors) {
            double nbErrors = count + possibleErrors - entries.size();
            double askedResultsSize = possibleErrors + count;
            int newPossibleErrors = Math.max(possibleErrors + count - entries.size(), (int)Math.ceil((nbErrors / askedResultsSize + 1.0) * nbErrors));
            return this._internalGetUsers(entries, count, offset, pattern, newPossibleErrors);
        }
        ArrayList<User> users = new ArrayList<User>();
        for (Map<String, Object> attributes : entries.values()) {
            users.add(this._createUser(attributes));
        }
        return users;
    }

    protected Control[] _getSortControls() {
        try {
            SortControl sortControl = new SortControl(new String[]{this._usersLastnameAttribute, this._usersFirstnameAttribute}, false);
            return new Control[]{sortControl};
        }
        catch (IOException e) {
            this.getLogger().warn("Cannot sort request on LDAP", (Throwable)e);
            return new Control[0];
        }
    }

    protected Map<String, Object> _getPatternFilter(String pattern) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (pattern == null) {
            result.put("filter", this._usersObjectFilter);
            result.put("params", new Object[0]);
        } else {
            StringBuffer filter = new StringBuffer("(&" + this._usersObjectFilter + "(|(");
            Object[] params = null;
            if (this._usersFirstnameAttribute == null) {
                filter.append(this._usersLoginAttribute);
                filter.append("=*{0}*)(");
                filter.append(this._usersLastnameAttribute);
                filter.append("=*{1}*)(");
                filter.append(this._usersEmailAttribute);
                filter.append("=*{2}*)))");
                params = new Object[]{pattern, pattern, pattern};
            } else {
                filter.append(this._usersLoginAttribute);
                filter.append("=*{0}*)(");
                filter.append(this._usersFirstnameAttribute);
                filter.append("=*{1}*)(");
                filter.append(this._usersLastnameAttribute);
                filter.append("=*{2}*)(");
                filter.append(this._usersEmailAttribute);
                filter.append("=*{3}*)))");
                params = new Object[]{pattern, pattern, pattern, pattern};
            }
            result.put("filter", filter.toString());
            result.put("params", params);
        }
        return result;
    }

    protected SearchControls _getSearchConstraint(int maxResults) {
        SearchControls constraints = new SearchControls();
        int attributesCount = 4;
        int index = 0;
        if (this._usersFirstnameAttribute == null) {
            --attributesCount;
        }
        String[] attrs = new String[attributesCount];
        attrs[index++] = this._usersLoginAttribute;
        if (this._usersFirstnameAttribute != null) {
            attrs[index++] = this._usersFirstnameAttribute;
        }
        attrs[index++] = this._usersLastnameAttribute;
        attrs[index++] = this._usersEmailAttribute;
        constraints.setReturningAttributes(attrs);
        constraints.setSearchScope(this._usersSearchScope);
        if (maxResults > 0) {
            constraints.setCountLimit(maxResults);
        }
        return constraints;
    }

    @Deprecated
    protected User _entry2User(Map<String, Object> attributes) {
        return this._createUser(attributes);
    }

    protected Map<String, Object> _getAttributes(SearchResult entry) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Attributes attrs = entry.getAttributes();
            result.put("userDN", entry.getNameInNamespace());
            Attribute ldapAttr = attrs.get(this._usersLoginAttribute);
            if (ldapAttr == null) {
                this.getLogger().warn("Missing login attribute : '{}'", (Object)this._usersLoginAttribute);
                return null;
            }
            result.put(this._usersLoginAttribute, ldapAttr.get());
            if (this._usersFirstnameAttribute != null) {
                ldapAttr = attrs.get(this._usersFirstnameAttribute);
                if (ldapAttr == null) {
                    this.getLogger().warn("Missing firstname attribute : '{}', for user '{}'.", (Object)this._usersFirstnameAttribute, result.get(this._usersLoginAttribute));
                    return null;
                }
                result.put(this._usersFirstnameAttribute, ldapAttr.get());
            }
            if ((ldapAttr = attrs.get(this._usersLastnameAttribute)) == null) {
                this.getLogger().warn("Missing lastname attribute : '{}', for user '{}'.", (Object)this._usersLastnameAttribute, result.get(this._usersLoginAttribute));
                return null;
            }
            result.put(this._usersLastnameAttribute, ldapAttr.get());
            ldapAttr = attrs.get(this._usersEmailAttribute);
            if (ldapAttr == null && this._userEmailIsMandatory) {
                this.getLogger().warn("Missing email attribute : '{}', for user '{}'.", (Object)this._usersEmailAttribute, result.get(this._usersLoginAttribute));
                return null;
            }
            if (ldapAttr == null) {
                result.put(this._usersEmailAttribute, "");
            } else {
                result.put(this._usersEmailAttribute, ldapAttr.get());
            }
            return result;
        }
        catch (NamingException e) {
            throw new IllegalArgumentException("Missing at least one value for an attribute in an ldap entry", e);
        }
    }
}

