/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.impl.userpref;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.DefaultUserPreferencesStorage;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPrefsHandler;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.parameter.ParameterHelper;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.xml.sax.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JdbcXmlUserPreferencesStorage
extends AbstractLogEnabled
implements DefaultUserPreferencesStorage,
ThreadSafe,
Configurable,
Serviceable {
    protected String _dataSourceId;
    protected String _databaseTable;
    protected ServiceManager _manager;
    private SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration dataSourceConf = configuration.getChild("datasource", false);
        if (dataSourceConf == null) {
            throw new ConfigurationException("The 'datasource' configuration node must be defined.", dataSourceConf);
        }
        String dataSourceConfParam = dataSourceConf.getValue();
        String dataSourceConfType = dataSourceConf.getAttribute("type", "config");
        this._dataSourceId = StringUtils.equals((String)dataSourceConfType, (String)"config") ? (String)Config.getInstance().getValue(dataSourceConfParam) : dataSourceConfParam;
        this._databaseTable = configuration.getChild("table").getValue();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)manager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getUnTypedUserPrefs(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Object handler;
        HashMap<String, String> prefs = new HashMap<String, String>();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        SAXParser saxParser = null;
        try {
            connection = ConnectionHelper.getConnection(this._dataSourceId);
            String dbType = ConnectionHelper.getDatabaseType(connection);
            stmt = connection.prepareStatement("SELECT * FROM " + this._databaseTable + " WHERE login = ? AND population = ? AND context = ?");
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            stmt.setString(3, storageContext);
            rs = stmt.executeQuery();
            if (rs.next()) {
                handler = new UserPrefsHandler(prefs);
                saxParser = (SAXParser)this._manager.lookup(SAXParser.ROLE);
                if ("postgresql".equals(dbType)) {
                    try (InputStream dataIs = rs.getBinaryStream("data");){
                        saxParser.parse(new InputSource(dataIs), (ContentHandler)handler);
                    }
                }
                try (InputStream dataIs = this._sqlDatabaseTypeExtensionPoint.getBlob(dbType, rs, "data");){
                    saxParser.parse(new InputSource(dataIs), (ContentHandler)handler);
                }
            }
            handler = prefs;
        }
        catch (ServiceException e) {
            try {
                String message = "Unable to get a SAX parser.";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, e);
                catch (SQLException e2) {
                    message = "Database error trying to access the preferences of user '" + user + "' in context '" + storageContext + "'.";
                    this.getLogger().error(message, (Throwable)e2);
                    throw new UserPreferencesException(message, e2);
                }
                catch (IOException | SAXException e3) {
                    message = "Error parsing the preferences of user '" + user + "' in context '" + storageContext + "'.";
                    this.getLogger().error(message, (Throwable)e3);
                    throw new UserPreferencesException(message, e3);
                }
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                this._manager.release(saxParser);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        this._manager.release((Object)saxParser);
        return handler;
    }

    @Override
    public void removeUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = ConnectionHelper.getConnection(this._dataSourceId);
            stmt = connection.prepareStatement("DELETE FROM " + this._databaseTable + " WHERE login = ? AND population = ? AND context = ?");
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            stmt.setString(3, storageContext);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                String message = "Database error trying to remove preferences for login '" + user + "' in context '" + storageContext + "'.";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
    }

    @Override
    public void setUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars, Map<String, String> preferences) throws UserPreferencesException {
        block55: {
            byte[] prefBytes = this._getPreferencesXmlBytes(preferences);
            Connection connection = null;
            try {
                boolean dataExists;
                connection = ConnectionHelper.getConnection(this._dataSourceId);
                String dbType = ConnectionHelper.getDatabaseType(connection);
                try (PreparedStatement stmt = connection.prepareStatement("SELECT count(*) FROM " + this._databaseTable + " WHERE login = ? AND population = ? AND context = ?");){
                    stmt.setString(1, user.getLogin());
                    stmt.setString(2, user.getPopulationId());
                    stmt.setString(3, storageContext);
                    try (ResultSet rs = stmt.executeQuery();){
                        rs.next();
                        dataExists = rs.getInt(1) > 0;
                    }
                }
                if (dataExists) {
                    stmt = connection.prepareStatement("UPDATE " + this._databaseTable + " SET data = ? WHERE login = ? AND population = ? AND context = ?");
                    var10_10 = null;
                    try {
                        this._sqlDatabaseTypeExtensionPoint.setBlob(dbType, stmt, 1, prefBytes);
                        stmt.setString(2, user.getLogin());
                        stmt.setString(3, user.getPopulationId());
                        stmt.setString(4, storageContext);
                        stmt.executeUpdate();
                        break block55;
                    }
                    catch (Throwable throwable) {
                        var10_10 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stmt != null) {
                            if (var10_10 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable) {
                                    var10_10.addSuppressed(throwable);
                                }
                            } else {
                                stmt.close();
                            }
                        }
                    }
                }
                stmt = connection.prepareStatement("INSERT INTO " + this._databaseTable + "(login, population, context, data) VALUES(?, ?, ?, ?)");
                var10_10 = null;
                try {
                    stmt.setString(1, user.getLogin());
                    stmt.setString(2, user.getPopulationId());
                    stmt.setString(3, storageContext);
                    this._sqlDatabaseTypeExtensionPoint.setBlob(dbType, stmt, 4, prefBytes);
                    stmt.executeUpdate();
                }
                catch (Throwable throwable) {
                    var10_10 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var10_10 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var10_10.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                String message = "Database error trying to access the preferences of user '" + user + "' in context '" + storageContext + "'.";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, e);
            }
            finally {
                ConnectionHelper.cleanup(connection);
            }
        }
    }

    @Override
    public String getUserPreferenceAsString(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        String value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = values.get(id);
        }
        return value;
    }

    @Override
    public Long getUserPreferenceAsLong(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Long value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (Long)ParameterHelper.castValue(values.get(id), ParameterHelper.ParameterType.LONG);
        }
        return value;
    }

    @Override
    public Date getUserPreferenceAsDate(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Date value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (Date)ParameterHelper.castValue(values.get(id), ParameterHelper.ParameterType.DATE);
        }
        return value;
    }

    @Override
    public Boolean getUserPreferenceAsBoolean(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Boolean value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (Boolean)ParameterHelper.castValue(values.get(id), ParameterHelper.ParameterType.BOOLEAN);
        }
        return value;
    }

    @Override
    public Double getUserPreferenceAsDouble(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Double value = null;
        Map<String, String> values = this.getUnTypedUserPrefs(user, storageContext, contextVars);
        if (values.containsKey(id)) {
            value = (Double)ParameterHelper.castValue(values.get(id), ParameterHelper.ParameterType.DOUBLE);
        }
        return value;
    }

    protected byte[] _getPreferencesXmlBytes(Map<String, String> preferences) throws UserPreferencesException {
        try {
            SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler handler = factory.newTransformerHandler();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bos);
            handler.setResult(result);
            handler.startDocument();
            AttributesImpl attr = new AttributesImpl();
            attr.addCDATAAttribute("version", "2");
            XMLUtils.startElement((ContentHandler)handler, (String)"UserPreferences", (Attributes)attr);
            for (Map.Entry<String, String> preference : preferences.entrySet()) {
                String value = preference.getValue();
                if (value == null) continue;
                attr.clear();
                attr.addCDATAAttribute("id", preference.getKey());
                XMLUtils.createElement((ContentHandler)handler, (String)"preference", (Attributes)attr, (String)preference.getValue());
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"UserPreferences");
            handler.endDocument();
            return bos.toByteArray();
        }
        catch (TransformerException e) {
            throw new UserPreferencesException("Error writing the preferences as XML.", e);
        }
        catch (SAXException e) {
            throw new UserPreferencesException("Error writing the preferences as XML.", e);
        }
    }
}

