/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.parameter;

import java.util.Map;
import java.util.regex.Pattern;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.DefaultValidator;
import org.ametys.runtime.parameter.Errors;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class TextValidator
extends DefaultValidator {
    protected Integer _maxLength;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        int maxLength;
        Configuration validatorConfig = configuration.getChild("validation").getChild("custom-validator");
        this._isMandatory = validatorConfig.getChild("mandatory", false) != null;
        String regexp = validatorConfig.getChild("regexp").getValue(null);
        if (regexp != null) {
            this._regexp = Pattern.compile(regexp);
        }
        if ((maxLength = validatorConfig.getChild("maxlength").getValueAsInteger(0)) > 0) {
            this._maxLength = maxLength;
        }
    }

    @Override
    public Map<String, Object> getConfiguration() {
        Map<String, Object> configuration = super.getConfiguration();
        if (this._maxLength != null) {
            configuration.put("maxlength", this._maxLength);
        }
        return configuration;
    }

    @Override
    protected void validateSingleValue(Object value, Errors errors) {
        super.validateSingleValue(value, errors);
        if (this._maxLength != null && value != null && this.getText(value).length() > this._maxLength) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The validator refused a value for a parameter that should be smaller (max is " + this._maxLength + " and length is " + value.toString().length() + ")");
            }
            errors.addError(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_VALIDATOR_TEXT_MAXLENGTH"));
        }
    }

    @Override
    protected void validateArrayValues(Object[] values, Errors errors) {
        super.validateArrayValues(values, errors);
        if (this._regexp != null && values != null) {
            for (Object value : values) {
                if (this.getText(value).length() <= this._maxLength) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("The validator refused a value for a parameter that should be smaller (max is " + this._maxLength + " and length is " + value.toString().length() + ")");
                }
                errors.addError(new I18nizableText("plugin.core-ui", "PLUGINS_CORE_UI_VALIDATOR_TEXT_MAXLENGTH"));
            }
        }
    }

    protected String getText(Object value) {
        return value != null ? value.toString() : "";
    }
}

