/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.glyph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.core.ui.glyph.CssFontHelper;
import org.ametys.plugins.core.ui.glyph.GlyphProvider;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ApplicationGlyphManager
extends AbstractThreadSafeComponentExtensionPoint<GlyphProvider> {
    private CssFontHelper _cssFontHelper;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cssFontHelper = (CssFontHelper)smanager.lookup(CssFontHelper.ROLE);
    }

    @Callable
    public boolean hasGlyphs() {
        return !this.getGlyphs().isEmpty();
    }

    @Callable
    public List<Map<String, String>> getGlyphsStore() {
        ArrayList<Map<String, String>> glyphs = new ArrayList<Map<String, String>>();
        Set<String> glyphClassNames = this.getGlyphs();
        for (String glyphClassName : glyphClassNames) {
            HashMap<String, String> glyph = new HashMap<String, String>();
            glyph.put("cssClassName", glyphClassName);
            glyphs.add(glyph);
        }
        return glyphs;
    }

    public Set<String> getGlyphs() {
        LinkedHashSet<String> glyphs = new LinkedHashSet<String>();
        for (String id : this.getExtensionsIds()) {
            GlyphProvider glyphProvider = (GlyphProvider)this.getExtension(id);
            Map<String, String> cssFiles = glyphProvider.getCSSFiles();
            for (Map.Entry<String, String> cssFile : cssFiles.entrySet()) {
                String cssFileURI = cssFile.getKey();
                String prefix = cssFile.getValue();
                glyphs.addAll(this._cssFontHelper.getGlyphClassNames(cssFileURI, prefix));
            }
        }
        return glyphs;
    }
}

