/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.groupdirectories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.group.GroupDirectoryContextHelper;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.ModifiableGroupDirectory;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class GetModifiableGroupDirectoriesAction
extends ServiceableAction {
    private GroupDirectoryDAO _groupDirectoryDAO;
    private GroupDirectoryContextHelper _directoryContextHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._groupDirectoryDAO = (GroupDirectoryDAO)smanager.lookup(GroupDirectoryDAO.ROLE);
        this._directoryContextHelper = (GroupDirectoryContextHelper)smanager.lookup(GroupDirectoryContextHelper.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        ArrayList<Map<String, Object>> groupDirectories = new ArrayList<Map<String, Object>>();
        Map jsParameters = (Map)objectModel.get("parent-context");
        List contexts = (List)jsParameters.get("contexts");
        if (contexts == null) {
            for (GroupDirectory groupDirectory : this._groupDirectoryDAO.getGroupDirectories()) {
                if (!(groupDirectory instanceof ModifiableGroupDirectory)) continue;
                groupDirectories.add(this._groupDirectoryDAO.getGroupDirectory2Json(groupDirectory));
            }
        } else {
            Set<String> groupDirectoryIds = this._directoryContextHelper.getGroupDirectoriesOnContexts(new HashSet<String>(contexts));
            for (String gdId : groupDirectoryIds) {
                GroupDirectory gd = this._groupDirectoryDAO.getGroupDirectory(gdId);
                if (!(gd instanceof ModifiableGroupDirectory)) continue;
                groupDirectories.add(this._groupDirectoryDAO.getGroupDirectory2Json(gd));
            }
        }
        HashMap<String, ArrayList<Map<String, Object>>> result = new HashMap<String, ArrayList<Map<String, Object>>>();
        result.put("groupDirectories", groupDirectories);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

