/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.log.parser;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class LogFileParser {
    private static final DateTimeFormatter __DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");
    private static final Pattern __REGEXP = Pattern.compile("^([0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}) ([A-Z ]{5}) \\[([a-zA-Z0-9.-_]+)\\] \\(([^ ]+)\\) (.*)$");

    private LogFileParser() {
    }

    public static List<Map<String, Object>> parseFile(File logFile, Map<String, Object> filters, int limit, Logger logger) throws IOException {
        ArrayList<Map<String, Object>> logLines = new ArrayList<Map<String, Object>>();
        try (ReversedLinesFileReader reader = new ReversedLinesFileReader(logFile, StandardCharsets.UTF_8);){
            StringBuilder stackTrace = new StringBuilder();
            String line = reader.readLine();
            while (line != null && (limit <= 0 || logLines.size() < limit)) {
                Matcher matcher = __REGEXP.matcher(line);
                if (matcher.matches()) {
                    Map<String, Object> logLine = LogFileParser._getLogLine(matcher, stackTrace.toString(), logger);
                    if (LogFileParser._filter(logLine, filters)) {
                        logLines.add(logLine);
                    }
                    stackTrace.setLength(0);
                } else {
                    stackTrace.insert(0, line + "<br/>");
                }
                line = reader.readLine();
            }
        }
        return logLines;
    }

    private static Map<String, Object> _getLogLine(Matcher matcher, String stackTrace, Logger logger) {
        HashMap<String, Object> logLine = new HashMap<String, Object>();
        logLine.put("timestamp", LogFileParser._convertToMs(matcher.group(1), logger));
        logLine.put("level", matcher.group(2).trim());
        logLine.put("category", matcher.group(3));
        logLine.put("thread", matcher.group(4));
        logLine.put("message", matcher.group(5));
        logLine.put("callstack", stackTrace);
        return logLine;
    }

    private static long _convertToMs(String dateTime, Logger logger) {
        long milliseconds = 0L;
        try {
            LocalDateTime ldt = LocalDateTime.parse(dateTime, __DATE_FORMAT);
            ZonedDateTime zdt = ldt.atZone(ZoneId.systemDefault());
            milliseconds = zdt.toInstant().toEpochMilli();
        }
        catch (DateTimeParseException e) {
            logger.error("Impossible to parse the date {} to milliseconds with the format {}", new Object[]{dateTime, __DATE_FORMAT, e});
        }
        return milliseconds;
    }

    private static boolean _filter(Map<String, Object> logLine, Map<String, Object> filters) {
        if (filters != null && !filters.isEmpty()) {
            List filterLevels = (List)filters.get("level");
            if (filterLevels != null && !filterLevels.isEmpty() && !filterLevels.contains(logLine.get("level"))) {
                return false;
            }
            String filterMessage = (String)filters.get("message");
            if (StringUtils.isNotBlank((CharSequence)filterMessage) && !StringUtils.containsIgnoreCase((CharSequence)((String)logLine.get("message")), (CharSequence)filterMessage)) {
                return false;
            }
            String filterCategory = (String)filters.get("category");
            if (StringUtils.isNotBlank((CharSequence)filterCategory) && !StringUtils.containsIgnoreCase((CharSequence)((String)logLine.get("category")), (CharSequence)filterCategory)) {
                return false;
            }
        }
        return true;
    }
}

