/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.minimize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.DevMode;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.ServiceableTransformer;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MinimizeTransformer
extends ServiceableTransformer
implements Contextualizable,
Configurable {
    private static final String DEFAULT_URI_PATTERN = "^/plugins/[^/]+/resources/";
    protected Boolean _isSuperDevMode;
    protected Context _context;
    protected List<Pattern> _patterns;
    protected String _locale;
    protected Boolean _inlineCssMedias;
    protected String _currentContextPath;
    private Map<String, Map<String, String>> _filesQueue;
    private String _queueTag;
    private Set<String> _queueMedia;
    private boolean _isCurrentTagQueued;
    private HashCache _hashCache;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._hashCache = (HashCache)smanager.lookup(HashCache.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration paternsConfig = configuration.getChild("patterns");
        this._patterns = new ArrayList<Pattern>();
        for (Configuration paternConfig : paternsConfig.getChildren("pattern")) {
            Pattern pattern = Pattern.compile(paternConfig.getValue());
            this._patterns.add(pattern);
        }
        if (this._patterns.isEmpty()) {
            this._patterns.add(Pattern.compile(DEFAULT_URI_PATTERN));
        }
        this._inlineCssMedias = Boolean.valueOf(configuration.getChild("inline-css-medias").getValue("true"));
    }

    protected String _getMinimizeUrl() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        return request.getContextPath() + StringUtils.defaultString((String)((String)request.getAttribute("workspaceURI"))) + "/plugins/core-ui/resources-minimized/";
    }

    public void setup(SourceResolver res, Map obj, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(res, obj, src, par);
        Request request = ContextHelper.getRequest((Context)this._context);
        this._locale = request.getLocale().getLanguage();
        this._isSuperDevMode = DevMode.DEVMODE.SUPER_DEVELOPPMENT.equals((Object)DevMode.getDeveloperMode(request));
        this._currentContextPath = request.getContextPath();
    }

    public void startDocument() throws SAXException {
        this._filesQueue = new LinkedHashMap<String, Map<String, String>>();
        this._queueTag = "";
        this._isCurrentTagQueued = false;
        this._queueMedia = new HashSet<String>();
        super.startDocument();
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!this._isSuperDevMode.booleanValue()) {
            if (this._isMinimizable(StringUtils.lowerCase((String)loc), a)) {
                this._isCurrentTagQueued = true;
                this._addToQueue(StringUtils.lowerCase((String)loc), a);
            } else {
                this._isCurrentTagQueued = false;
                if (this._filesQueue.size() > 0) {
                    this._processQueue();
                }
                super.startElement(uri, loc, raw, a);
            }
        } else {
            super.startElement(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (!this._isSuperDevMode.booleanValue()) {
            if (this._isCurrentTagQueued) {
                this._isCurrentTagQueued = false;
            } else {
                if (this._filesQueue.size() > 0) {
                    this._processQueue();
                }
                super.endElement(uri, loc, raw);
            }
        } else {
            super.endElement(uri, loc, raw);
        }
    }

    private boolean _isMinimizable(String tagName, Attributes attrs) {
        String type;
        if ("true".equals(attrs.getValue("data-donotminimize"))) {
            return false;
        }
        String uri = null;
        if ("script".equals(tagName)) {
            type = attrs.getValue("type");
            if (StringUtils.isNotEmpty((CharSequence)type) && !"text/javascript".equals(type) && !"application/javascript".equals(type)) {
                return false;
            }
            uri = attrs.getValue("src");
        }
        if ("link".equals(tagName)) {
            type = attrs.getValue("type");
            if (StringUtils.isNotEmpty((CharSequence)type) && !"text/css".equals(type)) {
                return false;
            }
            String rel = attrs.getValue("rel");
            if (!"stylesheet".equals(rel)) {
                return false;
            }
            uri = attrs.getValue("href");
        }
        if (StringUtils.isNotEmpty(uri)) {
            uri = FilenameUtils.normalize(uri, (boolean)true);
            uri = this._removeContextPath(uri);
            for (Pattern pattern : this._patterns) {
                Matcher matcher = pattern.matcher(uri);
                if (!matcher.find()) continue;
                return true;
            }
        }
        return false;
    }

    protected String _removeContextPath(String uri) {
        return StringUtils.removeStart((String)uri, (String)this._currentContextPath);
    }

    private void _addToQueue(String tagName, Attributes attrs) throws SAXException {
        String uri;
        String media;
        HashMap<String, String> fileOptions = new HashMap<String, String>();
        if (this._filesQueue.size() > 0) {
            boolean sameAsCurrentQueue = tagName.equals(this._queueTag);
            if (sameAsCurrentQueue && "link".equals(tagName)) {
                media = attrs.getValue("media");
                Set<String> medias = this._filterMediaValue(media);
                if (this._inlineCssMedias.booleanValue()) {
                    fileOptions.put("media", StringUtils.join(medias, (String)","));
                } else {
                    sameAsCurrentQueue = medias.equals(this._queueMedia);
                }
            }
            if (!sameAsCurrentQueue) {
                this._processQueue();
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(uri = FilenameUtils.normalize((String)("script".equals(tagName) ? attrs.getValue("src") : attrs.getValue("href")), (boolean)true)))) {
            uri = FilenameUtils.normalize((String)uri, (boolean)true);
            uri = this._removeContextPath(uri);
            fileOptions.put("tag", tagName);
            this._filesQueue.put(uri, fileOptions);
            if (this._filesQueue.size() == 1) {
                this._queueTag = tagName;
                if (!this._inlineCssMedias.booleanValue() && "link".equals(tagName)) {
                    media = attrs.getValue("media");
                    this._queueMedia = this._filterMediaValue(media);
                }
            }
        }
    }

    private void _processQueue() throws SAXException {
        String hash = this._hashCache.createHash(this._filesQueue, this.getHashSalt());
        AttributesImpl attrs = new AttributesImpl();
        String minimizeUrl = this._getMinimizeUrl();
        if ("script".equals(this._queueTag)) {
            attrs.addCDATAAttribute("type", "text/javascript");
            attrs.addCDATAAttribute("src", minimizeUrl + hash + ".js");
        }
        if ("link".equals(this._queueTag)) {
            String medias;
            attrs.addCDATAAttribute("type", "text/css");
            attrs.addCDATAAttribute("rel", "stylesheet");
            attrs.addCDATAAttribute("href", minimizeUrl + hash + ".css");
            if (!this._inlineCssMedias.booleanValue() && !this._queueMedia.isEmpty() && StringUtils.isNotEmpty((CharSequence)(medias = StringUtils.join(this._queueMedia, (String)",")))) {
                attrs.addCDATAAttribute("media", medias);
            }
        }
        super.startElement("", this._queueTag, this._queueTag, (Attributes)attrs);
        super.endElement("", this._queueTag, this._queueTag);
        this._queueTag = null;
        this._filesQueue.clear();
    }

    protected String getHashSalt() {
        return this._locale;
    }

    private Set<String> _filterMediaValue(String mediaValue) {
        HashSet<String> result = new HashSet<String>();
        if (mediaValue != null) {
            for (String media : StringUtils.split((String)mediaValue, (char)',')) {
                result.add(media.trim());
            }
            if (result.size() == 2 && result.contains("print") && result.contains("screen")) {
                result.clear();
            }
        }
        return result;
    }
}

