/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.minimize;

import com.google.debugging.sourcemap.SourceMapConsumerFactory;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.debugging.sourcemap.SourceMapping;
import com.google.debugging.sourcemap.proto.Mapping;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.minimize.SourceMapCache;
import org.ametys.core.ui.Callable;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;

public class UnminimizeHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    private static final String __MINIMIZED_RESOURCES_PREFIX = "/plugins/core-ui/resources-minimized/";
    protected SourceMapCache _sourceMapCache;
    protected Context _context;
    protected SourceResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceMapCache = (SourceMapCache)manager.lookup(SourceMapCache.ROLE);
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable
    public List<Map<String, String>> unminifyStackTrace(List<Map<String, String>> stacktraceData) throws SourceNotFoundException, IOException, SourceMapParseException {
        HashMap<String, String> resolvedCache = new HashMap<String, String>();
        Request request = ContextHelper.getRequest((Context)this._context);
        String workspaceURI = (String)request.getAttribute("workspaceURI");
        for (Map<String, String> data : stacktraceData) {
            if (!data.containsKey("filename") || !data.containsKey("column") || !data.containsKey("line")) continue;
            String sourceMapContent = this._getSourceMap(data.get("filename"), resolvedCache, workspaceURI);
            this._setMappingData(data, sourceMapContent);
        }
        return stacktraceData;
    }

    private String _getSourceMap(String filename, Map<String, String> resolvedCache, String workspaceURI) throws MalformedURLException, IOException, SourceNotFoundException {
        if (!filename.startsWith(workspaceURI + __MINIMIZED_RESOURCES_PREFIX)) {
            return null;
        }
        String mapFilename = filename.substring((workspaceURI + __MINIMIZED_RESOURCES_PREFIX).length()) + ".map";
        if (!resolvedCache.containsKey(mapFilename)) {
            Source source = this._sourceMapCache.get(mapFilename);
            if (source == null) {
                String uri = "cocoon://plugins/core-ui/resources-minimized/" + mapFilename;
                source = this._resolver.resolveURI(uri);
            }
            if (source != null) {
                InputStream is = source.getInputStream();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)is, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                resolvedCache.put(mapFilename, writer.toString());
            }
        }
        if (resolvedCache.containsKey(mapFilename)) {
            return resolvedCache.get(mapFilename);
        }
        return null;
    }

    private void _setMappingData(Map<String, String> data, String sourceMapContent) throws SourceMapParseException {
        SourceMapping mapping;
        Mapping.OriginalMapping mappingForEntry;
        if (sourceMapContent != null && (mappingForEntry = (mapping = SourceMapConsumerFactory.parse((String)sourceMapContent)).getMappingForLine(Integer.parseInt(data.get("line")), Integer.parseInt(data.get("column")))) != null) {
            data.put("realFilename", mappingForEntry.getOriginalFile());
            data.put("realLine", String.valueOf(mappingForEntry.getLineNumber()));
            data.put("realColumn", String.valueOf(mappingForEntry.getColumnPosition()));
        }
    }
}

