/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.minimize.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.ametys.core.minimize.css.MinimizeCSSManager;
import org.ametys.plugins.core.ui.minimize.AbstractMinimizeSourceMapReader;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.xml.sax.SAXException;

public class MinimizeCSSSourceMapReader
extends AbstractMinimizeSourceMapReader {
    private MinimizeCSSManager _cssMinimizeManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cssMinimizeManager = (MinimizeCSSManager)this.manager.lookup(MinimizeCSSManager.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        List<HashCache.UriData> filesForHash;
        Source sourceMap = this._sourceMapCache.get(this.source + ".map");
        if (sourceMap == null && (filesForHash = this._hashCache.getFilesForHash(this.source, true)) != null) {
            this._cssMinimizeManager.minimizeAndAggregateURIs(filesForHash, this.source + ".css", true);
            sourceMap = this._sourceMapCache.get(this.source + ".css.map");
        }
        if (sourceMap == null) {
            throw new IllegalStateException("There is no source map for minimized hash file '" + this.source + ".css'");
        }
        IOUtils.copy((InputStream)sourceMap.getInputStream(), (OutputStream)this.out);
        this.out.close();
    }
}

