/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURI;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.commons.lang3.StringUtils;

public class PluginsJSASSResourceURI
implements JSASSResourceURI,
PluginAware {
    private static final Pattern URI_SUPPORTED_PATTERN = Pattern.compile("^plugin(?::([^:]+))?://(.*)$");
    private static final Pattern PATH_SUPPORTED_PATTERN = Pattern.compile("^/plugins/([^/]+)/(.*)$");
    private String _pluginName;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    @Override
    public String resolve(String uri) {
        Matcher matcher = URI_SUPPORTED_PATTERN.matcher(uri);
        if (matcher.matches()) {
            String target = matcher.group(1);
            if (StringUtils.isEmpty((CharSequence)target)) {
                target = this._pluginName;
            }
            String path = matcher.group(2);
            StringBuilder relativeSb = new StringBuilder();
            relativeSb.append("/plugins/");
            relativeSb.append(target);
            relativeSb.append("/");
            relativeSb.append(path);
            return relativeSb.toString();
        }
        return null;
    }

    @Override
    public String resolvePath(String path) {
        Matcher matcher = PATH_SUPPORTED_PATTERN.matcher(path);
        if (matcher.matches()) {
            StringBuilder uri = new StringBuilder();
            uri.append("plugin:");
            uri.append(matcher.group(1));
            uri.append("://");
            uri.append(matcher.group(2));
            return uri.toString();
        }
        return null;
    }
}

