/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.less;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.plugins.core.ui.resources.AbstractCompiledResourceHandler;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class LessResourceHandler
extends AbstractCompiledResourceHandler {
    private static final Pattern __IMPORT_PATTERN = Pattern.compile("^@import\\b\\s*(?:(?:url)?\\(?\\s*[\"']?)([^)\"']*)[\"']?\\)?\\s*;?$", 10);
    private static final String[] __LESS_EXTENSION = new String[]{".less"};
    private DefaultLessCompiler _defaultLessCompiler;

    @Override
    public int getPriority() {
        return -2147482648;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isSupported(String source) {
        if (!super.isSupported(source)) {
            return false;
        }
        String lcSource = StringUtils.lowerCase((String)source);
        if (lcSource.endsWith(".css")) {
            String sourceWithExt = StringUtils.substringBeforeLast((String)source, (String)".css");
            for (String ext : __LESS_EXTENSION) {
                Source src;
                block7: {
                    boolean bl;
                    src = null;
                    try {
                        src = this._resolver.resolveURI(sourceWithExt + ext);
                        if (!src.exists()) break block7;
                        bl = true;
                    }
                    catch (IOException iOException) {
                        this._resolver.release(src);
                        continue;
                        catch (Throwable throwable) {
                            this._resolver.release(src);
                            throw throwable;
                        }
                    }
                    this._resolver.release(src);
                    return bl;
                }
                this._resolver.release(src);
            }
            return false;
        }
        return true;
    }

    @Override
    protected Source getCompiledSource(String location, Map<String, Object> additionalParameters) throws MalformedURLException, IOException {
        if (location.toLowerCase().endsWith(".css")) {
            String sourceWithExt = StringUtils.substringBeforeLast((String)location, (String)".css");
            for (String ext : __LESS_EXTENSION) {
                Source src = this._resolver.resolveURI(sourceWithExt + ext);
                if (!src.exists()) continue;
                return src;
            }
        }
        return this._resolver.resolveURI(location);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws ProcessingException, IOException {
        Source source = super.setup(location, objectModel, par, additionalParameters);
        this._defaultLessCompiler = new DefaultLessCompiler();
        return source;
    }

    @Override
    public String compileResource(Source source, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        LessCompiler.CompilationResult result = null;
        try (InputStream is = source.getInputStream();){
            String lessContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            AmetysLessSource stringSource = new AmetysLessSource(this._resolver, lessContent, new URI(source.getURI()));
            result = this._defaultLessCompiler.compile((LessSource)stringSource);
        }
        catch (Less4jException e) {
            throw new ProcessingException("Unable to compile the LESS file : " + source.getURI(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Unable to process LESS File, invalid uri : " + source.getURI(), (Throwable)e);
        }
        return result == null ? null : result.getCss();
    }

    @Override
    protected List<String> getDependenciesList(Source inputSource) {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream is = inputSource.getInputStream();){
            String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Matcher matcher = __IMPORT_PATTERN.matcher(content);
            while (matcher.find()) {
                String cssUrl = matcher.group(1);
                if (StringUtils.contains((CharSequence)cssUrl, (CharSequence)"http://") || StringUtils.contains((CharSequence)cssUrl, (CharSequence)"https://")) continue;
                if (!StringUtils.endsWith((CharSequence)cssUrl, (CharSequence)".css") && !StringUtils.endsWith((CharSequence)cssUrl, (CharSequence)".less")) {
                    cssUrl = cssUrl + ".less";
                }
                result.add(cssUrl);
            }
        }
        catch (IOException e) {
            this.getLogger().warn("Invalid content when listing dependencies for file " + inputSource.getURI(), (Throwable)e);
        }
        return result;
    }

    @Override
    public String getMimeType(Source source, Parameters par) {
        return "text/css";
    }

    private static class AmetysLessSource
    extends LessSource {
        private String _lessContent;
        private String _name;
        private URI _sourceUri;
        private SourceResolver _sResolver;

        public AmetysLessSource(SourceResolver sourceResolver, String lessContent, URI uri) {
            this._sResolver = sourceResolver;
            this._lessContent = lessContent;
            this._sourceUri = uri;
        }

        public LessSource relativeSource(String relativePath) throws LessSource.FileNotFound, LessSource.CannotReadFile, LessSource.StringSourceException {
            try {
                URI relativeSourceUri = new URI(relativePath);
                if (!relativeSourceUri.isAbsolute()) {
                    relativeSourceUri = new URI(FilenameUtils.getFullPath((String)this._sourceUri.toString()) + relativePath);
                }
                Source importSource = null;
                importSource = this._sResolver.resolveURI(relativeSourceUri.toString());
                String importText = IOUtils.toString((InputStream)importSource.getInputStream(), (String)"UTF-8");
                return new AmetysLessSource(this._sResolver, importText, relativeSourceUri);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to process LESS File : " + this._sourceUri + ", invalid import : " + relativePath, e);
            }
        }

        public String getContent() throws LessSource.FileNotFound, LessSource.CannotReadFile {
            return this._lessContent;
        }

        public byte[] getBytes() throws LessSource.FileNotFound, LessSource.CannotReadFile {
            try {
                return this._lessContent.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new LessSource.CannotReadFile();
            }
        }

        public URI getURI() {
            return this._sourceUri;
        }

        public String getName() {
            return this._name;
        }
    }
}

