/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.sass;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.ametys.plugins.core.ui.resources.ResourceDependenciesList;
import org.ametys.plugins.core.ui.resources.css.sass.SassImportHelper;
import org.ametys.plugins.core.ui.util.RequestAttributesHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class SassDependenciesList
extends AbstractLogEnabled
implements ResourceDependenciesList,
Serviceable {
    protected static final Pattern __IMPORT_PATTERN = Pattern.compile("^\\s*@import\\s+(?:(?:url)?\\(?\\s*[\"']?)([^)\"']+)[\"']?\\)?\\s*;?\\s*$", 10);
    protected static final String[] __SASS_EXTENSION = new String[]{".scss", ".sass"};
    protected RequestAttributesHelper _requestAttributesHelper;
    protected SourceResolver _sourceResolver;
    protected SassImportHelper _sassImportHelper;
    private Map<String, Pair<List<String>, Long>> _dependenciesCache = new ConcurrentHashMap<String, Pair<List<String>, Long>>();

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._requestAttributesHelper = (RequestAttributesHelper)manager.lookup(RequestAttributesHelper.ROLE);
        this._sassImportHelper = (SassImportHelper)manager.lookup(SassImportHelper.ROLE);
    }

    @Override
    public boolean isSupported(String uri) {
        if (StringUtils.endsWith((CharSequence)uri, (CharSequence)".css")) {
            return this.getSassImportInfo(uri) != null;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<HashCache.UriData> getDependenciesList(String uri, Map<String, String> data) {
        SassImportHelper.SassImportInfo fileSource = null;
        try {
            fileSource = this.getSassImportInfo(uri);
            if (fileSource != null) {
                Set<HashCache.UriData> set = this.getDependenciesList(uri, fileSource.getSource(), fileSource.getLastModified(), true);
                return set;
            }
        }
        finally {
            if (fileSource != null) {
                this._sourceResolver.release(fileSource.getSource());
            }
        }
        return new HashSet<HashCache.UriData>();
    }

    protected SassImportHelper.SassImportInfo getSassImportInfo(String uri) {
        String uriWithoutExtension = StringUtils.removeEnd((String)uri, (String)".css");
        return this._sassImportHelper.findExistingImportSource(Arrays.stream(__SASS_EXTENSION).map(ext -> uriWithoutExtension + ext).collect(Collectors.toList()));
    }

    private Set<HashCache.UriData> getDependenciesList(SassImportHelper.SassImportInfo sassImportInfo) {
        return this.getDependenciesList(sassImportInfo, false);
    }

    private Set<HashCache.UriData> getDependenciesList(SassImportHelper.SassImportInfo sassImportInfo, boolean firstLevel) {
        return this.getDependenciesList(sassImportInfo.getUri(), sassImportInfo.getSource(), sassImportInfo.getLastModified(), firstLevel);
    }

    private Set<HashCache.UriData> getDependenciesList(String uri, Source source, long lastModified, boolean firstLevel) {
        LinkedHashSet<HashCache.UriData> dependencies = new LinkedHashSet<HashCache.UriData>();
        HashCache.UriData fileInfos = new HashCache.UriData(uri, firstLevel);
        fileInfos.setLastModified(lastModified);
        dependencies.add(fileInfos);
        Pair<List<String>, Long> dependencyFromCache = this._dependenciesCache.get(uri);
        if (dependencyFromCache == null || (Long)dependencyFromCache.getRight() != lastModified) {
            ArrayList dependenciesCache = new ArrayList();
            Consumer<HashCache.UriData> addDependencyToCache = cssDependency -> {
                if (!dependenciesCache.contains(cssDependency.getUri())) {
                    dependenciesCache.add(cssDependency.getUri());
                    dependencies.add((HashCache.UriData)cssDependency);
                }
            };
            this._sassImportHelper.getDependenciesList(source).values().stream().map(sassImport -> this.getDependenciesList((SassImportHelper.SassImportInfo)sassImport)).flatMap(Collection::stream).forEach(addDependencyToCache);
            this._dependenciesCache.put(uri, (Pair<List<String>, Long>)Pair.of(dependenciesCache, (Object)lastModified));
        } else {
            ((List)dependencyFromCache.getLeft()).stream().map(uriFromCache -> this._sassImportHelper.getImportSource((String)uriFromCache)).filter(Objects::nonNull).map(sassImport -> this.getDependenciesList((SassImportHelper.SassImportInfo)sassImport)).forEach(subDependencies -> dependencies.addAll((Collection<HashCache.UriData>)subDependencies));
        }
        return dependencies;
    }
}

