/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.sass;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public class SassImportHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = SassImportHelper.class.getName();
    protected static final Pattern __IMPORT_PATTERN = Pattern.compile("^\\s*@import\\s+(?:(?:url)?\\(?\\s*[\"']?)([^)\"']+)[\"']?\\)?\\s*;?\\s*$", 10);
    protected SourceResolver _resolver;
    protected JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)manager.lookup(JSASSResourceURIExtensionPoint.ROLE);
    }

    public Map<String, SassImportInfo> getDependenciesList(Source inputSource) {
        HashMap<String, SassImportInfo> result = new HashMap<String, SassImportInfo>();
        try (InputStream is = inputSource.getInputStream();){
            String previous = inputSource.getURI();
            String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Matcher matcher = __IMPORT_PATTERN.matcher(content);
            while (matcher.find()) {
                SassImportInfo importSource;
                String cssUrl = matcher.group(1);
                if (StringUtils.contains((CharSequence)cssUrl, (CharSequence)"http://") || StringUtils.contains((CharSequence)cssUrl, (CharSequence)"https://")) continue;
                URI currentUri = new URI(cssUrl);
                if (!currentUri.isAbsolute()) {
                    currentUri = new URI(FilenameUtils.getFullPath((String)previous.toString()) + cssUrl);
                }
                if ((importSource = this.getImportSource(currentUri.toString())) == null) continue;
                result.put(importSource.getUri(), importSource);
            }
        }
        catch (IOException | URISyntaxException e) {
            this.getLogger().warn("Invalid " + inputSource.getURI(), (Throwable)e);
        }
        return result;
    }

    public SassImportInfo getImportSource(String currentUri) {
        ArrayList<String> uriMatching = new ArrayList<String>();
        uriMatching.add(currentUri);
        uriMatching.add(currentUri + ".scss");
        uriMatching.add(currentUri + ".sass");
        uriMatching.add(currentUri + ".css");
        String name = FilenameUtils.getName((String)currentUri);
        String partialUri = currentUri.substring(0, currentUri.length() - name.length()) + "_" + name;
        uriMatching.add(partialUri);
        uriMatching.add(partialUri + ".scss");
        uriMatching.add(partialUri + ".sass");
        uriMatching.add(partialUri + ".css");
        return this.findExistingImportSource(uriMatching);
    }

    public SassImportInfo findExistingImportSource(List<String> uriMatching) {
        for (String uri : uriMatching) {
            try {
                HashMap resolveParameters = new HashMap();
                String absoluteUri = new URI(uri).isAbsolute() ? uri : this._jsassResourceURIExtensionPoint.resolvePath(uri);
                Source importSource = this._resolver.resolveURI(absoluteUri, null, resolveParameters);
                if (!importSource.exists() || importSource instanceof TraversableSource && ((TraversableSource)importSource).isCollection()) continue;
                SassImportInfo sassImportInfo = new SassImportInfo(uri, importSource);
                sassImportInfo.setLastModified(resolveParameters.containsKey("lastModified") ? ((Long)resolveParameters.get("lastModified")).longValue() : importSource.getLastModified());
                return sassImportInfo;
            }
            catch (IOException | URISyntaxException exception) {
            }
        }
        return null;
    }

    public static class SassImportInfo {
        private String _uri;
        private Source _source;
        private Long _lastModified;

        SassImportInfo(String uri, Source source) {
            this._uri = uri;
            this._source = source;
        }

        public String getUri() {
            return this._uri;
        }

        public Source getSource() {
            return this._source;
        }

        public void setLastModified(Long lastModified) {
            this._lastModified = lastModified;
        }

        public long getLastModified() {
            return Optional.ofNullable(this._lastModified).orElse(this._source.getLastModified());
        }
    }
}

