/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.resources.css.sass;

import io.bit3.jsass.CompilationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.minimize.SourceMapCache;
import org.ametys.core.minimize.css.sass.MinimizeSassManager;
import org.ametys.core.resources.AbstractResourceHandler;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;

public class SassSourceMapResourceHandler
extends AbstractResourceHandler {
    private static final String[] __SASS_EXTENSION = new String[]{".scss", ".sass"};
    private static final String ADDITIONAL_PARAMETER_LOCATION = "location";
    private static final String ADDITIONAL_PARAMETER_MINIMIZE = "minimize";
    protected MinimizeSassManager _sassMinimizeManager;
    private SourceMapCache _sourceMapCache;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;
    private ProxiedContextPathProvider _proxiedContextPathProvider;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sourceMapCache = (SourceMapCache)manager.lookup(SourceMapCache.ROLE);
        this._sassMinimizeManager = (MinimizeSassManager)manager.lookup(MinimizeSassManager.ROLE);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)manager.lookup(JSASSResourceURIExtensionPoint.ROLE);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)manager.lookup(ProxiedContextPathProvider.ROLE);
    }

    @Override
    public boolean isSupported(String source) {
        if (!super.isSupported(source)) {
            return false;
        }
        String lcSource = StringUtils.lowerCase((String)source);
        if (lcSource.endsWith(".css.map")) {
            String sourceWithoutExt = StringUtils.substringBeforeLast((String)source, (String)".css.map");
            return this._getSassSourceFromCssUri(sourceWithoutExt) != null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Source _getSassSourceFromCssUri(String sourceWithoutExt) {
        for (String ext : __SASS_EXTENSION) {
            Source src;
            block5: {
                Source source;
                src = null;
                try {
                    src = this._resolver.resolveURI(sourceWithoutExt + ext);
                    if (!src.exists()) break block5;
                    source = src;
                }
                catch (IOException iOException) {
                    this._resolver.release(src);
                    continue;
                    catch (Throwable throwable) {
                        this._resolver.release(src);
                        throw throwable;
                    }
                }
                this._resolver.release(src);
                return source;
            }
            this._resolver.release(src);
        }
        return null;
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        String originalSassLocation = StringUtils.removeEnd((String)location, (String)".map");
        additionalParameters.put(ADDITIONAL_PARAMETER_LOCATION, location);
        if (StringUtils.endsWith((String)originalSassLocation, (String)".css")) {
            additionalParameters.put(ADDITIONAL_PARAMETER_MINIMIZE, true);
            Source sassSource = this._getSassSourceFromCssUri(StringUtils.removeEnd((String)originalSassLocation, (String)".css"));
            if (sassSource != null) {
                return sassSource;
            }
            throw new ResourceNotFoundException("Source map not found for URI : " + location);
        }
        return super.setup(originalSassLocation, objectModel, par, additionalParameters);
    }

    @Override
    public Serializable getKey(Source source, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) {
        boolean minimized = (Boolean)additionalParameters.getOrDefault(ADDITIONAL_PARAMETER_MINIMIZE, false);
        return super.getKey(source, objectModel, parameters, additionalParameters) + ".map" + (minimized ? "*min" : "");
    }

    @Override
    public void generateResource(Source source, OutputStream out, Map objectModel, Parameters parameters, Map<String, Object> additionalParameters) throws IOException, ProcessingException {
        String location = (String)additionalParameters.get(ADDITIONAL_PARAMETER_LOCATION);
        String sourceMapCacheKey = this._jsassResourceURIExtensionPoint.resolve(location);
        Source cachedSourceMap = this._sourceMapCache.get(sourceMapCacheKey);
        if (cachedSourceMap != null) {
            try (InputStream is = cachedSourceMap.getInputStream();){
                IOUtils.copy((InputStream)is, (OutputStream)out);
                return;
            }
        }
        boolean minimized = (Boolean)additionalParameters.getOrDefault(ADDITIONAL_PARAMETER_MINIMIZE, false);
        try (InputStream is = source.getInputStream();){
            String sassContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String extension = FilenameUtils.getExtension((String)source.getURI());
            String sourceMap = this._sassMinimizeManager.generateCssSourceMap(sassContent, location, extension, ContextHelper.getRequest((Context)this._context).getContextPath(), this._proxiedContextPathProvider.getContextPath(), minimized, source.getLastModified());
            IOUtils.write((String)sourceMap, (OutputStream)out, (String)"UTF-8");
        }
        catch (CompilationException | URISyntaxException e) {
            throw new ProcessingException("Unable to compile the SASS file: " + source.getURI(), e);
        }
    }
}

