/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.script;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.core.ui.script.ScriptBinding;
import org.ametys.plugins.core.ui.script.ScriptBindingExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;

public class ScriptHandler
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    private static final String __RIGHT_EXECUTE_SCRIPTS = "CORE_Rights_ExecuteScript";
    private static final String __SCRIPT_INSERT_CLEANUP_MANAGER = "var __cleanup_manager = { _registered:[], register: function (f) { this._registered.push(f) }, cleanup : function () { this._registered.forEach(function (f) {f()} ) } };";
    private static final String __SCRIPT_INSERT_RUN_MAIN = "var __result; try { __result = main(); } finally { __cleanup_manager.cleanup() } __result";
    protected ScriptBindingExtensionPoint _scriptBindingEP;
    protected RightManager _rightManager;
    protected CurrentUserProvider _currentUserProvider;
    protected Context _context;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._scriptBindingEP = (ScriptBindingExtensionPoint)serviceManager.lookup(ScriptBindingExtensionPoint.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Callable
    public Map<String, Object> executeScript(Map<String, Object> arguments) throws ScriptException {
        return this.executeScript((String)arguments.get("script"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable
    public Map<String, Object> executeScript(String script) throws ScriptException {
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), __RIGHT_EXECUTE_SCRIPTS, "/application") != RightManager.RightResult.RIGHT_ALLOW) {
            // empty if block
        }
        results.put("start", DateUtils.dateToString(new Date()));
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("javascript");
        StringWriter output = new StringWriter();
        PrintWriter pw = new PrintWriter(output);
        ScriptContext context = engine.getContext();
        context.setWriter(pw);
        StringWriter errorOutput = new StringWriter();
        PrintWriter errorPw = new PrintWriter(errorOutput);
        context.setErrorWriter(errorPw);
        context.setAttribute("javax.script.filename", "generated script", 200);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        List<ScriptBinding> scriptBindings = this.getScriptBindings();
        try {
            ArrayList<String> scriptText = new ArrayList<String>();
            scriptText.add(script);
            scriptText.add(__SCRIPT_INSERT_CLEANUP_MANAGER);
            this.setScriptBindings(variables, scriptText, scriptBindings);
            scriptText.add(__SCRIPT_INSERT_RUN_MAIN);
            SimpleBindings sb = new SimpleBindings();
            for (Map.Entry entry : variables.entrySet()) {
                sb.put((String)entry.getKey(), entry.getValue());
            }
            Object scriptResult = engine.eval(StringUtils.join(scriptText, (String)"\n"), (Bindings)sb);
            if (scriptResult != null) {
                results.put("result", this.processScriptResult(results, scriptBindings, scriptResult));
            }
            results.put("end", DateUtils.dateToString(new Date()));
        }
        catch (Throwable t) {
            try {
                results.put("message", StringUtils.defaultString((String)t.getMessage()));
                results.put("stacktrace", ExceptionUtils.getFullStackTrace((Throwable)t));
                this.getLogger().error("An exception occurred while running script", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                results.put("end", DateUtils.dateToString(new Date()));
                results.put("output", output.toString());
                results.put("error", errorOutput.toString());
                for (String extensionId : this._scriptBindingEP.getExtensionsIds()) {
                    ScriptBinding scriptBinding = (ScriptBinding)this._scriptBindingEP.getExtension(extensionId);
                    scriptBinding.cleanVariables(variables);
                }
            }
        }
        results.put("output", output.toString());
        results.put("error", errorOutput.toString());
        for (String extensionId : this._scriptBindingEP.getExtensionsIds()) {
            ScriptBinding scriptBinding = (ScriptBinding)this._scriptBindingEP.getExtension(extensionId);
            scriptBinding.cleanVariables(variables);
        }
        return results;
    }

    private void setScriptBindings(Map<String, Object> variables, List<String> scriptText, List<ScriptBinding> scriptBindings) {
        for (ScriptBinding scriptBinding : scriptBindings) {
            String scriptBindingFunctions;
            Map<String, Object> scriptBindingVariables = scriptBinding.getVariables();
            if (scriptBindingVariables != null) {
                variables.putAll(scriptBindingVariables);
            }
            if ((scriptBindingFunctions = scriptBinding.getFunctions()) == null) continue;
            scriptText.add(scriptBindingFunctions);
        }
    }

    protected Object processScriptResult(Map<String, Object> results, List<ScriptBinding> scriptBindings, Object scriptResult) throws ScriptException {
        Cloneable elements;
        for (ScriptBinding scriptBinding : scriptBindings) {
            Object processedResult = scriptBinding.processScriptResult(scriptResult);
            if (processedResult == null) continue;
            return processedResult;
        }
        if (scriptResult instanceof Collection) {
            elements = new ArrayList();
            for (Object obj : (Collection)scriptResult) {
                elements.add(this.processScriptResult(results, scriptBindings, obj));
            }
            return elements;
        }
        if (scriptResult instanceof Map) {
            elements = new HashMap();
            for (Object key : ((Map)scriptResult).keySet()) {
                Object value = ((Map)scriptResult).get(key);
                elements.put(this.processScriptResult(results, scriptBindings, key), this.processScriptResult(results, scriptBindings, value));
            }
            return elements;
        }
        return scriptResult.toString();
    }

    @Callable
    public Map<String, Object> getScriptBindingDescription() {
        HashMap<String, I18nizableText> variablesDesc = new HashMap<String, I18nizableText>();
        HashMap<String, I18nizableText> functionsDesc = new HashMap<String, I18nizableText>();
        List<ScriptBinding> scriptBindings = this.getScriptBindings();
        for (ScriptBinding scriptBinding : scriptBindings) {
            Map<String, I18nizableText> scriptBindingFunctionsDesc;
            Map<String, I18nizableText> scriptBindingVariablesDesc = scriptBinding.getVariablesDescriptions();
            if (scriptBindingVariablesDesc != null) {
                HashSet intersection = new HashSet(variablesDesc.keySet());
                intersection.retainAll(scriptBindingVariablesDesc.keySet());
                if (intersection.size() > 0) {
                    for (String variable : intersection) {
                        this.getLogger().warn("Multiple ScriptBinding use the same variable name : '" + variable + "'. Only one of these variables will be available.");
                    }
                }
                variablesDesc.putAll(scriptBindingVariablesDesc);
            }
            if ((scriptBindingFunctionsDesc = scriptBinding.getFunctionsDescriptions()) == null) continue;
            HashSet intersection = new HashSet(functionsDesc.keySet());
            intersection.retainAll(scriptBindingFunctionsDesc.keySet());
            if (intersection.size() > 0) {
                for (String function : intersection) {
                    this.getLogger().warn("Multiple ScriptBinding use the same function name : '" + function + "'. Your scripts may not be able to run properly.");
                }
            }
            functionsDesc.putAll(scriptBindingFunctionsDesc);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (variablesDesc.size() > 0) {
            result.put("variables", variablesDesc);
        }
        if (functionsDesc.size() > 0) {
            result.put("functions", functionsDesc);
        }
        return result;
    }

    protected List<ScriptBinding> getScriptBindings() {
        String workspaceName = Optional.ofNullable((String)ContextHelper.getRequest((Context)this._context).getAttribute("workspaceName")).orElse("admin");
        return this._scriptBindingEP.getExtensionsIds().stream().map(id -> (ScriptBinding)this._scriptBindingEP.getExtension((String)id)).filter(binding -> binding.getWorkspacePattern().matcher(workspaceName).matches()).collect(Collectors.toList());
    }
}

