/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.ametys.plugins.core.ui.script.ScriptBinding;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.SAXException;

public class StaticConfigurableScriptBinding
extends AbstractLogEnabled
implements ScriptBinding,
Configurable,
Serviceable,
PluginAware,
Contextualizable {
    protected SourceResolver _sourceResolver;
    protected List<String> _functions;
    protected Map<String, I18nizableText> _functionsDescriptions;
    protected String _pluginName;
    protected Pattern _workspacePattern;
    protected org.apache.avalon.framework.context.Context _context;

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String workspacePattern = configuration.getChild("workspace").getValue(".*");
        this._workspacePattern = Pattern.compile(workspacePattern);
        this._functions = new ArrayList<String>();
        this._functionsDescriptions = new HashMap<String, I18nizableText>();
        String filePath = configuration.getChild("file").getValue(null);
        String pluginName = configuration.getChild("file").getAttribute("plugin", this._pluginName);
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            Configuration descriptionsConf;
            Configuration fileConfiguration = this._getFileConfiguration(pluginName, filePath, configuration);
            Configuration scriptConf = fileConfiguration.getChild("script", false);
            if (scriptConf != null) {
                this._functions.add(scriptConf.getValue());
            }
            if ((descriptionsConf = fileConfiguration.getChild("descriptions", false)) != null) {
                for (Configuration descriptionConf : descriptionsConf.getChildren("description")) {
                    Configuration nameConf = descriptionConf.getChild("name", false);
                    Configuration textConf = descriptionConf.getChild("text", false);
                    if (nameConf == null || textConf == null) continue;
                    this._functionsDescriptions.put(nameConf.getValue(), I18nizableText.parseI18nizableText(textConf, "plugin.core-ui", ""));
                }
            }
        }
    }

    private Configuration _getFileConfiguration(String pluginName, String filePath, Configuration initialConfiguration) {
        try {
            Configuration fileConfiguration = this._getFileConfiguration(pluginName, filePath);
            if (fileConfiguration == null) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("No script binding file was found at " + filePath + ". Using internally declared config.");
                }
                return initialConfiguration;
            }
            return fileConfiguration;
        }
        catch (IOException | ConfigurationException | ContextException | SAXException exception) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("No script binding file was found at " + filePath + ". Using internally declared config.", exception);
            }
            return initialConfiguration;
        }
    }

    private Configuration _getFileConfiguration(String pluginName, String filePath) throws ContextException, ConfigurationException, SAXException, IOException {
        String configPath = null;
        if (filePath.startsWith("/")) {
            Context ctx = (Context)this._context.get((Object)"environment-context");
            String contextPath = ctx.getRealPath("/");
            File configFile = new File(contextPath, filePath);
            configPath = configFile.getAbsolutePath();
            if (!configFile.exists() || configFile.isDirectory()) {
                return null;
            }
            try (FileInputStream is = new FileInputStream(configFile);){
                Configuration configuration = new DefaultConfigurationBuilder(true).build((InputStream)is, configPath);
                return configuration;
            }
        }
        PluginsManager pluginManager = PluginsManager.getInstance();
        String baseUri = pluginManager.getResourceURI(pluginName);
        if (baseUri == null) {
            File pluginLocation = pluginManager.getPluginLocation(pluginName);
            File configFile = new File(pluginLocation, filePath);
            configPath = configFile.getAbsolutePath();
            if (!configFile.exists() || configFile.isDirectory()) {
                return null;
            }
            try (FileInputStream is = new FileInputStream(configFile);){
                Configuration configuration = new DefaultConfigurationBuilder(true).build((InputStream)is, configPath);
                return configuration;
            }
        }
        String uri = baseUri + "/" + filePath;
        Source source = this._sourceResolver.resolveURI(uri);
        try (InputStream is = source.getInputStream();){
            if (is == null) {
                Configuration configuration = null;
                return configuration;
            }
            Configuration configuration = new DefaultConfigurationBuilder(true).build(is, uri);
            return configuration;
        }
    }

    @Override
    public Pattern getWorkspacePattern() {
        return this._workspacePattern;
    }

    @Override
    public String getFunctions() {
        return StringUtils.join(this._functions, (String)"\n");
    }

    @Override
    public Map<String, I18nizableText> getFunctionsDescriptions() {
        return this._functionsDescriptions;
    }

    @Override
    public Map<String, Object> getVariables() {
        return null;
    }

    @Override
    public Map<String, I18nizableText> getVariablesDescriptions() {
        return null;
    }

    @Override
    public void cleanVariables(Map<String, Object> variables) {
    }

    @Override
    public Object processScriptResult(Object result) throws ScriptException {
        return null;
    }
}

