/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.core.ui.user;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.ametys.core.upload.UploadManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.ImageHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.ui.user.ProfileImageProvider;
import org.ametys.plugins.core.ui.user.SafeProfileImageProvider;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.xml.sax.SAXException;

public class DefaultProfileImageProvider
extends SafeProfileImageProvider
implements Contextualizable,
Component {
    public static final String USER_PROFILE_PREF_CONTEXT = "/profile";
    public static final String USERPREF_PROFILE_IMAGE = "profile-image";
    protected static final String __AVATAR_DIR_NAME = "avatar";
    protected static final String __INITIALS_DIR_NAME = "initials";
    protected static Map<String, String> __avatarPaths;
    protected static List<String> __initialsBgPaths;
    protected UploadManager _uploadManager;
    protected UserPreferencesManager _userPreferencesManager;
    protected JSONUtils _jsonUtils;
    private Context _context;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._uploadManager = (UploadManager)smanager.lookup(UploadManager.ROLE);
        this._userPreferencesManager = (UserPreferencesManager)((Object)smanager.lookup(UserPreferencesManager.ROLE));
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public ProfileImageProvider.UserProfileImage getImage(UserIdentity user, String imageSource, int size, int maxSize) throws ProcessingException {
        ProfileImageSource profileImageSource = this.getProfileImageSource(imageSource);
        if (profileImageSource == null) {
            profileImageSource = ProfileImageSource.USERPREF;
        }
        Map<String, Object> sourceParams = this._extractSourceParameters(user, profileImageSource);
        ProfileImageProvider.UserProfileImage image = null;
        if (sourceParams != null) {
            if (size > 0) {
                sourceParams.put("size", size);
            }
            if (maxSize > 0) {
                sourceParams.put("maxSize", maxSize);
            }
            if ((image = this.getImage(profileImageSource, user, sourceParams)) == null && ProfileImageSource.USERPREF.equals((Object)profileImageSource) && (image = this.getGravatarImage(user, size > 0 ? size : maxSize)) == null) {
                image = this.getInitialsImage(user);
            }
        }
        if (image == null && (image = this.getDefaultImage()) == null) {
            throw new ProcessingException(String.format("Not able to provide an image from source '%s' for user '%s' because no image was found.", new Object[]{profileImageSource, user}));
        }
        return image;
    }

    public ProfileImageSource getProfileImageSource(String imageSourceStr) {
        ProfileImageSource profileImageSource;
        block3: {
            profileImageSource = null;
            try {
                if (StringUtils.isNotEmpty((CharSequence)imageSourceStr)) {
                    profileImageSource = ProfileImageSource.valueOf(imageSourceStr.toUpperCase());
                }
            }
            catch (IllegalArgumentException e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("Unknown profile image source " + imageSourceStr + ".", (Throwable)e);
            }
        }
        return profileImageSource;
    }

    protected Map<String, Object> _extractSourceParameters(UserIdentity user, ProfileImageSource profileImageSource) throws ResourceNotFoundException {
        Request request = ContextHelper.getRequest((Context)this._context);
        switch (profileImageSource) {
            case UPLOAD: {
                return this._extractUploadParameters(request, user);
            }
            case LOCALIMAGE: {
                return this._extractLocalImageParameters(request, user);
            }
            case BASE64: {
                return this._extractBase64Parameters(request, user);
            }
            case INITIALS: 
            case USERSMANAGER: 
            case USERPREF: 
            case GRAVATAR: 
            case DEFAULT: {
                return new HashMap<String, Object>();
            }
        }
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.format("Cannot extract image source parameters for user '%s'. Unhandled profile image source '%s'", new Object[]{user, profileImageSource}));
        }
        return null;
    }

    protected Map<String, Object> _extractUploadParameters(Request request, UserIdentity user) {
        String uploadId = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)uploadId)) {
            this.getLogger().error("Missing mandatory uploaded file id parameter to retrieve the uploaded file for user " + user + ".");
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", uploadId);
        return params;
    }

    protected Map<String, Object> _extractLocalImageParameters(Request request, UserIdentity user) {
        String localFileId = request.getParameter("id");
        if (StringUtils.isEmpty((CharSequence)localFileId)) {
            this.getLogger().error("Missing mandatory local file id parameter to retrieve the local file for user " + user + ".");
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", localFileId);
        return params;
    }

    protected Map<String, Object> _extractBase64Parameters(Request request, UserIdentity user) {
        String data = request.getParameter("data");
        if (StringUtils.isEmpty((CharSequence)data)) {
            this.getLogger().error("Missing mandatory data parameter for user image of type base 64 user " + user + ".");
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", data);
        String filename = request.getParameter("filename");
        if (StringUtils.isNotEmpty((CharSequence)filename)) {
            params.put("filename", filename);
        }
        return params;
    }

    public ProfileImageProvider.UserProfileImage getImage(ProfileImageSource source, UserIdentity user, Map<String, Object> sourceParams) {
        switch (source) {
            case USERPREF: {
                return this.getUserPrefImage(user, sourceParams);
            }
            case GRAVATAR: {
                return this.getGravatarImage(user, this._getGravatarSize(sourceParams));
            }
            case UPLOAD: {
                return this.getUploadedImage(user, (String)sourceParams.get("id"));
            }
            case LOCALIMAGE: {
                return this.getLocalImage(user, (String)sourceParams.get("id"));
            }
            case INITIALS: {
                return this.getInitialsImage(user);
            }
            case BASE64: {
                return this.getBase64Image(user, (String)sourceParams.get("data"), (String)sourceParams.get("filename"));
            }
            case DEFAULT: {
                return this.getDefaultImage();
            }
        }
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn(String.format("Cannot get image for user '%s'. Unhandled profile image source '%s'", new Object[]{user, source}));
        }
        return null;
    }

    public ProfileImageProvider.UserProfileImage getBase64Image(UserIdentity user, String data, String filename) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(String.format("No data provided. Unable to retrieve the base64 image for user '%s'.", user));
            }
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(new Base64(true).decode(data));
        return new ProfileImageProvider.UserProfileImage(is, (String)StringUtils.defaultIfBlank((CharSequence)filename, null), null);
    }

    private Integer _getGravatarSize(Map<String, Object> sourceParams) {
        Integer size = (Integer)sourceParams.get("size");
        if (size != null && size > 0) {
            return size;
        }
        Integer maxSize = (Integer)sourceParams.get("maxSize");
        if (maxSize != null && maxSize > 0) {
            return maxSize;
        }
        return null;
    }

    public ProfileImageProvider.UserProfileImage getUserPrefImage(UserIdentity user, Map<String, Object> baseSourceParams) {
        Map<String, Object> userPrefImgData = this._getRawUserPrefImage(user);
        if (userPrefImgData != null) {
            String rawImageSource = (String)userPrefImgData.remove("source");
            ProfileImageSource profileImageSource = this.getProfileImageSource(rawImageSource);
            if (profileImageSource == null || ProfileImageSource.USERPREF.equals((Object)profileImageSource)) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("An profile image seems to be stored as an userpref but its image source is empty, not handled or corrupted");
                }
                return null;
            }
            HashMap<String, Object> sourceParams = (HashMap<String, Object>)userPrefImgData.get("parameters");
            if (sourceParams != null) {
                sourceParams.putAll(baseSourceParams);
            } else {
                sourceParams = new HashMap<String, Object>(baseSourceParams);
            }
            return this.getImage(profileImageSource, user, sourceParams);
        }
        return null;
    }

    public Map<String, Object> hasUserPrefImage(UserIdentity user) {
        String rawImageSource;
        ProfileImageSource profileImageSource;
        Map<String, Object> userPrefImgData = this._getRawUserPrefImage(user);
        if (userPrefImgData != null && (profileImageSource = this.getProfileImageSource(rawImageSource = (String)userPrefImgData.get("source"))) != null) {
            return userPrefImgData;
        }
        return null;
    }

    private Map<String, Object> _getRawUserPrefImage(UserIdentity user) {
        try {
            String userPrefImgJson = this._userPreferencesManager.getUserPreferenceAsString(user, USER_PROFILE_PREF_CONTEXT, Collections.EMPTY_MAP, USERPREF_PROFILE_IMAGE);
            if (StringUtils.isNotEmpty((CharSequence)userPrefImgJson)) {
                return this._jsonUtils.convertJsonToMap(userPrefImgJson);
            }
        }
        catch (Exception e) {
            this.getLogger().error(String.format("Unable to retrieve the '%s' userpref on context '%s' for user '%s'", USERPREF_PROFILE_IMAGE, USER_PROFILE_PREF_CONTEXT, user), (Throwable)e);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public ProfileImageProvider.UserProfileImage getUploadedImage(UserIdentity user, String uploadId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BufferedImage cropUploadedImage(InputStream is) throws IOException {
        int height;
        BufferedImage image = ImageHelper.read(is);
        int width = image.getWidth();
        if (width != (height = image.getHeight())) {
            int min = Math.min(width, height);
            image = image.getSubimage((width - min) / 2, 0, min, min);
        }
        return ImageHelper.generateThumbnail(image, 0, 0, 64, 64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLocalImage(String localFileId) {
        Source imgSource = null;
        try {
            imgSource = this._getLocalImageSource(localFileId);
            if (imgSource == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(String.format("Unable to test the local image for id '%s.", localFileId));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = imgSource.exists();
            return bl;
        }
        catch (IOException e) {
            this.getLogger().error(String.format("Unable to  test the local image for id '%s' and login '%s'.", localFileId), (Throwable)e);
        }
        finally {
            if (imgSource != null) {
                this._sourceResolver.release(imgSource);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileImageProvider.UserProfileImage getLocalImage(UserIdentity user, String localFileId) {
        Source imgSource = null;
        try {
            imgSource = this._getLocalImageSource(localFileId);
            if (imgSource == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn(String.format("Unable to retrieve the local image for id '%s' and login '%s'.", localFileId, user));
                }
                ProfileImageProvider.UserProfileImage userProfileImage = null;
                return userProfileImage;
            }
            if (imgSource.exists()) {
                String avatarPath = this._getLocalImagePaths().get(localFileId);
                ProfileImageProvider.UserProfileImage userProfileImage = new ProfileImageProvider.UserProfileImage(imgSource.getInputStream(), FilenameUtils.getName((String)avatarPath), null);
                return userProfileImage;
            }
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn(String.format("Unable to find any local image with id '%s' for user '%s'", localFileId, user));
            }
        }
        catch (IOException e) {
            this.getLogger().error(String.format("Unable to retrieve the local image for id '%s' and login '%s'.", localFileId, user), (Throwable)e);
        }
        finally {
            if (imgSource != null) {
                this._sourceResolver.release(imgSource);
            }
        }
        return null;
    }

    protected Source _getLocalImageSource(String localFileId) throws IOException {
        String avatarPath;
        Map<String, String> imgPaths = this._getLocalImagePaths();
        String string = avatarPath = imgPaths != null ? imgPaths.get(localFileId) : "";
        if (StringUtils.isEmpty((CharSequence)avatarPath)) {
            return null;
        }
        String location = "plugin:core-ui://resources/img/user-profiles/avatar/" + avatarPath;
        return this._sourceResolver.resolveURI(location);
    }

    public List<String> getLocalImageIds() {
        return new LinkedList<String>(this._getLocalImagePaths().keySet());
    }

    protected Map<String, String> _getLocalImagePaths() {
        this._initializeLocalImagePaths();
        return __avatarPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initializeLocalImagePaths() {
        Class<DefaultProfileImageProvider> clazz = DefaultProfileImageProvider.class;
        synchronized (DefaultProfileImageProvider.class) {
            if (__avatarPaths == null) {
                __avatarPaths = new LinkedHashMap<String, String>();
                String location = "plugin:core-ui://resources/img/user-profiles/avatar/avatar.xml";
                Source source = null;
                try {
                    source = this._sourceResolver.resolveURI(location);
                    try (InputStream is = source.getInputStream();){
                        Configuration cfg = new DefaultConfigurationBuilder().build(is);
                        for (Configuration imageCfg : cfg.getChildren("image")) {
                            __avatarPaths.put(imageCfg.getAttribute("id"), imageCfg.getValue());
                        }
                    }
                }
                catch (IOException | ConfigurationException | SAXException e) {
                    this.getLogger().error("Unable to retrieve the map of local image paths", e);
                }
                finally {
                    if (source != null) {
                        this._sourceResolver.release(source);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasInitialsImage(UserIdentity userIdentity) {
        User user = this._userManager.getUser(userIdentity.getPopulationId(), userIdentity.getLogin());
        if (user == null) {
            this.getLogger().warn("Unable to test the initials image - user not found " + userIdentity);
            return false;
        }
        String initial = user.getFullName().substring(0, 1).toLowerCase();
        Source imgSource = null;
        try {
            imgSource = this._getInitialsImageSource(initial);
            boolean bl = imgSource.exists();
            return bl;
        }
        catch (IOException e) {
            this.getLogger().error(String.format("Unable to test initials image for user '%s' with fullname '%s'.", userIdentity, user.getFullName()), (Throwable)e);
        }
        finally {
            if (imgSource != null) {
                this._sourceResolver.release(imgSource);
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public ProfileImageProvider.UserProfileImage getInitialsImage(UserIdentity userIdentity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Source _getInitialsImageSource(String initial) throws IOException {
        String location = "plugin:core-ui://resources/img/user-profiles/initials/" + initial + ".png";
        return this._sourceResolver.resolveURI(location);
    }

    /*
     * Loose catch block
     */
    protected InputStream _addImageBackground(UserIdentity user, InputStream is) throws IOException {
        BufferedImage image = ImageIO.read(is);
        Source bgSource = null;
        try {
            bgSource = this._getInitialsBackgroundSource(user);
            BufferedImage background = null;
            try (InputStream backgroundIs = bgSource.getInputStream();){
                background = ImageIO.read(backgroundIs);
                Graphics backgroundGraphics = background.getGraphics();
                backgroundGraphics.drawImage(image, 0, 0, null);
            }
            var7_7 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)background, "png", baos);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                return byteArrayInputStream;
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this._sourceResolver.release(bgSource);
        }
    }

    protected Source _getInitialsBackgroundSource(UserIdentity user) throws IOException {
        long hash = Math.abs(HashUtil.hash((String)user.getLogin()));
        this._initializeInitialsBackgroundPaths();
        long nbBackground = __initialsBgPaths.size();
        if (nbBackground == 0L) {
            throw new IOException("No backgrounds available.");
        }
        int indexBackground = (int)(hash % nbBackground);
        String path = __initialsBgPaths.get(indexBackground);
        String location = "plugin:core-ui://resources/img/user-profiles/initials/" + path;
        return this._sourceResolver.resolveURI(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initializeInitialsBackgroundPaths() {
        Class<DefaultProfileImageProvider> clazz = DefaultProfileImageProvider.class;
        synchronized (DefaultProfileImageProvider.class) {
            if (__initialsBgPaths == null) {
                __initialsBgPaths = new LinkedList<String>();
                String location = "plugin:core-ui://resources/img/user-profiles/initials/initials.xml";
                Source source = null;
                try {
                    source = this._sourceResolver.resolveURI(location);
                    try (InputStream is = source.getInputStream();){
                        Configuration cfg = new DefaultConfigurationBuilder().build(is);
                        for (Configuration backgroundCfg : cfg.getChildren("background")) {
                            __initialsBgPaths.add(backgroundCfg.getValue());
                        }
                    }
                }
                catch (IOException | ConfigurationException | SAXException e) {
                    this.getLogger().error("Unable to retrieve the list of available backgrounds for initials images", e);
                }
                finally {
                    if (source != null) {
                        this._sourceResolver.release(source);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static enum ProfileImageSource {
        LOCALIMAGE,
        GRAVATAR,
        USERSMANAGER,
        INITIALS,
        UPLOAD,
        BASE64,
        USERPREF,
        DEFAULT;

    }
}

